package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.zip.GZIPInputStream;
import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;

/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public static String ProvidentFundServices(HttpServletRequest request) {
        //-----------------------------------------------------
        StringBuffer json = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
//                System.out.println("line:" + line);
                json.append(line);
            }
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        String str = json.toString();
        //-----------------------------------------------------
        String token = null;
        token = huoqutoken();//调用获取token的方法
        System.out.println(token);
        System.out.println("zip压缩处理之前要发送给第三方的公积金系统服务报文：" + str);
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
                URL url = new URL("http://59.208.149.225:18080/sjzt/api/dx/e39a08e0a52b413897f9d23359540b27/GJJ?access_token="+token);//测试环境第三方地址
//            URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices2?access_token=" + token);//本地模拟第三方地址
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                GZIPInputStream gzis = new GZIPInputStream(is);
                InputStreamReader reader = new InputStreamReader(gzis,"UTF-8");
                BufferedReader br = new BufferedReader(reader);
                String temp;
                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }
                System.out.println("公积金服务第三方返回的zip解压缩之后的报文：" + sb.toString());
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /**
     * 模拟公积金系统服务接口请求第三方，获取第三方返回的单位开户信息测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices2")
    public String ProvidentFundServices2(HttpServletRequest request) {
        //-----------------------------------------------------
        StringBuffer json = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
//                System.out.println("line:" + line);
                json.append(line);
            }
        } catch (Exception e) {
            System.out.println(e.toString());
        }
        String str1 = json.toString();
        System.out.println("第三方接收的公积金服务接口参数解压之前"+str1);
        String str2 = unzipString(str1);//解压缩
        System.out.println("第三方接收的公积金服务接口参数解压之后"+str2);
        //-----------------------------------------------------
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 0);
        jsonObject.put("message", "数据交换成功");
        List<UnitAccountOpeningInformation> list = new ArrayList<>();
//        UnitAccountOpeningInformation openingInformation = new UnitAccountOpeningInformation();
//        openingInformation.setBusId("332090890");
//        openingInformation.setUscc("914205007146987888");
//        openingInformation.setEntName("湖北稻花香酒业股份有限公司(华润测试)");
//        openingInformation.setDom("湖北省宜昌市龙泉镇圣诞快乐房价数量的方式独立开发huahua7888");
////        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
//        openingInformation.setEstDate(new Date());
//        openingInformation.setLerep("蔡开云");
//        openingInformation.setCerType("10");
//        openingInformation.setCerNo("421121199402084030");
//        openingInformation.setOperatorName("张文");
//        openingInformation.setOperatorCerNo("421121199402084030");
//        openingInformation.setOperatorPhone("13345678899");
//        openingInformation.setOplocdistrict("421101001");
//        openingInformation.setUnitNature("01");
//        openingInformation.setEconomicType("1222");
//        openingInformation.setIndustryphy("C1512");
//        openingInformation.setUnitPayDay("05");
//        openingInformation.setUnitDepPro("12");
//        openingInformation.setPersonalDepPro("12");
//        //-------------------------------------
//        UnitAccountOpeningInformation openingInformation2 = new UnitAccountOpeningInformation();
//        openingInformation2.setBusId("332090891");
//        openingInformation2.setUscc("914205007146987889");
//        openingInformation2.setEntName("湖北稻花香酒业股份有限公司(华润测试)");
//        openingInformation2.setDom("湖北省宜昌市龙泉镇圣诞快乐房价数量的方式独立开发huahua7889");
////        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
//        openingInformation2.setEstDate(new Date());
//        openingInformation2.setLerep("蔡开云");
//        openingInformation2.setCerType("10");
//        openingInformation2.setCerNo("421121199402084030");
//        openingInformation2.setOperatorName("张文");
//        openingInformation2.setOperatorCerNo("421121199402084030");
//        openingInformation2.setOperatorPhone("13345678899");
//        openingInformation2.setOplocdistrict("421101001");
//        openingInformation2.setUnitNature("01");
//        openingInformation2.setEconomicType("1222");
//        openingInformation2.setIndustryphy("C1512");
//        openingInformation2.setUnitPayDay("05");
//        openingInformation2.setUnitDepPro("12");
//        openingInformation2.setPersonalDepPro("12");
//        list.add(openingInformation);
//        list.add(openingInformation2);
        jsonObject.put("data", list);
        String str = jsonObject.toString();
        return str;
    }

    /**
     * 获取token专用方法
     *
     * @return
     */
    @ResponseBody
    @PostMapping("huoqutoken")
    public static String huoqutoken() {
        String token = null;
        token = CacheDemoController.getToken();//优先从内存中拿
        if (!"".equals(token) && token != null) {//若token未过期，则用内存中的token

        } else {//若token已过期，则重新调用鉴权认证接口获取token存入内存中
            CacheDemoController.saveToken();
            token = CacheDemoController.getToken();
        }
        return token;
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("BusinessProcessing")
    public static String BusinessProcessing(HttpServletRequest request) {
        System.out.println("继续调前置机的进度第二个接口");
        //-----------------------------------------------------
        StringBuffer json = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
//                System.out.println("line:" + line);
                json.append(line);
            }
        } catch (Exception e) {
            System.out.println(e.toString());

        }
        String str = json.toString();
        //-----------------------------------------------------
        String token = null;
        token = huoqutoken();//调用获取token的方法
        System.out.println("zip压缩处理之前要发送给第三方的进度参数报文：" + str);
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
                URL url = new URL("http://59.208.149.225:18080/sjzt/api/testretGjjProgData?access_token="+token);//正式第三方地址
//            URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/BusinessProcessing2?access_token=" + token);//本地模拟第三方地址
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            conn.setRequestProperty("accept", "*/*");
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate, br");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                GZIPInputStream gzis = new GZIPInputStream(is);
                InputStreamReader reader = new InputStreamReader(gzis,"UTF-8");
                BufferedReader br = new BufferedReader(reader);
                String temp;
                while ((temp = br.readLine()) != null) {
                    sb.append(temp);
                }
                System.out.println("第三方返回的zip解压缩之后的进度结果报文：" + sb.toString());
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /**
     * 模拟住建部门返回公积金办理进度数据接口请求第三方，获取第三方返回的数据
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("BusinessProcessing2")
    public String BusinessProcessing2() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("success", "true");
        jsonObject.put("msg", "系统内部错误");
        String str = jsonObject.toString();
        String s = zipString(str);//进行zip压缩
        return s;
    }

}
