package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;

/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public static String ProvidentFundServices() {
        String token = null;
        token = huoqutoken();//调用获取token的方法
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime", currenttime(0));
        jsonObject.put("endTime", currenttime(24));
        jsonObject.put("app_id", "xxxxx");
        jsonObject.put("app_secret", "xxxxx");
        String str = jsonObject.toString();
//        String str = jsonstr;
        System.out.println("zip压缩处理之前要发送给第三方的报文：" + str);
        String s = zipString(str);//进行zip压缩
        System.out.println("zip压缩处理之后发送给第三方的报文：" + s);
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
//                URL url = new URL("https://scjg.hubei.gov.cn/sjzt/api/dx/e39a08e0a52b413897f9d23359540b27/GJJ?access_token="+token);//正式第三方地址
            URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices2?access_token=" + token);//测试第三方地址
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
                System.out.println("第三方返回的zip压缩过的报文：" + sb.toString());
                String s1 = unzipString(sb.toString());//将第三方返回的压缩过的json字符串解压缩
                System.out.println("第三方返回的zip解压缩之后的报文：" + s1);
                return s1;
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }

        return null;
    }

    /**
     * 模拟公积金系统服务接口请求第三方，获取第三方返回的单位开户信息测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices2")
    public String ProvidentFundServices2() {
        String resp = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 0);
        jsonObject.put("message", "数据交换成功");
        List<UnitAccountOpeningInformation> data = new ArrayList<>();
        UnitAccountOpeningInformation openingInformation = new UnitAccountOpeningInformation();
        openingInformation.setBusId("332090874");
        openingInformation.setUscc("914205007146986277");
        openingInformation.setEntName("湖北稻花香酒业股份有限公司(华润测试)");
        openingInformation.setDom("湖北省宜昌市龙泉镇圣诞快乐房价数量的方式独立开发");
//        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        openingInformation.setEstDate(new Date());
        openingInformation.setLerep("蔡开云");
        openingInformation.setCerType("10");
        openingInformation.setCerNo("421121199402084030");
        openingInformation.setOperatorName("张文");
        openingInformation.setOperatorCerNo("421121199402084030");
        openingInformation.setOperatorPhone("13345678899");
        openingInformation.setOplocdistrict("421101001");
        openingInformation.setUnitNature("01");
        openingInformation.setEconomicType("1222");
        openingInformation.setIndustryphy("C1512");
        openingInformation.setUnitPayDay("05");
        openingInformation.setUnitDepPro("12");
        openingInformation.setPersonalDepPro("12");
        data.add(openingInformation);
        jsonObject.put("data", data);
        String str = jsonObject.toString();
        String s = zipString(str);//进行zip压缩
//        System.out.println(s);
//        String s1 = unzipString(s);//解压缩
//        System.out.println(s1);
        return s;
    }

    /**
     * 获取当天零点零分零秒的时间戳和当天24点的时间戳
     *
     * @return
     */
    @ResponseBody
    @PostMapping("currentime")
    public static String currenttime(int type) {
        String time = null;
        if (type == 0) {
            // 获取当天零点零分零秒的时间戳
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 0);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        } else if (type == 24) {
            // 获取当天24点零分零秒的时间戳,即第二天零点时间
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 24);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        }
        return time;
    }

    /**
     * 获取token专用方法
     *
     * @return
     */
    @ResponseBody
    @PostMapping("huoqutoken")
    public static String huoqutoken() {
        String token = null;
        token = CacheDemoController.getToken();//优先从内存中拿
        if (!"".equals(token) && token != null) {//若token未过期，则用内存中的token

        } else {//若token已过期，则重新调用鉴权认证接口获取token存入内存中
            CacheDemoController.saveToken();
            token = CacheDemoController.getToken();
        }
        return token;
    }

    /**
     * 将从第三方拿到的单位开户的json信息通过调用oracle存储过程传给数据库处理
     *
     * @return
     */
    @ResponseBody
    @PostMapping("getuniAccounInfom")
    public static UnitAccountOpeningInformation getuniAccounInfom() throws Exception{
        String jsoninfom=ProvidentFundServices();
        JSONObject jsonObj = JSONObject.parseObject(jsoninfom);
        String str=jsonObj.get("data").toString();
        String str1=str.replace("[","");
        String str2=str1.replace("]","");
        UnitAccountOpeningInformation uniInfom = JSONObject.parseObject(str2,UnitAccountOpeningInformation.class);
        System.out.println(uniInfom);
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
        Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");
        //得到预编译的Statement对象
        CallableStatement pstm=connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_SL(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        //给参数赋值
//        pstm.getString(1);
        pstm.registerOutParameter(1,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.setString(2,uniInfom.getBusId());
        pstm.setString(3,uniInfom.getUscc());
        pstm.setString(4,uniInfom.getEntName());
        pstm.setString(5,uniInfom.getDom());
        pstm.setDate(6,new java.sql.Date(uniInfom.getEstDate().getTime()));
        pstm.setString(7,uniInfom.getLerep());
        pstm.setString(8,uniInfom.getCerType());
        pstm.setString(9,uniInfom.getCerNo());
        pstm.setString(10,uniInfom.getOperatorName());
        pstm.setString(11,uniInfom.getOperatorCerNo());
        pstm.setString(12,uniInfom.getOperatorPhone());
        pstm.setString(13,uniInfom.getOplocdistrict());
        pstm.setString(14,uniInfom.getUnitNature());
        pstm.setString(15,uniInfom.getEconomicType());
        pstm.setString(16,uniInfom.getIndustryphy());
        pstm.setString(17,uniInfom.getUnitPayDay());
        pstm.setString(18,uniInfom.getUnitDepPro());
        pstm.setString(19,uniInfom.getPersonalDepPro());
        pstm.setString(20,"");
        pstm.setString(21,"");
        pstm.registerOutParameter(22,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(23,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(24,oracle.jdbc.OracleTypes.VARCHAR);
//        pstm.getString(22);
//        pstm.getString(23);
//        pstm.getString(24);
        //执行数据库查询操作
        pstm.execute();
        //输出结果[第二个参数]
//        pstm.registerOutParameter(1,oracle.jdbc.OracleTypes.VARCHAR);
//        pstm.registerOutParameter(22,oracle.jdbc.OracleTypes.VARCHAR);
//        pstm.registerOutParameter(23,oracle.jdbc.OracleTypes.VARCHAR);
//        pstm.registerOutParameter(24,oracle.jdbc.OracleTypes.VARCHAR);
        System.out.println(pstm.getString(1));
        System.out.println(pstm.getString(22));
        System.out.println(pstm.getString(23));
        System.out.println(pstm.getString(24));
        //释放资源
        pstm.close();
        connection.close();
        return uniInfom;
    }

}
