package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.TimeExpiredPoolCache;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;

/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public String ProvidentFundServices() {
        String token=null;
        token=CacheDemoController.getToken();
        if(!"".equals(token)&&token!=null){//若token未过期，则用内存中的token
            String resp = null;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("startTime", currenttime(0));
            jsonObject.put("endTime", currenttime(24));
            jsonObject.put("app_id", "xxxxx");
            jsonObject.put("app_secret", "xxxxx");
            String str = jsonObject.toString();
            System.out.println("zip压缩处理之前要发送给第三方的报文：" + str);
            String s = zipString(str);//进行zip压缩
            System.out.println("zip压缩处理之后发送给第三方的报文：" + s);
            StringBuffer sb = new StringBuffer();
            HttpURLConnection conn = null;
            OutputStream out = null;
            try {
                // 创建url 资源
//                URL url = new URL("https://scjg.hubei.gov.cn/sjzt/api/dx/e39a08e0a52b413897f9d23359540b27/GJJ?access_token="+token);//正式第三方地址
                URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices2?access_token="+token);//测试第三方地址
                // 创建http 连接
                conn = (HttpURLConnection) url.openConnection();
                // 设置允许输出
                conn.setDoOutput(true);
                // 设置允许输入
                conn.setDoInput(true);
                // 设置不使用缓存
                conn.setUseCaches(false);
                // 设置传递方式
                conn.setRequestMethod("POST");
                // 设置维持长连接
                conn.setRequestProperty("Connection", "Keep-Alive");
                // 设置文件类型:
                conn.setRequestProperty("Content-Type", "application/json");
                // 设置文件字符集:
                conn.setRequestProperty("Charset", "UTF-8");
                // 转换为字节数组
                byte[] data = (str).getBytes("UTF-8");
                // 设置文件长度
                conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                // 开始连接请求
                conn.connect();
                //创建写入流，写入请求的字符串
                out = new DataOutputStream(conn.getOutputStream());
                out.write(data);
                // 请求返回的状态
                if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                    // 请求返回的数据
                    InputStream is = conn.getInputStream();
                    String readLine = new String();
                    BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((readLine = responseReader.readLine()) != null) {
                        sb.append(readLine);
                    }
                    responseReader.close();
                    System.out.println("第三方返回的zip压缩过的报文：" + sb.toString());
                    String s1 = unzipString(sb.toString());//将第三方返回的压缩过的json字符串解压缩
                    System.out.println("第三方返回的zip解压缩之后的报文：" + s1);
                    return s1;
                } else {
                    System.out.println("请求失败!!!");
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    } catch (IOException e) {
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }else{//若token已过期，则重新调用鉴权认证接口获取token存入内存中
            CacheDemoController.saveToken();
            token=CacheDemoController.getToken();
        }
        return null;
    }

    /**
     * 模拟公积金系统服务接口请求第三方，获取第三方返回的单位开户信息测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices2")
    public String ProvidentFundServices2() {
        String resp = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 0);
        jsonObject.put("message", "数据交换成功");
        List<UnitAccountOpeningInformation> data=new ArrayList<>();
        UnitAccountOpeningInformation openingInformation=new UnitAccountOpeningInformation();
        openingInformation.setBusId("332090874");

        data.add(openingInformation);
        jsonObject.put("data", data);
        String str = jsonObject.toString();
        return jsonObject.toString();
    }

    /**
     * 获取当天零点零分零秒的时间戳和当天24点的时间戳
     * @return
     */
    @ResponseBody
    @PostMapping("currentime")
    public static String currenttime(int type){
        String time=null;
        if(type==0){
            // 获取当天零点零分零秒的时间戳
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 0);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time=df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        }else if(type==24){
            // 获取当天24点零分零秒的时间戳,即第二天零点时间
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 24);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time=df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        }
        return  time;
    }

}
