package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.TimeExpiredPoolCache;
import org.springframework.web.bind.annotation.*;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Cache设置token缓存和获取类
 */
@RestController
@RequestMapping(value = "Cache")
public class CacheDemoController {

    /**
     * 将从第三方拿到的token值存入java内存中，并设置对应的过期时间
     * @return
     */
    @RequestMapping(value = "/saveToken", method = RequestMethod.GET)
    public String  saveToken() {
        try {
            //1.调用鉴权认证接口获取token值和过期时间的json字符串
            String str = TokenAcquisitionController.TokenAcquisition();
            Json jsonentity = JSONObject.parseObject(str, Json.class);
            if(jsonentity!=null){
                if(jsonentity.isResult()){
                    boolean result=jsonentity.isResult();
                    String access_token=jsonentity.getAccess_token();
                    Long expires_in=jsonentity.getExpires_in();
                    System.out.println("result:"+result+","+"token值："+access_token+","+"有效时间："+expires_in);
                    TimeExpiredPoolCache.getInstance().put("access_token",access_token, expires_in*1000L);
                }
            }
                return "保存token进入缓冲成功";
            } catch(Exception e){
                return "保存token进入缓存失败";
            }
    }


    /**
     * 获取存入java内存中的token值
     * @return
     */
    @RequestMapping(value = "/getToken", method = RequestMethod.GET)
    public String  getToken(){
        try {
            String   token = TimeExpiredPoolCache.getInstance().get("access_token");
            if (null!=token){
                return token;
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }


}
