package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.*;

import java.io.*;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;

/**
 * 鉴权认证控制类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class TokenAcquisitionController {

    /**
     * 鉴权认证接口（token和过期时间获取）
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token")
    public static String TokenAcquisition() {
        String resp = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("app_id", "111");
        jsonObject.put("app_secret", "222");
        jsonObject.put("grant_type", "127.0.0.1");
        String str = jsonObject.toString();
        System.out.println("发送给第三方的报文：" + str);
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
            URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/token2");//测试第三方地址
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
                System.out.println("第三方返回的报文：" + sb.toString());
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /**
     * 模拟鉴权认证第三方，获取第三方返回的token和过期时间测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token2")
    public String TokenAcquisition2() {
        String resp = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("expires_in", 60);
        jsonObject.put("access_token", "skdfhskjdfhskjdfhskdfjhk");
        String str = jsonObject.toString();
        return jsonObject.toString();
    }

}
