package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import org.springframework.web.bind.annotation.*;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;


/**
 * 鉴权认证控制类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class TokenAcquisitionController {

    /**
     * 鉴权认证接口（token和过期时间获取）
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token")
    public static String TokenAcquisition() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        jsonObject.put("grant_type", "ip");
        jsonObject.put("userid", "gjj");
        String str = jsonObject.toString();
        System.out.println("鉴权参数zip压缩处理之前要发送给第三方的报文：" + str);
//        String s = zipString(str);//进行zip压缩
//        System.out.println("鉴权参数zip压缩处理之后发送给第三方的报文：" + str);
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
//            URL url = new URL("https://scjg.hubei.gov.cn/sjzt/api/oauth2/token");//正式第三方地址
            URL url = new URL("http://127.0.0.1:8080/FrontEndProcessor/FrontEndProcessor/token2");//测试第三方地址
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
                System.out.println("鉴权参数第三方返回的zip压缩过的报文：" + sb.toString());
                String s1 = unzipString(sb.toString());//将第三方返回的压缩过的json字符串解压缩
                System.out.println("鉴权参数第三方返回的zip解压缩之后的报文：" + s1);
                return s1;
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }

    /**
     * 模拟鉴权认证第三方，获取第三方返回的token和过期时间测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token2")
    public String TokenAcquisition2() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", true);
        jsonObject.put("expires_in", 7200);
        jsonObject.put("access_token", "0faca598-787b-47cd-b74e-1f6f294e0250");
        String str = jsonObject.toString();
        //压缩处理
        String s = zipString(str);
        return s;
    }

    /**
     * 测试json字符串zip压缩，解压缩
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("testzip")
    public void testzip() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("app_id", "111");
        jsonObject.put("app_secret", "222");
        jsonObject.put("grant_type", "192.168.101.34");
        jsonObject.put("userid", "gjj");
        String str = jsonObject.toString();
        System.out.println("未经过压缩处理的json字符串："+str);
        String s = zipString(str);//进行zip压缩
        System.out.println("压缩处理之后的json字符串："+s);
        String s1 = unzipString(s);//进行zip解压缩
        System.out.println("解压缩处理之后的json字符串："+s1);
    }
}
