package net.cdkj.gjj.adapter.domain;

import net.cdkj.gjj.adapter.controller.CacheDemoController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

/**
 * json字符串zip压缩，解压缩工具类
 */
public class GzipUtil {


    private static final Logger logger = LoggerFactory.getLogger(CacheDemoController.class);

    /**
     * 压缩
     *
     * @param unzip
     * @return
     */
    public static String zipString(String unzip) {
        return new sun.misc.BASE64Encoder().encodeBuffer(zipByte(unzip));
    }

    /**
     * 对cpspJson进行解压
     *
     * @param zip
     * @return
     */
    public static String unzipString(String zip) {
        try {
            byte[] decode = new sun.misc.BASE64Decoder().decodeBuffer(zip);
            String unziqStr = unzipByte(decode);
            // 如果解压缩失败，返回原数据
            if (StringUtils.isEmpty(unziqStr)) {
                return zip;
            }
            return unziqStr;
        } catch (IOException ex) {
            logger.error("解压文件失败" + ex);
            return zip;
        }
    }


    public static String unzipString1(String zip) {
        try {
            byte[] decode = new sun.misc.BASE64Decoder().decodeBuffer(zip);
            return unzipByte(decode);
        } catch (IOException ex) {
            logger.error("解压文件失败" + ex);
            return null;
        }
    }

    /**
     * 压缩
     *
     * @param unzip
     * @return
     */
    public static byte[] zipByte(String unzip) {
        Deflater deflater = new Deflater(9);
        deflater.setInput(unzip.getBytes());
        deflater.finish();
        final byte[] bytes = new byte[256];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
        while (!deflater.finished()) {
            int length = deflater.deflate(bytes);
            outputStream.write(bytes, 0, length);
        }
        deflater.end();
        return outputStream.toByteArray();
    }

    /**
     * 解压缩
     *
     * @param decode
     * @return
     */
    public static String unzipByte(byte[] decode) {
        Inflater inflater = new Inflater();
        inflater.setInput(decode);
        final byte[] bytes = new byte[256];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(256);
        try {
            while (!inflater.finished()) {
                int length = inflater.inflate(bytes);
                outputStream.write(bytes, 0, length);
            }
        } catch (DataFormatException e) {
            logger.error("解压缩失败" + e);
            return null;
        } finally {
            inflater.end();
        }
        return outputStream.toString();
    }

}
