package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.HttpUtil;
import net.cdkj.gjj.adapter.domain.PropertyUtil;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;

/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public static String ProvidentFundServices(HttpServletRequest request) {
        Properties prop = PropertyUtil.getConfig("application.properties");
        // 获取请求入参
        String data = HttpUtil.getReqData(request);
        // 调用获取token的方法
        String token = huoqutoken();
        String provifunserviurl = PropertyUtil.getPropValue(prop, "provifunserviurl") + token;
        System.out.println(provifunserviurl);
        // 发起 post 请求，并对出参进行解压缩
        return HttpUtil.sendPost(provifunserviurl, data);
    }


    /**
     * 模拟公积金系统服务接口请求第三方，获取第三方返回的单位开户信息测试接口
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices2")
    public String ProvidentFundServices2(HttpServletRequest request) {
        // 获取请求入参
        String str1 = HttpUtil.getReqData(request);
        System.out.println("第三方接收的公积金服务接口参数解压之前" + str1);
        String str2 = unzipString(str1);// 解压缩
        System.out.println("第三方接收的公积金服务接口参数解压之后" + str2);
        //-----------------------------------------------------
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("code", 0);
        jsonObject.put("message", "数据交换成功");
        List<UnitAccountOpeningInformation> list = new ArrayList<>();
        jsonObject.put("data", list);
        String str = jsonObject.toString();
        return str;
    }

    /**
     * 获取token专用方法
     */
    @ResponseBody
    @PostMapping("huoqutoken")
    public static String huoqutoken() {
        // 优先从内存中拿
        String token = CacheDemoController.getToken();
        // 若token未过期，则用内存中的token
        if (!"".equals(token) && token != null) {

        } else {
            // 若token已过期，则重新调用鉴权认证接口获取token存入内存中
            CacheDemoController.saveToken();
            token = CacheDemoController.getToken();
        }
        return token;
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     */
    @ResponseBody
    @PostMapping("BusinessProcessing")
    public static String BusinessProcessing(HttpServletRequest request) {
        Properties prop = PropertyUtil.getConfig("application.properties");
        System.out.println("继续调前置机的进度第二个接口");
        // 获取请求入参
        String str = HttpUtil.getReqData(request);
        // 调用获取token的方法
        String token = huoqutoken();
        String bussiniprourl = PropertyUtil.getPropValue(prop, "bussiniprourl") + token;
        System.out.println(bussiniprourl);
        // 发起 post 请求，并对出参进行解压缩
        return HttpUtil.sendPost(bussiniprourl, str);
    }

    /**
     * 模拟住建部门返回公积金办理进度数据接口请求第三方，获取第三方返回的数据
     */
    @ResponseBody
    @PostMapping("BusinessProcessing2")
    public String BusinessProcessing2() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("success", "true");
        jsonObject.put("msg", "系统内部错误");
        String str = jsonObject.toString();
        // 进行zip压缩
        String s = zipString(str);
        return s;
    }

}
