package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.HttpUtil;
import net.cdkj.gjj.adapter.domain.PropertyUtil;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

import java.util.Properties;

import static net.cdkj.gjj.adapter.domain.GzipUtil.unzipString;
import static net.cdkj.gjj.adapter.domain.GzipUtil.zipString;


/**
 * 鉴权认证控制类
 */
@RestController
@RequestMapping(value = "FrontEndProcessor")
public class TokenAcquisitionController {

    /**
     * 测试静态方法读取配置文件属性值方法
     */
    @ResponseBody
    @PostMapping("test")
    public static void test() {
        Properties prop = PropertyUtil.getConfig("application.properties");
        System.out.println(PropertyUtil.getPropValue(prop, "tokenurl"));
    }

    /**
     * 鉴权认证接口（token和过期时间获取）
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token")
    public static String TokenAcquisition() {
        Properties prop = PropertyUtil.getConfig("application.properties");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        jsonObject.put("grant_type", "ip");
        jsonObject.put("userid", "gjj");
        String str = jsonObject.toString();
        System.out.println("鉴权参数zip压缩处理之前要发送给第三方的报文：" + str);
        String tokenurl = PropertyUtil.getPropValue(prop, "tokenurl");
        return HttpUtil.sendPost(tokenurl, str);
    }

    /**
     * 模拟鉴权认证第三方，获取第三方返回的token和过期时间测试接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("token2")
    public String TokenAcquisition2() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("result", true);
        jsonObject.put("expires_in", 7200);
        jsonObject.put("access_token", "0faca598-787b-47cd-b74e-1f6f294e0250");
        String str = jsonObject.toString();
        // 压缩处理
        String s = zipString(str);
        return s;
    }

    /**
     * 测试json字符串zip压缩，解压缩
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("testzip")
    public void testzip() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("app_id", "111");
        jsonObject.put("app_secret", "222");
        jsonObject.put("grant_type", "192.168.101.34");
        jsonObject.put("userid", "gjj");
        String str = jsonObject.toString();
        System.out.println("未经过压缩处理的json字符串：" + str);
        String s = zipString(str);// 进行zip压缩
        System.out.println("压缩处理之后的json字符串：" + s);
        String s1 = unzipString(s);// 进行zip解压缩
        System.out.println("解压缩处理之后的json字符串：" + s1);
    }
}
