package net.cdkj.gjj.adapter.domain;

import net.cdkj.gjj.adapter.controller.CacheDemoController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Properties;

/**
 * 获取配置文件application.properties里的属性值所用到的工具类
 */
public class PropertyUtil {


    private static final Logger logger = LoggerFactory.getLogger(PropertyUtil.class);

    /**
     * 读取 classpath 下 指定的properties配置文件，加载到Properties并返回Properties
     *
     * @param name 配置文件名，如：mongo.properties
     * @return
     */
    public static Properties getConfig(String name) {
        Properties props = null;
        try {
            props = new Properties();
            InputStream in = PropertyUtil.class.getClassLoader().getResourceAsStream(name);
            BufferedReader bf = new BufferedReader(new InputStreamReader(in));
            props.load(bf);
            in.close();
        } catch (Exception e) {
            logger.error("{}", e);
        }
        return props;
    }

    public static String getPropValue(Properties prop, String key) {
        if (key == null || "".equals(key.trim())) {
            return null;
        }
        String value = prop.getProperty(key);
        if (value == null) {
            return null;
        }
        value = value.trim();
        // 判断是否是环境变量配置属性,例如 server.env=${serverEnv:local}
        if (value.startsWith("${") && value.endsWith("}") && value.contains(":")) {
            int indexOfColon = value.indexOf(":");
            String envName = value.substring(2, indexOfColon);
            // 获取系统环境变量 envName 的内容，如果没有找到，则返回defaultValue
            String envValue = System.getenv(envName);
            if (envValue == null) {
                // 配置的默认值
                return value.substring(indexOfColon + 1, value.length() - 1);
            }
            return envValue;
        }
        return value;
    }
}
