package net.cdkj.gjj.adapter.service;


import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.BusinessProcessing;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import net.cdkj.gjj.adapter.utils.HttpUtil;
import net.cdkj.gjj.adapter.utils.InternalUtils;
import oracle.jdbc.OracleTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.stream.Collectors;


/**
 * 公积金系统服务类
 */
@Service
public class OpenAccountService {


    // sl4j
    private static final Logger log = LoggerFactory.getLogger(OpenAccountService.class);


    @Resource
    private DruidDataSource dataSource;
    @Resource
    private DeptLogoutService deptLogoutService;
    @Resource
    private DeptInfoUpdateService deptInfoUpdateService;

    @Value("${providentFundServices}")
    private String providentFundServices;

    @Value("${businessProcessing}")
    private String businessProcessing;

    @Value("${manualDataStatus:}")
    private String manualDataStatus;

    @Value("${timetype}")
    private String timetype;

    @Value("${startTime}")
    private String startTime;

    @Value("${endTime}")
    private String endTime;

    /**
     * 公积金系统服务接口内置机调前置机中间接口
     */
    public void syncDeptInfo() throws Exception {
        JSONObject jsonObject = new JSONObject();
        if ("1".equals(timetype)) {// 表示正式环境
            jsonObject.put("startTime", InternalUtils.currentTime(0));// 正式环境
            jsonObject.put("endTime", InternalUtils.currentTime(24));// 正式环境
        } else if ("2".equals(timetype)) {// 表示测试环境或本地环境
            jsonObject.put("startTime", startTime);// 测试环境或本地环境
            jsonObject.put("endTime", endTime);// 测试环境或本地环境
        }
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        String str = jsonObject.toString();
        // 发起 post 请求
        log.info("拉取单位信息请求入参:{}", str);
        String result = HttpUtil.sendPost(providentFundServices, str);
        // String result = mockDwxxHttp();
        log.info("拉取单位信息请求出参：{}", result);
        Json jsonentity = JSONObject.parseObject(result, Json.class);
        List<UnitAccountOpeningInformation> bills = new ArrayList<>();
        if (!InternalUtils.isNullOrEmpty(jsonentity)) {
            bills = jsonentity.getData();
        }
        List<UnitAccountOpeningInformation> openAccountList = new ArrayList<>();
        List<UnitAccountOpeningInformation> deptInfoUpdateList = new ArrayList<>();
        List<UnitAccountOpeningInformation> deptLogoutList = new ArrayList<>();
        for (UnitAccountOpeningInformation bill : bills) {
            if (!StringUtils.isEmpty(manualDataStatus)) {
                bill.setData_status(manualDataStatus);
            }
            String dataStatus = bill.getData_status();
            // 开户
            if (StringUtils.isEmpty(dataStatus) || dataStatus.equals("0")) {
                openAccountList.add(bill);
                // 变更
            } else if (dataStatus.equals("1")) {
                deptInfoUpdateList.add(bill);
                // 注销
            } else if (dataStatus.equals("2")) {
                deptLogoutList.add(bill);
            }
        }
        openAccountPull(openAccountList);
        deptInfoUpdateService.deptInfoUpdatePull(deptInfoUpdateList);
        deptLogoutService.deptLogoutPull(deptLogoutList);
    }

    /**
     * (第一个定时的)
     * 调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，
     * 拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
     */
    public void openAccountPull(List<UnitAccountOpeningInformation> bills) throws Exception {
        if (CollectionUtils.isEmpty(bills)) {
            return;
        }
        log.info("执行 DWXX_IMP 过程入参:{}", bills);
        // 2.内置机处理返回的业务数据，调用oracle存储过程
        // 加载数据库驱动
        Connection connection = dataSource.getConnection();
        // 得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWXX_IMP(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        for (UnitAccountOpeningInformation uniInfom : bills) {
            String oplocdistrict = uniInfom.getOplocdistrict();
            if (StringUtils.isEmpty(oplocdistrict)) {
                continue;
            }
            String busId = uniInfom.getBusId();
            if (!"".equals(busId) && busId != null) {
                pstm.setString(1, busId);
            } else {
                pstm.setString(1, "");
            }

            if (!"".equals(uniInfom.getUscc()) && uniInfom.getUscc() != null) {
                pstm.setString(2, uniInfom.getUscc());
            } else {
                pstm.setString(2, "");
            }

            if (!"".equals(uniInfom.getEntName()) && uniInfom.getEntName() != null) {
                pstm.setString(3, uniInfom.getEntName());
            } else {
                pstm.setString(3, "");
            }

            if (!"".equals(uniInfom.getDom()) && uniInfom.getDom() != null) {
                pstm.setString(4, uniInfom.getDom());
            } else {
                pstm.setString(4, "");
            }

            if (!"".equals(uniInfom.getEstDate()) && uniInfom.getEstDate() != null) {
                pstm.setDate(5, new java.sql.Date(uniInfom.getEstDate().getTime()));
            } else {
                pstm.setString(5, "");
            }

            if (!"".equals(uniInfom.getLerep()) && uniInfom.getLerep() != null) {
                pstm.setString(6, uniInfom.getLerep());
            } else {
                pstm.setString(6, "");
            }

            if (!"".equals(uniInfom.getCerType()) && uniInfom.getCerType() != null) {
                pstm.setString(7, uniInfom.getCerType());
            } else {
                pstm.setString(7, "");
            }

            if (!"".equals(uniInfom.getCerNo()) && uniInfom.getCerNo() != null) {
                pstm.setString(8, uniInfom.getCerNo());
            } else {
                pstm.setString(8, "");
            }

            if (!"".equals(uniInfom.getOperatorName()) && uniInfom.getOperatorName() != null) {
                pstm.setString(9, uniInfom.getOperatorName());
            } else {
                pstm.setString(9, "");
            }

            if (!"".equals(uniInfom.getOperatorCerNo()) && uniInfom.getOperatorCerNo() != null) {
                pstm.setString(10, uniInfom.getOperatorCerNo());
            } else {
                pstm.setString(10, "");
            }

            if (!"".equals(uniInfom.getOperatorPhone()) && uniInfom.getOperatorPhone() != null) {
                pstm.setString(11, uniInfom.getOperatorPhone());
            } else {
                pstm.setString(11, "");
            }

            if (!"".equals(oplocdistrict) && oplocdistrict != null) {
                pstm.setString(12, oplocdistrict);
            } else {
                pstm.setString(12, "");
            }

            if (!"".equals(uniInfom.getUnitNature()) && uniInfom.getUnitNature() != null) {
                pstm.setString(13, uniInfom.getUnitNature());
            } else {
                pstm.setString(13, "");
            }

            if (!"".equals(uniInfom.getEconomicType()) && uniInfom.getEconomicType() != null) {
                pstm.setString(14, uniInfom.getEconomicType());
            } else {
                pstm.setString(14, "");
            }

            if (!"".equals(uniInfom.getIndustryphy()) && uniInfom.getIndustryphy() != null) {
                pstm.setString(15, uniInfom.getIndustryphy());
            } else {
                pstm.setString(15, "");
            }

            if (!"".equals(uniInfom.getUnitPayDay()) && uniInfom.getUnitPayDay() != null) {
                pstm.setString(16, uniInfom.getUnitPayDay());
            } else {
                pstm.setString(16, "");
            }

            if (!"".equals(uniInfom.getUnitDepPro()) && uniInfom.getUnitDepPro() != null) {
                pstm.setString(17, uniInfom.getUnitDepPro());
            } else {
                pstm.setString(17, "");
            }

            if (!"".equals(uniInfom.getPersonalDepPro()) && uniInfom.getPersonalDepPro() != null) {
                pstm.setString(18, uniInfom.getPersonalDepPro());
            } else {
                pstm.setString(18, "");
            }
            pstm.registerOutParameter(19, OracleTypes.VARCHAR);
            pstm.registerOutParameter(20, OracleTypes.VARCHAR);
            // 执行数据库查询操作
            pstm.execute();
            // 输出结果[第二个参数]
            String errcode = pstm.getString(19);
            String errmsg = pstm.getString(20);
            if (StringUtils.isEmpty(errcode)) {
                log.info("busId：{} 执行结果 errcode：{}，errmsg ：{}", busId, errcode, errmsg);
            } else {
                try {
                    // 避免批量插入高并发，此处设置每次停顿5秒
                    Thread.currentThread().sleep(2000);
                } catch (InterruptedException e) {
                    log.error("{}", e);
                }
            }

        }
        // 释放资源
        pstm.close();
        // 调完第一个存储过程DWXX_IMP之后再调DWKH_SAVE存储过程
        CallableStatement pstm2 = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_SAVE()}");
        pstm2.execute();
        pstm2.close();
        connection.close();
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * (第二个定时)
     */
    public String openAccountPush() {
        // 调oracle存储过程拿到进度推进的数据集合
        List<BusinessProcessing> list = null;
        try {
            list = collOpenAccount();
        } catch (Exception e) {
            log.error("{}", e);
        }
        if (CollectionUtils.isEmpty(list)) {
            return "0";
        }
        // 根据业务id分组
        Map<String, List<BusinessProcessing>> listMap = list.stream()
                .collect(Collectors.groupingBy(vo -> vo.getBusId(), LinkedHashMap::new, Collectors.toList()));
        for (Map.Entry<String, List<BusinessProcessing>> listEntry : listMap.entrySet()) {
            String busId = listEntry.getKey();
            List<BusinessProcessing> processinglist = listEntry.getValue();
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("state", "1");
            jsonObject.put("timestamp", processinglist.stream().max(Comparator.comparing(BusinessProcessing::getTime)).get().getTime());
            jsonObject.put("busId", busId);
            jsonObject.put("departCode", "10");
            jsonObject.put("nodeList", processinglist);
            String str = jsonObject.toString();
            // 发起 post 请求
            log.info("单位开户推送单位信息请求入参:{}", str);
            String result = HttpUtil.sendPost(businessProcessing, str);
            log.info("单位开户推送单位信息请求出参：{}", result);
            if (result != null) {
                JSONObject jsonObj = JSONObject.parseObject(result);
                Integer status = "true".equals(jsonObj.getString("success")) ? 1 : 0;
                try {
                    collOpenAccountRewrite(busId, status);
                } catch (Exception e) {
                    log.error("{}", e);
                }
            }
        }
        return "1";
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * 调用oracle存储过程拿到进度数据，然后请求前置机，让前置机请求市监接口，将办理的进度数据推送给市监
     */
    public List<BusinessProcessing> collOpenAccount() throws Exception {
        // 1.调用oracle存储过程，拿到业务办理进度数据
        Connection connection = dataSource.getConnection();
        // 得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_CX(?)}");
        // 给参数赋值
        // pstm.setString(1,"914205007146986289");
        pstm.registerOutParameter(1, OracleTypes.CURSOR);
        // 执行数据库查询操作
        pstm.execute();
        // 输出结果[第二个参数]
        ResultSet rs = (ResultSet) pstm.getObject(1);// 此处的2要与存储过程中cursor的问题对应
        List<BusinessProcessing> list = new ArrayList<>();
        while (rs.next()) {
            BusinessProcessing bp = getBusinessProcessing(rs);
            list.add(bp);
        }
        log.info("单位开户调用过程结果：{}", JSON.toJSONString(list));
        // 释放资源
        pstm.close();
        connection.close();
        return list;
    }


    public static BusinessProcessing getBusinessProcessing(ResultSet rs) throws SQLException {
        BusinessProcessing bp = new BusinessProcessing();
        if (StringUtils.hasText(rs.getString(1))) {
            bp.setBusiLink(rs.getString(1));
        }
        if (StringUtils.hasText(rs.getString(2))) {
            bp.setBusiType(rs.getString(2));
        }
        if (StringUtils.hasText(rs.getString(3))) {
            bp.setOpeartor(rs.getString(3));
        }
        if (StringUtils.hasText(rs.getString(4))) {
            bp.setTel(rs.getString(4));
        }
        if (StringUtils.hasText(rs.getString(5))) {
            bp.setOpinion(rs.getString(5));
        }
        if (StringUtils.hasText(rs.getString(6))) {
            bp.setResult(rs.getString(6));
        }
        if (StringUtils.hasText(rs.getString(7))) {
            bp.setTime(rs.getString(7).substring(0, 19));
        }
        if (StringUtils.hasText(rs.getString(8))) {
            bp.setUscc(rs.getString(8));
        }
        if (StringUtils.hasText(rs.getString(9))) {
            bp.setEntName(rs.getString(9));
        }
        if (StringUtils.hasText(rs.getString(10))) {
            bp.setRn(rs.getString(10));
        }
        if (StringUtils.hasText(rs.getString(11))) {
            bp.setBusId(rs.getString(11));
        }
        return bp;
    }


    /**
     * 回写
     */
    public void collOpenAccountRewrite(String uscc, Integer value) throws Exception {
        // 1.调用oracle存储过程，拿到业务办理进度数据
        // 加载数据库驱动
        Connection connection = dataSource.getConnection();
        // 得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_HX(?,?)}");
        // 给参数赋值
        pstm.setString(1, uscc);
        pstm.setInt(2, value);
        // pstm.registerOutParameter(1, OracleTypes.CURSOR);
        // 执行数据库查询操作
        pstm.execute();
        // 输出结果[第二个参数]
        // 释放资源
        pstm.close();
        connection.close();
    }


    /**
     * 模拟数据
     *
     * @return
     */
    private static String mockDwxxHttp() {
        List<UnitAccountOpeningInformation> informationList = new ArrayList<>();
        // 单位变更
        UnitAccountOpeningInformation dwkh = new UnitAccountOpeningInformation();
        dwkh.setBusId("2");
        dwkh.setUscc("91421122MAC7ANQB8C");
        dwkh.setEntName("红安县永利土石方工程有限公司");
        dwkh.setDom("湖北省黄冈市红安县高桥镇长扬路东端北侧119号");
        dwkh.setEstDate(new Date());
        dwkh.setLerep("吴永利");
        dwkh.setCerType("10");
        dwkh.setCerNo("422123197810295851");
        dwkh.setOperatorName("吴永利");
        dwkh.setOperatorCerNo("422123197810295851");
        dwkh.setOperatorPhone("13872001037");
        dwkh.setOplocdistrict("421122");
        dwkh.setUnitNature("A313");
        dwkh.setEconomicType("1");
        dwkh.setIndustryphy("E");
        dwkh.setUnitPayDay("1");
        dwkh.setUnitDepPro("12");
        dwkh.setPersonalDepPro("12");
        informationList.add(dwkh);
        // 单位变更
        UnitAccountOpeningInformation dwxxBg = new UnitAccountOpeningInformation();
        dwxxBg.setBusId("2");
        dwxxBg.setUscc("91421122MAC7ANQB8C");
        dwxxBg.setEntName("红安县永利土石方工程有限公司");
        dwxxBg.setDom("湖北省黄冈市红安县高桥镇长扬路东端北侧119号");
        dwxxBg.setLerep("吴永利");
        dwxxBg.setCerType("10");
        dwxxBg.setCerNo("422123197810295851");
        dwxxBg.setOperatorName("吴永利");
        dwxxBg.setOperatorCerNo("422123197810295851");
        dwxxBg.setOperatorPhone("13872001037");
        dwxxBg.setOplocdistrict("421122");
        dwxxBg.setUnitNature("A313");
        dwxxBg.setEconomicType("1");
        dwxxBg.setIndustryphy("E");
        dwxxBg.setUnitPayDay("1");
        dwxxBg.setData_status("1");
        informationList.add(dwxxBg);
        // 单位销户
        UnitAccountOpeningInformation dwXh = new UnitAccountOpeningInformation();
        dwXh.setBusId("2");
        dwXh.setUscc("91421122MAC7ANQB8C");
        dwXh.setEntName("红安县永利土石方工程有限公司");
        dwXh.setDom("湖北省黄冈市红安县高桥镇长扬路东端北侧119号");
        dwXh.setOplocdistrict("421122");
        dwXh.setData_status("2");
        informationList.add(dwXh);
        Json json = new Json();
        json.setData(informationList);
        String dwxxbgHttp = JSONObject.toJSONString(json);
        return dwxxbgHttp;
    }

}
