package net.cdkj.gjj.adapter.encryptor;

import org.jasypt.encryption.StringEncryptor;
import org.springframework.web.bind.annotation.*;

@RestController
@RequestMapping("/encrypt")
@CrossOrigin(origins = "*", maxAge = 3600)
public class EncryptController {


    @PostMapping("/jasyptEnc")
    public String encrypt(@RequestParam String encStr) throws Exception {
        StringEncryptor encryptor = new JasyptConfig().stringEncryptor();
        return encryptor.encrypt(encStr);
    }

    @PostMapping("/jasyptDec")
    public String decrypt(@RequestParam String decStr) throws Exception {
        StringEncryptor encryptor = new JasyptConfig().stringEncryptor();
        return encryptor.decrypt(decStr);
    }
}
