package net.cdkj.gjj.adapter.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Map;

public class InternalUtils {

    private static final Logger log = LoggerFactory.getLogger(InternalUtils.class);

    /**
     * 判断一个实体对象是否为空
     *
     * @param obj
     * @return
     */
    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null)
            return true;
        if (obj instanceof CharSequence)
            return ((CharSequence) obj).length() == 0;
        if (obj instanceof Collection)
            return ((Collection) obj).isEmpty();
        if (obj instanceof Map)
            return ((Map) obj).isEmpty();
        if (obj instanceof Object[]) {
            Object[] object = (Object[]) obj;
            if (object.length == 0) {
                return true;
            }
            boolean empty = true;
            for (int i = 0; i < object.length; i++) {
                if (!isNullOrEmpty(object[i])) {
                    empty = false;
                    break;
                }
            }
            return empty;
        }
        return false;
    }

    /**
     * 获取当天零点零分零秒的时间戳和当天24点的时间戳
     *
     * @return
     */
    public static String currentTime(int type) {
        String time = null;
        if (type == 0) {
            // 获取当天零点零分零秒的时间戳
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 0);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
        } else if (type == 24) {
            // 获取当天24点零分零秒的时间戳,即第二天零点时间
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 24);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
        }
        return time;
    }


    public static String getCurrentTime() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return sdf.format(new Date());
    }
}
