package net.cdkj.gjj.adapter.controller;


import net.cdkj.gjj.adapter.utils.InternalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;


/**
 * 定时任务类
 *
 * @author huarun
 */
@Component
@EnableScheduling
//@Async
public class AlarmTask {

    private static final Logger log = LoggerFactory.getLogger(DeptInfoUpdateController.class);

    @Resource
    private DeptInfoUpdateController deptInfoUpdateController;
    @Resource
    private ProvidentFundServicesController providentFundServicesController;

    /**
     * 第一次延迟(initialDelay)?秒后执行，之后按fixedDelay的规则每?秒执行一次
     */
    @Scheduled(initialDelay = 5 * 1000, fixedDelayString = "${dwkhPullTaskDelay}")
    public void dwkhPullTask() {
        log.debug("第一个接口开始时间:{}", InternalUtils.getCurrentTime());
        try {
            providentFundServicesController.gjjxtfwjk();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // 进度数据定时器

    /**
     * 第一次延迟(initialDelay)?秒后执行，之后按fixedDelay的规则每?秒执行一次
     */
    @Scheduled(initialDelay = 20 * 1000, fixedDelayString = "${dwkhPushTaskDelay}")
    public void dwkhPushTask() {
        log.debug("第二个接口开始时间:{}", InternalUtils.getCurrentTime());
        providentFundServicesController.BusinessProcessing();
    }


    @Scheduled(initialDelay = 40 * 1000, fixedDelayString = "${dwxxbgPushTaskDelay}")
    public void dwxxbgPushTask() {
        log.debug("dwxxbgPushTask 开始时间:{}", InternalUtils.getCurrentTime());
        deptInfoUpdateController.dwxxbgPush();
    }


    @Scheduled(initialDelay = 60 * 1000, fixedDelayString = "${dwxxbgPullTaskDelay}")
    public void dwxxbgPullTask() {
        log.debug("dwxxbgPullTask 开始时间:{}", InternalUtils.getCurrentTime());
        deptInfoUpdateController.dwxxbgPull();
    }
}

