package net.cdkj.gjj.adapter.controller;


import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.AjaxResult;
import net.cdkj.gjj.adapter.domain.BusinessProcessing;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import net.cdkj.gjj.adapter.utils.InternalUtils;
import oracle.jdbc.OracleTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;


/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "/InternalLogic")
public class DeptLogoutController {

    private static final Logger log = LoggerFactory.getLogger(DeptLogoutController.class);
    @Resource
    private RestTemplate restTemplate;
    @Resource
    private DruidDataSource druidDataSource;
    @Value("${dwxhPullUrl}")
    private String dwxhPullUrl;
    @Value("${dwxhPushUrl}")
    private String dwxhPushUrl;
    @Value("${timetype}")
    private String timetype;
    @Value("${startTime}")
    private String startTime;
    @Value("${endTime}")
    private String endTime;

    /**
     * 模拟数据
     *
     * @return
     */
    private static String mockDwxhHttp() {
        List<UnitAccountOpeningInformation> informationList = new ArrayList<>();
        UnitAccountOpeningInformation information = new UnitAccountOpeningInformation();
        information.setBusId("2");
        information.setUscc("91421122MAC7ANQB8C");
        information.setEntName("红安县永利土石方工程有限公司");
        information.setDom("湖北省黄冈市红安县高桥镇长扬路东端北侧119号");
        information.setOplocdistrict("421122");
        informationList.add(information);
        Json json = new Json();
        json.setData(informationList);
        String dwxhHttp = JSONObject.toJSONString(json);
        return dwxhHttp;
    }

    /**
     * 公积金系统服务接口内置机调前置机中间接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("/getDwxhHttp")
    public String getDwxhHttp() {
        JSONObject jsonObject = new JSONObject();
        if ("1".equals(timetype)) {// 表示正式环境
            jsonObject.put("startTime", InternalUtils.currentTime(0));// 正式环境
            jsonObject.put("endTime", InternalUtils.currentTime(24));// 正式环境
        } else if ("2".equals(timetype)) {// 表示测试环境或本地环境
            jsonObject.put("startTime", startTime);// 测试环境或本地环境
            jsonObject.put("endTime", endTime);// 测试环境或本地环境
        }
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        String str = jsonObject.toString();
        //（测试环境地址）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
        String forObject = restTemplate.postForObject(dwxhPullUrl, str, String.class);
        return forObject;
    }

    /**
     * (第一个定时的)
     * 调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，
     * 拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
     *
     * @return
     */
    @ResponseBody
    @PostMapping("/dwxhPull")
    public AjaxResult dwxhPull() {
        // 1.调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
        String dwxhHttp = getDwxhHttp();
        log.info("拿到第一个接口返回的第三方数据:{}", dwxhHttp);
        Json jsonentity = JSONObject.parseObject(dwxhHttp, Json.class);
        List<UnitAccountOpeningInformation> bills = null;
        if (!InternalUtils.isNullOrEmpty(jsonentity)) {
            bills = jsonentity.getData();
        }
        if (CollectionUtils.isEmpty(bills)) {
            log.info("第三方返回的报文中data数据为空！");
            return AjaxResult.success("第三方返回的报文中data数据为空", null);
        }

        // 2.内置机处理返回的业务数据，调用oracle存储过程
        Connection connection = null;
        CallableStatement dwxhImp = null;
        CallableStatement dwxhSave = null;
        try {
            connection = druidDataSource.getConnection();
            // 得到预编译的Statement对象
            dwxhImp = connection.prepareCall("{call JGJ_KSYW_DWXH.DWXH_IMP(?, ?, ?, ?, ?, ?, ?)}");
            // 循环插入
            for (UnitAccountOpeningInformation uniInfom : bills) {
                if (!StringUtils.isEmpty(uniInfom.getOplocdistrict())) {
                    // 业务标识
                    String busId = StringUtils.hasText(uniInfom.getBusId()) ? uniInfom.getBusId() : "";
                    dwxhImp.setString(1, busId);
                    // 统一社会信用
                    String uscc = StringUtils.hasText(uniInfom.getUscc()) ? uniInfom.getUscc() : "";
                    dwxhImp.setString(2, uscc);
                    // 企业名称
                    String entName = StringUtils.hasText(uniInfom.getEntName()) ? uniInfom.getEntName() : "";
                    dwxhImp.setString(3, entName);
                    // 单位地址
                    String dom = StringUtils.hasText(uniInfom.getDom()) ? uniInfom.getDom() : "";
                    dwxhImp.setString(4, dom);
                    // 所属区域
                    String oplocdistrict = StringUtils.hasText(uniInfom.getOplocdistrict()) ? uniInfom.getOplocdistrict() : "";
                    dwxhImp.setString(5, oplocdistrict);
                    // 输出结果[第二个参数]
                    dwxhImp.registerOutParameter(6, OracleTypes.VARCHAR);
                    dwxhImp.registerOutParameter(7, OracleTypes.VARCHAR);
                    // 执行数据库查询操作
                    dwxhImp.execute();
                    // 获取出参
                    String errcode = dwxhImp.getString(7);
                    String errmsg = dwxhImp.getString(7);
                    log.info("DWXH_IMP 执行结果 errcode：{}，errmsg ：{}", errcode, errmsg);
                    if (StringUtils.isEmpty(errcode)) {
                        log.error("DWXH_IMP 执行结果 errcode：{}，errmsg ：{}，对应数据为：{}", errcode, errmsg, JSON.toJSONString(uniInfom));
                        continue;
                    } else {
                        // 避免批量插入高并发，此处设置每次停顿5秒
                        Thread.currentThread().sleep(2000);
                    }
                }
            }
            // 调完第一个存储过程DWXX_IMP之后再调DWKH_SAVE存储过程
            dwxhSave = connection.prepareCall("{call JGJ_KSYW_DWXH.DWXH_SAVE()}");
            dwxhSave.execute();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
        } finally {
            // 释放资源
            try {
                dwxhImp.close();
                dwxhSave.close();
                connection.close();
            } catch (SQLException e) {
                log.error(e.getMessage(), e);
                throw new RuntimeException(e);
            }
        }
        return AjaxResult.success("请求成功", null);
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * (第二个定时)
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("/dwxhPush")
    public String dwxhPush() {
        // 调oracle存储过程拿到进度推进的数据集合
        List<BusinessProcessing> collDwxhList = collDwxh();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", "1");
        if (!CollectionUtils.isEmpty(collDwxhList)) {
            jsonObject.put("timestamp", collDwxhList.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getTime());
            jsonObject.put("busId", collDwxhList.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getBusId());
        } else {
            jsonObject.put("timestamp", "");
            jsonObject.put("busId", "");
        }
        jsonObject.put("departCode", "10");
        jsonObject.put("nodeList", collDwxhList);
        String str = jsonObject.toString();

        //（测试环境）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
        String forObject = restTemplate.postForObject(dwxhPushUrl, str, String.class);
        log.info("前置机返回第三方解压之后的进度推送结果:{}", forObject);
        JSONObject jsonObj = JSONObject.parseObject(forObject);
        Integer value = "true".equals(jsonObj.getString("success")) ? 1 : 0;
        String uscc = !CollectionUtils.isEmpty(collDwxhList) ? collDwxhList.get(0).getUscc() : "";
        log.info("入参 uscc:{} value:{}", uscc, value);
        collDwxhHx(uscc, value);
        return forObject;
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * 调用oracle存储过程拿到进度数据，然后请求前置机，让前置机请求市监接口，将办理的进度数据推送给市监
     *
     * @return
     */
    @ResponseBody
    @PostMapping("/collDwxh")
    public List<BusinessProcessing> collDwxh() {
        List<BusinessProcessing> list = new ArrayList<>();
        Connection connection = null;
        CallableStatement dwxhCx = null;
        ResultSet rs = null;
        try {
            // 1.调用oracle存储过程，拿到业务办理进度数据
            connection = druidDataSource.getConnection();
            // 调用过程，返回企业注册的审核信息
            dwxhCx = connection.prepareCall("{call JGJ_KSYW_DWXH.DWXH_CX(?)}");
            dwxhCx.registerOutParameter(1, OracleTypes.CURSOR);
            dwxhCx.execute();
            // 输出结果[第二个参数]
            rs = (ResultSet) dwxhCx.getObject(1);// 此处的2要与存储过程中cursor的问题对应
            while (rs.next()) {
                BusinessProcessing bp = new BusinessProcessing();
                if (StringUtils.hasText(rs.getString(1))) {
                    bp.setBusiLink(rs.getString(1));
                }
                if (StringUtils.hasText(rs.getString(2))) {
                    bp.setBusiType(rs.getString(2));
                }
                if (StringUtils.hasText(rs.getString(3))) {
                    bp.setOpeartor(rs.getString(3));
                }
                if (StringUtils.hasText(rs.getString(4))) {
                    bp.setTel(rs.getString(4));
                }
                if (StringUtils.hasText(rs.getString(5))) {
                    bp.setOpinion(rs.getString(5));
                }
                if (StringUtils.hasText(rs.getString(6))) {
                    bp.setResult(rs.getString(6));
                }
                if (StringUtils.hasText(rs.getString(7))) {
                    bp.setTime(rs.getString(7).substring(0, 19));
                }
                if (StringUtils.hasText(rs.getString(8))) {
                    bp.setUscc(rs.getString(8));
                }
                if (StringUtils.hasText(rs.getString(9))) {
                    bp.setEntName(rs.getString(9));
                }
                if (StringUtils.hasText(rs.getString(10))) {
                    bp.setRn(rs.getString(10));
                }
                if (StringUtils.hasText(rs.getString(11))) {
                    bp.setBusId(rs.getString(11));
                }
                list.add(bp);
            }
            log.info("调用 DWXH_CX 返回数据：{}", JSONObject.toJSONString(list));
        } catch (Exception e) {
            log.error("调用 DWXH_CX 异常：{}", e);
        } finally {
            // 释放资源
            try {
                rs.close();
                dwxhCx.close();
                connection.close();
            } catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }


    public void collDwxhHx(String uscc, Integer value) {
        Connection connection = null;
        CallableStatement pstm = null;
        // 1.调用oracle存储过程，拿到业务办理进度数据
        try {
            // 加载数据库驱动
            connection = druidDataSource.getConnection();
            // 得到预编译的Statement对象
            pstm = connection.prepareCall("{call JGJ_KSYW_DWXH.DWXH_HX(?,?)}");
            pstm.setString(1, uscc);
            pstm.setInt(2, value);
            pstm.execute();
        } catch (Exception e) {
            log.error("调用 DWXH_HX 过程异常：{}", e);
        } finally {
            // 释放资源
            try {
                pstm.close();
                connection.close();
            } catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

}
