package net.cdkj.gjj.adapter.controller;


import net.cdkj.gjj.adapter.service.DeptInfoUpdateService;
import net.cdkj.gjj.adapter.service.DeptLogoutService;
import net.cdkj.gjj.adapter.service.OpenAccountService;
import net.cdkj.gjj.adapter.utils.InternalUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import javax.annotation.Resource;


/**
 * 定时任务类
 *
 * @author huarun
 */
@Component
@EnableScheduling
//@Async
public class AlarmTask {

    private static final Logger log = LoggerFactory.getLogger(AlarmTask.class);

    @Resource
    private OpenAccountService openAccountService;
    @Resource
    private DeptInfoUpdateService deptInfoUpdateService;
    @Resource
    private DeptLogoutService deptLogoutService;

    /**
     * 第一次延迟(initialDelay)?秒后执行，之后按fixedDelay的规则每?秒执行一次
     */
    @Scheduled(initialDelay = 5 * 1000, fixedDelayString = "${dwkhPullTaskDelay}")
    public void dwkhPullTask() {
        try {
            openAccountService.syncDeptInfo();
        } catch (Exception e) {
            log.error("{}", e);
        }
    }

    // 进度数据定时器

    /**
     * 第一次延迟(initialDelay)?秒后执行，之后按fixedDelay的规则每?秒执行一次
     */
    @Scheduled(initialDelay = 20 * 1000, fixedDelayString = "${dwkhPushTaskDelay}")
    public void dwkhPushTask() {
        openAccountService.openAccountPush();
    }

    @Scheduled(initialDelay = 40 * 1000, fixedDelayString = "${dwxxbgPushTaskDelay}")
    public void dwxxbgPushTask() {
        deptInfoUpdateService.deptInfoUpdatePush();
    }

    @Scheduled(initialDelay = 80 * 1000, fixedDelayString = "${dwxhPushTaskDelay}")
    public void dwxhPushTask() {
        deptLogoutService.deptLogoutPush();
    }

}

