package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.BusinessProcessing;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.PropertyqUtil;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import net.cdkj.gjj.adapter.encryptor.JasyptConfig;
import net.cdkj.gjj.adapter.utils.InternalUtils;
import oracle.jdbc.OracleTypes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

import javax.annotation.Resource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.*;


/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "/InternalLogic")
public class DeptInfoUpdateController {

    @Resource
    private RestTemplate restTemplate;


    private static String url;
    private static String user;
    private static String password;

    private static String frontEndProcessorServer;


    static {
        Properties prop = PropertyqUtil.getConfig("application.properties");
        url = JasyptConfig.encryptStr(PropertyqUtil.getPropValue(prop, "url"));
        user = JasyptConfig.encryptStr(PropertyqUtil.getPropValue(prop, "user"));
        password = JasyptConfig.encryptStr(PropertyqUtil.getPropValue(prop, "password"));
        frontEndProcessorServer = PropertyqUtil.getPropValue(prop, "frontEndProcessorServer");
    }


    private static final Logger log = LoggerFactory.getLogger(DeptInfoUpdateController.class);

    /**
     * 公积金系统服务接口内置机调前置机中间接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("/getDwxxbgHttp")
    public String getDwxxbgHttp() {
        Properties prop = PropertyqUtil.getConfig("application.properties");
        JSONObject jsonObject = new JSONObject();
        String type = PropertyqUtil.getPropValue(prop, "timetype");
        if ("1".equals(type)) {// 表示正式环境
            jsonObject.put("startTime", InternalUtils.currentTime(0));// 正式环境
            jsonObject.put("endTime", InternalUtils.currentTime(24));// 正式环境
        } else if ("2".equals(type)) {// 表示测试环境或本地环境
            jsonObject.put("startTime", PropertyqUtil.getPropValue(prop, "startTime"));// 测试环境或本地环境
            jsonObject.put("endTime", PropertyqUtil.getPropValue(prop, "endTime"));// 测试环境或本地环境
        }
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        String str = jsonObject.toString();
        String providentFundServices = frontEndProcessorServer + "/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices";
        //（测试环境地址）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
        String forObject = restTemplate.postForObject(providentFundServices, str, String.class);
        return forObject;
    }



    /**
     * (第一个定时的)
     * 调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，
     * 拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
     *
     * @return
     */
    @ResponseBody
    @PostMapping("/dwxxbgPull")
    public void dwxxbgPull() throws Exception {
        // 1.调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
        String dwxxbgHttp = getDwxxbgHttp();
        log.info("拿到第一个接口返回的第三方数据:{}", dwxxbgHttp);

        Json jsonentity = JSONObject.parseObject(dwxxbgHttp, Json.class);
        List<UnitAccountOpeningInformation> bills = null;
        if (!InternalUtils.isNullOrEmpty(jsonentity)) {
            bills = jsonentity.getData();
        }
        if (!CollectionUtils.isEmpty(bills)) {
            log.info("第三方返回的报文中data数据为空！");
        }

        // 2.内置机处理返回的业务数据，调用oracle存储过程
        Class.forName("oracle.jdbc.driver.OracleDriver");
        Connection connection = DriverManager.getConnection(url, user, password);
        // 得到预编译的Statement对象
        CallableStatement dwxxbgImp = connection.prepareCall("{call JGJ_KSYW_DWXXBG.DWXXBG_IMP(?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)}");
        // 循环插入
        for (UnitAccountOpeningInformation uniInfom : bills) {
            if (!StringUtils.isEmpty(uniInfom.getOplocdistrict())) {
                System.out.println("oplocdistrict" + "在规定的值里面，调imp过程");
                // 业务标识
                String busId = StringUtils.hasText(uniInfom.getBusId()) ? uniInfom.getBusId() : "";
                dwxxbgImp.setString(1, busId);
                // 统一社会信用
                String uscc = StringUtils.hasText(uniInfom.getUscc()) ? uniInfom.getUscc() : "";
                dwxxbgImp.setString(2, uscc);
                // 企业名称
                String entName = StringUtils.hasText(uniInfom.getEntName()) ? uniInfom.getEntName() : "";
                dwxxbgImp.setString(3, entName);
                // 单位地址
                String dom = StringUtils.hasText(uniInfom.getDom()) ? uniInfom.getDom() : "";
                dwxxbgImp.setString(4, dom);
                // 法人代表姓名
                String lerep = StringUtils.hasText(uniInfom.getLerep()) ? uniInfom.getLerep() : "";
                dwxxbgImp.setString(5, lerep);
                // 法人证件类型
                String cerType = StringUtils.hasText(uniInfom.getCerType()) ? uniInfom.getCerType() : "";
                dwxxbgImp.setString(6, cerType);
                // 法人证件号码
                String cerNo = StringUtils.hasText(uniInfom.getCerNo()) ? uniInfom.getCerNo() : "";
                dwxxbgImp.setString(7, cerNo);
                // 经办人姓名
                String operatorName = StringUtils.hasText(uniInfom.getOperatorName()) ? uniInfom.getOperatorName() : "";
                dwxxbgImp.setString(8, operatorName);
                // 经办人身份证号
                String operatorCerNo = StringUtils.hasText(uniInfom.getOperatorCerNo()) ? uniInfom.getOperatorCerNo() : "";
                dwxxbgImp.setString(9, operatorCerNo);
                // 经办人联系电话
                String operatorPhone = StringUtils.hasText(uniInfom.getOperatorPhone()) ? uniInfom.getOperatorPhone() : "";
                dwxxbgImp.setString(10, operatorPhone);
                // 所属区域
                String oplocdistrict = StringUtils.hasText(uniInfom.getOplocdistrict()) ? uniInfom.getOplocdistrict() : "";
                dwxxbgImp.setString(11, oplocdistrict);
                // 单位性质
                String unitNature = StringUtils.hasText(uniInfom.getUnitNature()) ? uniInfom.getUnitNature() : "";
                dwxxbgImp.setString(12, unitNature);
                // 经济类型
                String economicType = StringUtils.hasText(uniInfom.getEconomicType()) ? uniInfom.getEconomicType() : "";
                dwxxbgImp.setString(13, economicType);
                // 所属行业
                String industryphy = StringUtils.hasText(uniInfom.getIndustryphy()) ? uniInfom.getIndustryphy() : "";
                dwxxbgImp.setString(14, industryphy);
                // 单位发薪日
                String unitPayDay = StringUtils.hasText(uniInfom.getUnitPayDay()) ? uniInfom.getUnitPayDay() : "";
                dwxxbgImp.setString(15, unitPayDay);
                // 输出结果[第二个参数]
                dwxxbgImp.registerOutParameter(16, OracleTypes.VARCHAR);
                dwxxbgImp.registerOutParameter(17, OracleTypes.VARCHAR);
                // 执行数据库查询操作
                dwxxbgImp.execute();
                //获取出参
                String errcode = dwxxbgImp.getString(16);
                //String errmsg = dwxxbgImp.getString(17);
                if (StringUtils.isEmpty(errcode)) {
                    break;
                } else {
                    try {
                        // 避免批量插入高并发，此处设置每次停顿5秒
                        Thread.currentThread().sleep(2000);
                        System.out.println("间隔2秒传一条数据调一次存储过程");
                    } catch (InterruptedException e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
        }
        // 调完第一个存储过程DWXX_IMP之后再调DWKH_SAVE存储过程
        CallableStatement dwxxbgSave = connection.prepareCall("{call JGJ_KSYW_DWXXBG.DWXXBG_SAVE()}");
        dwxxbgSave.execute();
        // 释放资源
        dwxxbgImp.close();
        dwxxbgSave.close();
        connection.close();
    }


    /**
     * 住建部门返回公积金办理进度数据接口方法
     * (第二个定时)
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("/dwxxbgPush")
    public String dwxxbgPush() {
        System.out.println("调第二个接口了");
        // 调oracle存储过程拿到进度推进的数据集合
        List<BusinessProcessing> collDwxxbgList = null;
        try {
            collDwxxbgList = collDwxxbg();
        } catch (Exception e) {
            log.info("调用 DWXXBG_CX 异常：{}", e);
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("state", "1");
        if (!collDwxxbgList.isEmpty()) {
            jsonObject.put("timestamp", collDwxxbgList.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getTime());
            jsonObject.put("busId", collDwxxbgList.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getBusId());
        } else {
            jsonObject.put("timestamp", "");
            jsonObject.put("busId", "");
        }
        jsonObject.put("departCode", "10");
        jsonObject.put("nodeList", collDwxxbgList);
        String str = jsonObject.toString();

        String businessprocessingUrl = frontEndProcessorServer + "/FrontEndProcessor/FrontEndProcessor/BusinessProcessing";
        //（测试环境）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
        String forObject = restTemplate.postForObject(businessprocessingUrl, str, String.class);
        // 请求返回的数据
        log.info("前置机返回第三方解压之后的进度推送结果:{}", forObject);
        String uscc = "";
        if (!collDwxxbgList.isEmpty()) {
            uscc = collDwxxbgList.get(0).getUscc();
        }
        JSONObject jsonObj = JSONObject.parseObject(forObject);
        Integer value = "true".equals(jsonObj.getString("success")) ? 1 : 0;
        try {
            log.info("入参 uscc:{} value:{}", uscc, value);
            collDwxxbgHx(uscc, value);
        } catch (Exception e) {
            log.error("调用 DWXXBG_HX 过程异常：{}", e);
        }
        return forObject;

    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * 调用oracle存储过程拿到进度数据，然后请求前置机，让前置机请求市监接口，将办理的进度数据推送给市监
     *
     * @return
     */
    @ResponseBody
    @PostMapping("/collDwxxbg")
    public static List<BusinessProcessing> collDwxxbg() throws Exception {
        // 1.调用oracle存储过程，拿到业务办理进度数据
        Class.forName("oracle.jdbc.driver.OracleDriver");
        Connection connection = DriverManager.getConnection(url, user, password);
        // 调用过程，返回企业注册的审核信息
        CallableStatement dwxxbgCx = connection.prepareCall("{call JGJ_KSYW_DWXXBG.DWXXBG_CX(?)}");
        // 给参数赋值
        dwxxbgCx.registerOutParameter(1, OracleTypes.CURSOR);
        // 执行数据库查询操作
        dwxxbgCx.execute();
        // 输出结果[第二个参数]
        ResultSet rs = (ResultSet) dwxxbgCx.getObject(1);// 此处的2要与存储过程中cursor的问题对应
        List<BusinessProcessing> list = new ArrayList<>();
        while (rs.next()) {
            BusinessProcessing bp = new BusinessProcessing();
            if (StringUtils.hasText(rs.getString(1))) {
                bp.setBusiLink(rs.getString(1));
            }
            if (StringUtils.hasText(rs.getString(2))) {
                bp.setBusiType(rs.getString(2));
            }
            if (StringUtils.hasText(rs.getString(3))) {
                bp.setOpeartor(rs.getString(3));
            }
            if (StringUtils.hasText(rs.getString(4))) {
                bp.setTel(rs.getString(4));
            }
            if (StringUtils.hasText(rs.getString(5))) {
                bp.setOpinion(rs.getString(5));
            }
            if (StringUtils.hasText(rs.getString(6))) {
                bp.setResult(rs.getString(6));
            }
            if (StringUtils.hasText(rs.getString(7))) {
                bp.setTime(rs.getString(7).substring(0, 19));
            }
            if (StringUtils.hasText(rs.getString(8))) {
                bp.setUscc(rs.getString(8));
            }
            if (StringUtils.hasText(rs.getString(9))) {
                bp.setEntName(rs.getString(9));
            }
            if (StringUtils.hasText(rs.getString(10))) {
                bp.setBusId(rs.getString(10));
            }
            list.add(bp);
        }
        log.info("调用 DWXXBG_CX 返回数据：{}", JSONObject.toJSONString(list));
        // 释放资源
        dwxxbgCx.close();
        connection.close();
        return list;
    }


    public static void collDwxxbgHx(String uscc, Integer value) throws Exception {
        // 1.调用oracle存储过程，拿到业务办理进度数据
        // 加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        Connection connection = DriverManager.getConnection(url, user, password);// 正式环境
        // 得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWXXBG.DWXXBG_HX(?,?)}");
        // 给参数赋值
        pstm.setString(1, uscc);
        pstm.setInt(2, value);
        pstm.execute();
        // 释放资源
        pstm.close();
        connection.close();
    }

}
