package net.cdkj.gjj.adapter.controller;


import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;


/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "InternalLogic")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口内置机调前置机中间接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public static String ProvidentFundServices() {
        String token = null;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime", currenttime(0));
        jsonObject.put("endTime", currenttime(24));
        jsonObject.put("app_id", "xxxxx");
        jsonObject.put("app_secret", "xxxxx");
        String str = jsonObject.toString();
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
            URL url = new URL("http://192.168.101.34:8080/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices");//调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
                System.out.println(sb.toString());
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }

        return null;
    }

    /**
     * 获取当天零点零分零秒的时间戳和当天24点的时间戳
     *
     * @return
     */
    @ResponseBody
    @PostMapping("currentime")
    public static String currenttime(int type) {
        String time = null;
        if (type == 0) {
            // 获取当天零点零分零秒的时间戳
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 0);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        } else if (type == 24) {
            // 获取当天24点零分零秒的时间戳,即第二天零点时间
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 24);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        }
        return time;
    }

    /**
     * 调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，
     *拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
     * @return
     */
    @ResponseBody
    @PostMapping("gjjxtfwjk")
    public static void gjjxtfwjk() throws Exception{
        //1.调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
        String jsoninfom=ProvidentFundServices();
        System.out.println(jsoninfom);
        //2.内置机处理返回的业务数据，调用oracle存储过程
        JSONObject jsonObj = JSONObject.parseObject(jsoninfom);
        String str=jsonObj.get("data").toString();
        String str1=str.replace("[","");
        String str2=str1.replace("]","");
        UnitAccountOpeningInformation uniInfom = JSONObject.parseObject(str2,UnitAccountOpeningInformation.class);
        System.out.println(uniInfom);
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
        Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");
        //得到预编译的Statement对象
        CallableStatement pstm=connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_SL(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        //给参数赋值
//        pstm.getString(1);
        pstm.registerOutParameter(1,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.setString(2,uniInfom.getBusId());
        pstm.setString(3,uniInfom.getUscc());
        pstm.setString(4,uniInfom.getEntName());
        pstm.setString(5,uniInfom.getDom());
        pstm.setDate(6,new java.sql.Date(uniInfom.getEstDate().getTime()));
        pstm.setString(7,uniInfom.getLerep());
        pstm.setString(8,uniInfom.getCerType());
        pstm.setString(9,uniInfom.getCerNo());
        pstm.setString(10,uniInfom.getOperatorName());
        pstm.setString(11,uniInfom.getOperatorCerNo());
        pstm.setString(12,uniInfom.getOperatorPhone());
        pstm.setString(13,uniInfom.getOplocdistrict());
        pstm.setString(14,uniInfom.getUnitNature());
        pstm.setString(15,uniInfom.getEconomicType());
        pstm.setString(16,uniInfom.getIndustryphy());
        pstm.setString(17,uniInfom.getUnitPayDay());
        pstm.setString(18,uniInfom.getUnitDepPro());
        pstm.setString(19,uniInfom.getPersonalDepPro());
        pstm.setString(20,"");
        pstm.setString(21,"");
        pstm.registerOutParameter(22,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(23,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(24,oracle.jdbc.OracleTypes.VARCHAR);
        //执行数据库查询操作
        pstm.execute();
        //输出结果[第二个参数]
        System.out.println(pstm.getString(1));
        System.out.println(pstm.getString(22));
        System.out.println(pstm.getString(23));
        System.out.println(pstm.getString(24));
        //释放资源
        pstm.close();
        connection.close();
    }


    /**
     * 调用oracle存储过程
     * @param jsoninfom
     * @throws Exception
     */
    public static void oracleprocess(String jsoninfom) throws Exception {
        JSONObject jsonObj = JSONObject.parseObject(jsoninfom);
        String str=jsonObj.get("data").toString();
        String str1=str.replace("[","");
        String str2=str1.replace("]","");
        UnitAccountOpeningInformation uniInfom = JSONObject.parseObject(str2,UnitAccountOpeningInformation.class);
        System.out.println(uniInfom);
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
        Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");
        //得到预编译的Statement对象
        CallableStatement pstm=connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_SL(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        //给参数赋值
//        pstm.getString(1);
        pstm.registerOutParameter(1,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.setString(2,uniInfom.getBusId());
        pstm.setString(3,uniInfom.getUscc());
        pstm.setString(4,uniInfom.getEntName());
        pstm.setString(5,uniInfom.getDom());
        pstm.setDate(6,new java.sql.Date(uniInfom.getEstDate().getTime()));
        pstm.setString(7,uniInfom.getLerep());
        pstm.setString(8,uniInfom.getCerType());
        pstm.setString(9,uniInfom.getCerNo());
        pstm.setString(10,uniInfom.getOperatorName());
        pstm.setString(11,uniInfom.getOperatorCerNo());
        pstm.setString(12,uniInfom.getOperatorPhone());
        pstm.setString(13,uniInfom.getOplocdistrict());
        pstm.setString(14,uniInfom.getUnitNature());
        pstm.setString(15,uniInfom.getEconomicType());
        pstm.setString(16,uniInfom.getIndustryphy());
        pstm.setString(17,uniInfom.getUnitPayDay());
        pstm.setString(18,uniInfom.getUnitDepPro());
        pstm.setString(19,uniInfom.getPersonalDepPro());
        pstm.setString(20,"");
        pstm.setString(21,"");
        pstm.registerOutParameter(22,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(23,oracle.jdbc.OracleTypes.VARCHAR);
        pstm.registerOutParameter(24,oracle.jdbc.OracleTypes.VARCHAR);
        //执行数据库查询操作
        pstm.execute();
        //输出结果[第二个参数]
        System.out.println(pstm.getString(1));
        System.out.println(pstm.getString(22));
        System.out.println(pstm.getString(23));
        System.out.println(pstm.getString(24));
        //释放资源
        pstm.close();
        connection.close();
    }


}
