package net.cdkj.gjj.adapter.controller;



import com.alibaba.fastjson.JSONObject;
import net.cdkj.gjj.adapter.domain.BusinessProcessing;
import net.cdkj.gjj.adapter.domain.Json;
import net.cdkj.gjj.adapter.domain.UnitAccountOpeningInformation;
import oracle.jdbc.OracleTypes;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.sql.*;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.Date;


/**
 * 公积金系统服务类
 */
@RestController
@RequestMapping(value = "InternalLogic")
public class ProvidentFundServicesController {

    /**
     * 公积金系统服务接口内置机调前置机中间接口
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("ProvidentFundServices")
    public static String ProvidentFundServices() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("startTime", currenttime(0));//正式环境
        jsonObject.put("endTime", currenttime(24));//正式环境
//        jsonObject.put("startTime", "20210520 00:00:00");//测试环境
//        jsonObject.put("endTime", "20210520 23:00:00");//测试环境
        jsonObject.put("app_id", "eb453ca78b354f2c9163a703530f5186");
        jsonObject.put("app_secret", "9a31b84878654a72a999e38ef55aa186");
        String str = jsonObject.toString();
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
            URL url = new URL("http://192.168.1.252:8888/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices");//（测试环境地址）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
//            URL url = new URL("http://192.168.101.34:8080/FrontEndProcessor/FrontEndProcessor/ProvidentFundServices");//（本地测试地址）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = (str).getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            //创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
//                System.out.println("前置机返回第三方解压之后的公积金服务数据："+sb.toString());
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }

        return null;
    }

    /**
     * 获取当天零点零分零秒的时间戳和当天24点的时间戳
     *
     * @return
     */
    @ResponseBody
    @PostMapping("currentime")
    public static String currenttime(int type) {
        String time = null;
        if (type == 0) {
            // 获取当天零点零分零秒的时间戳
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 0);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        } else if (type == 24) {
            // 获取当天24点零分零秒的时间戳,即第二天零点时间
            Calendar curentDay = Calendar.getInstance();
            curentDay.setTime(new Date());
            curentDay.set(Calendar.HOUR_OF_DAY, 24);
            curentDay.set(Calendar.MINUTE, 0);
            curentDay.set(Calendar.SECOND, 0);
            SimpleDateFormat df2 = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            time = df2.format(curentDay.getTime().getTime());
            System.out.println(time);
        }
        return time;
    }

    /**
     * (第一个定时的)
     * 调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，
     * 拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
     *
     * @return
     */
    @ResponseBody
    @PostMapping("gjjxtfwjk")
    public static void gjjxtfwjk() throws Exception {
        //1.调用公积金系统服务接口方法，请求前置机，让前置机请求市监接口，拿到市监返回的开户信息json数据，经过前置机zip解压返回给本内置机处理
        String jsoninfom = ProvidentFundServices();
        System.out.println("拿到第一个接口返回的第三方数据，准备调第一个存储过程" + jsoninfom);
        Json jsonentity = JSONObject.parseObject(jsoninfom, Json.class);
        List<UnitAccountOpeningInformation> bills = new ArrayList<>();
        if (!isNullOrEmpty(jsonentity)) {
            bills = jsonentity.getData();
        }
        //2.内置机处理返回的业务数据，调用oracle存储过程
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
//      Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");//本地环境
//      Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.36:1521:zfgjj", "GJJ80", "GJJ80");//测试环境
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.33:1596:zfgjj", "gjj80", "HG80_Y9E1C5");//正式环境
        //得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWXX_IMP(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)}");
        //调完第一个存储过程DWXX_IMP之后再调DWKH_SAVE存储过程
        CallableStatement pstm2 = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_SAVE()}");
//        System.out.println(""+bills);
        //给参数赋值
//        pstm.getString(1);
        if (!bills.isEmpty()) {
            for (UnitAccountOpeningInformation uniInfom : bills) {
                if (!"".equals(uniInfom.getBusId()) && uniInfom.getBusId() != null) {
                    pstm.setString(1, uniInfom.getBusId());
                } else {
                    pstm.setString(1, "");
                }

                if (!"".equals(uniInfom.getUscc()) && uniInfom.getUscc() != null) {
                    pstm.setString(2, uniInfom.getUscc());
                } else {
                    pstm.setString(2, "");
                }

                if (!"".equals(uniInfom.getEntName()) && uniInfom.getEntName() != null) {
                    pstm.setString(3, uniInfom.getEntName());
                } else {
                    pstm.setString(3, "");
                }

                if (!"".equals(uniInfom.getDom()) && uniInfom.getDom() != null) {
                    pstm.setString(4, uniInfom.getDom());
                } else {
                    pstm.setString(4, "");
                }

                if (!"".equals(uniInfom.getEstDate()) && uniInfom.getEstDate() != null) {
                    pstm.setDate(5, new java.sql.Date(uniInfom.getEstDate().getTime()));
                } else {
                    pstm.setString(5, "");
                }

                if (!"".equals(uniInfom.getLerep()) && uniInfom.getLerep() != null) {
                    pstm.setString(6, uniInfom.getLerep());
                } else {
                    pstm.setString(6, "");
                }

                if (!"".equals(uniInfom.getCerType()) && uniInfom.getCerType() != null) {
                    pstm.setString(7, uniInfom.getCerType());
                } else {
                    pstm.setString(7, "");
                }

                if (!"".equals(uniInfom.getCerNo()) && uniInfom.getCerNo() != null) {
                    pstm.setString(8, uniInfom.getCerNo());
                } else {
                    pstm.setString(8, "");
                }

                if (!"".equals(uniInfom.getOperatorName()) && uniInfom.getOperatorName() != null) {
                    pstm.setString(9, uniInfom.getOperatorName());
                } else {
                    pstm.setString(9, "");
                }

                if (!"".equals(uniInfom.getOperatorCerNo()) && uniInfom.getOperatorCerNo() != null) {
                    pstm.setString(10, uniInfom.getOperatorCerNo());
                } else {
                    pstm.setString(10, "");
                }

                if (!"".equals(uniInfom.getOperatorPhone()) && uniInfom.getOperatorPhone() != null) {
                    pstm.setString(11, uniInfom.getOperatorPhone());
                } else {
                    pstm.setString(11, "");
                }

                if (!"".equals(uniInfom.getOplocdistrict()) && uniInfom.getOplocdistrict() != null) {
                    pstm.setString(12, uniInfom.getOplocdistrict());
                } else {
                    pstm.setString(12, "");
                }

                if (!"".equals(uniInfom.getUnitNature()) && uniInfom.getUnitNature() != null) {
                    pstm.setString(13, uniInfom.getUnitNature());
                } else {
                    pstm.setString(13, "");
                }

                if (!"".equals(uniInfom.getEconomicType()) && uniInfom.getEconomicType() != null) {
                    pstm.setString(14, uniInfom.getEconomicType());
                } else {
                    pstm.setString(14, "");
                }

                if (!"".equals(uniInfom.getIndustryphy()) && uniInfom.getIndustryphy() != null) {
                    pstm.setString(15, uniInfom.getIndustryphy());
                } else {
                    pstm.setString(15, "");
                }

                if (!"".equals(uniInfom.getUnitPayDay()) && uniInfom.getUnitPayDay() != null) {
                    pstm.setString(16, uniInfom.getUnitPayDay());
                } else {
                    pstm.setString(16, "");
                }

                if (!"".equals(uniInfom.getUnitDepPro()) && uniInfom.getUnitDepPro() != null) {
                    pstm.setString(17, uniInfom.getUnitDepPro());
                } else {
                    pstm.setString(17, "");
                }

                if (!"".equals(uniInfom.getPersonalDepPro()) && uniInfom.getPersonalDepPro() != null) {
                    pstm.setString(18, uniInfom.getPersonalDepPro());
                } else {
                    pstm.setString(18, "");
                }
                pstm.registerOutParameter(19, oracle.jdbc.OracleTypes.VARCHAR);
                pstm.registerOutParameter(20, oracle.jdbc.OracleTypes.VARCHAR);
                //执行数据库查询操作
                pstm.execute();
                //输出结果[第二个参数]
                System.out.println(pstm.getString(19));
                System.out.println(pstm.getString(20));
                if ("".equals(pstm.getString(19)) || pstm.getString(19) == null) {
                    break;
                } else {
                    try {
                        // 避免批量插入高并发，此处设置每次停顿5秒
                        Thread.currentThread().sleep(2000);
                        System.out.println("间隔2秒传一条数据调一次存储过程");
                    } catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            pstm2.execute();
        } else {
            System.out.println("第三方返回的报文中data数据为空！");
        }
        //释放资源
        pstm.close();
        pstm2.close();
        connection.close();
    }

    /**
     * 判断一个实体对象是否为空
     *
     * @param obj
     * @return
     */
    public static boolean isNullOrEmpty(Object obj) {
        if (obj == null)
            return true;
        if (obj instanceof CharSequence)
            return ((CharSequence) obj).length() == 0;
        if (obj instanceof Collection)
            return ((Collection) obj).isEmpty();
        if (obj instanceof Map)
            return ((Map) obj).isEmpty();
        if (obj instanceof Object[]) {
            Object[] object = (Object[]) obj;
            if (object.length == 0) {
                return true;
            }
            boolean empty = true;
            for (int i = 0; i < object.length; i++) {
                if (!isNullOrEmpty(object[i])) {
                    empty = false;
                    break;
                }
            }
            return empty;
        }
        return false;
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * (第二个定时)
     *
     * @param
     * @param
     */
    @ResponseBody
    @PostMapping("BusinessProcessing")
    public static String BusinessProcessing() {
        System.out.println("调第二个接口了");
        //调oracle存储过程拿到进度推进的数据集合
        List<BusinessProcessing> list = null;
        try {
            list = zjbmfhywtosj();
        } catch (Exception e) {
            e.printStackTrace();
        }
//        if(!list.isEmpty()){//查到数据才请求第三方接口推送
            System.out.println("调第二个接口了存储过程返回的list" + list);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("state", "1");
            if (!list.isEmpty()) {
                jsonObject.put("timestamp", list.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getTime());
            } else {
                jsonObject.put("timestamp", "");
            }

            if (!list.isEmpty()) {
                jsonObject.put("busId", list.stream().min(Comparator.comparing(BusinessProcessing::getTime)).get().getBusId());
            } else {
                jsonObject.put("busId", "");
            }
            jsonObject.put("departCode", "10");
            jsonObject.put("nodeList", list);
            String str = jsonObject.toString();
            StringBuffer sb = new StringBuffer();
            HttpURLConnection conn = null;
            OutputStream out = null;
            try {
                // 创建url 资源
                URL url = new URL("http://192.168.1.252:8888/FrontEndProcessor/FrontEndProcessor/BusinessProcessing");//（测试环境）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
//            URL url = new URL("http://192.168.101.34:8080/FrontEndProcessor/FrontEndProcessor/BusinessProcessing");//（本地环境）调用前置机将业务机封装的业务json数据发给前置机，让前置机去请求第三方的公积金系统服务接口
                // 创建http 连接
                conn = (HttpURLConnection) url.openConnection();
                // 设置允许输出
                conn.setDoOutput(true);
                // 设置允许输入
                conn.setDoInput(true);
                // 设置不使用缓存
                conn.setUseCaches(false);
                // 设置传递方式
                conn.setRequestMethod("POST");
                // 设置维持长连接
                conn.setRequestProperty("Connection", "Keep-Alive");
                // 设置文件类型:
                conn.setRequestProperty("Content-Type", "application/json");
                // 设置文件字符集:
                conn.setRequestProperty("Charset", "UTF-8");
                // 转换为字节数组
                byte[] data = (str).getBytes("UTF-8");
                // 设置文件长度
                conn.setRequestProperty("Content-Length", String.valueOf(data.length));
                // 开始连接请求
                conn.connect();
                //创建写入流，写入请求的字符串
                out = new DataOutputStream(conn.getOutputStream());
                out.write(data);
                // 请求返回的状态
                if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                    // 请求返回的数据
                    InputStream is = conn.getInputStream();
                    String readLine = new String();
                    BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                    while ((readLine = responseReader.readLine()) != null) {
                        sb.append(readLine);
                    }
                    responseReader.close();
                    System.out.println("前置机返回第三方解压之后的进度推送结果" + sb.toString());
                    String uscc = "";
                    if (!list.isEmpty()) {
                        uscc = list.get(0).getUscc();
                    } else {

                    }
                    System.out.println(uscc);
                    JSONObject jsonObj = JSONObject.parseObject(sb.toString());
                    String success = jsonObj.getString("success");
                    Integer value = 0;
                    if ("true".equals(success)) {
                        value = 1;
                    } else if ("false".equals(success)) {
                        value = 0;
                    }
                    try {
                        zjbmfhywtosjHX(uscc, value);
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println(value);
                    return sb.toString();
                } else {
                    System.out.println("请求失败!!!");
                }
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                if (out != null) {
                    try {
                        out.flush();
                        out.close();
                    } catch (IOException e) {
                    }
                }
                if (conn != null) {
                    conn.disconnect();
                }
            }


        return null;
    }

    /**
     * 住建部门返回公积金办理进度数据接口方法
     * 调用oracle存储过程拿到进度数据，然后请求前置机，让前置机请求市监接口，将办理的进度数据推送给市监
     *
     * @return
     */
    @ResponseBody
    @PostMapping("zjbmfhywtosj")
    public static List<BusinessProcessing> zjbmfhywtosj() throws Exception {
        //1.调用oracle存储过程，拿到业务办理进度数据
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
//      Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");//本地环境
//      Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.36:1521:zfgjj", "GJJ80", "GJJ80");//测试环境
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.33:1596:zfgjj", "gjj80", "HG80_Y9E1C5");//正式环境
        //得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_CX(?)}");
        //给参数赋值
//        pstm.setString(1,"914205007146986289");
        pstm.registerOutParameter(1, OracleTypes.CURSOR);
        //执行数据库查询操作
        pstm.execute();
        //输出结果[第二个参数]
        ResultSet rs = (ResultSet) pstm.getObject(1);//此处的2要与存储过程中cursor的问题对应
        List<BusinessProcessing> list = new ArrayList<>();
        while (rs.next()) {
            BusinessProcessing b = new BusinessProcessing();
//            System.out.println(rs.getString(1));//获取具体的值
            if (!"".equals(rs.getString(1)) && rs.getString(1) != null) {
                b.setBusiLink(rs.getString(1));
            }
//            System.out.println(rs.getString(2));//获取具体的值
            if (!"".equals(rs.getString(2)) && rs.getString(2) != null) {
                b.setBusiType(rs.getString(2));
            }
//            System.out.println(rs.getString(3));//获取具体的值
            if (!"".equals(rs.getString(3)) && rs.getString(3) != null) {
                b.setOpeartor(rs.getString(3));
            }
//            System.out.println(rs.getString(4));//获取具体的值
            if (!"".equals(rs.getString(4)) && rs.getString(4) != null) {
                b.setTel(rs.getString(4));
            }
//            System.out.println(rs.getString(5));//获取具体的值
            if (!"".equals(rs.getString(5)) && rs.getString(5) != null) {
                b.setOpinion(rs.getString(5));
            }
//            System.out.println(rs.getString(6));//获取具体的值
            if (!"".equals(rs.getString(6)) && rs.getString(6) != null) {
                b.setResult(rs.getString(6));
            }
            if (!"".equals(rs.getString(7)) && rs.getString(7) != null) {
                b.setTime(rs.getString(7).substring(0, 19));
            }
//            System.out.println(rs.getString(8));//获取具体的值
            if (!"".equals(rs.getString(8)) && rs.getString(8) != null) {
                b.setUscc(rs.getString(8));
            }
//            System.out.println(rs.getString(9));//获取具体的值
            if (!"".equals(rs.getString(9)) && rs.getString(9) != null) {
                b.setEntName(rs.getString(9));
            }
//            System.out.println(rs.getString(10));//获取具体的值
            if (!"".equals(rs.getString(10)) && rs.getString(10) != null) {
                b.setBusId(rs.getString(10));
            }
            list.add(b);
        }
        System.out.println(list);
        //释放资源
        pstm.close();
        connection.close();
        return list;
    }


    public static void zjbmfhywtosjHX(String uscc, Integer value) throws Exception {
        //1.调用oracle存储过程，拿到业务办理进度数据
        //加载数据库驱动
        Class.forName("oracle.jdbc.driver.OracleDriver");
        //得到Connection连接
//      Connection connection= DriverManager.getConnection("jdbc:oracle:thin:@192.168.101.194:1521:zfgjj", "HG2020", "HG2020");//本地环境
//      Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.36:1521:zfgjj", "GJJ80", "GJJ80");//测试环境
        Connection connection = DriverManager.getConnection("jdbc:oracle:thin:@192.168.1.33:1596:zfgjj", "gjj80", "HG80_Y9E1C5");//正式环境
        //得到预编译的Statement对象
        CallableStatement pstm = connection.prepareCall("{call JGJ_KSYW_DWKH.DWKH_HX(?,?)}");
        //给参数赋值
        pstm.setString(1, uscc);
        pstm.setInt(2, value);
//        pstm.registerOutParameter(1, OracleTypes.CURSOR);
        //执行数据库查询操作
        pstm.execute();
        //输出结果[第二个参数]
        //释放资源
        pstm.close();
        connection.close();
    }

}
