package net.cdkj.gjj.adapter.controller;

import net.cdkj.gjj.adapter.config.JasyptConfig;
import org.jasypt.encryption.StringEncryptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;

@RestController
@RequestMapping("/encrypt")
@CrossOrigin(origins = "*", maxAge = 3600)
public class EncryptController {

    @Resource
    private StringEncryptor jasyptStringEncryptor;

    @PostMapping("/jasyptEnc")
    public String encrypt(@RequestParam String encStr) {
        return jasyptStringEncryptor.encrypt(encStr);
    }

    @PostMapping("/jasyptDec")
    public String decrypt(@RequestParam String decStr) {
        return jasyptStringEncryptor.decrypt(decStr);
    }
}
