package net.cdkj.gjj.adapter.utils;

import javax.servlet.http.HttpServletRequest;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.zip.GZIPInputStream;


public class HttpUtil {


    /**
     * 获取请求入参数据
     */
    public static String getReqData(HttpServletRequest request) {
        StringBuffer json = new StringBuffer();
        String line = null;
        try {
            BufferedReader reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                json.append(line);
            }
        } catch (Exception e) {
            System.out.println(e);
        }
        String str = json.toString();
        System.out.println("要发送给第三方的公积金系统服务报文：" + str);
        return str;
    }


    /**
     * 发起 post 请求
     */
    public static String sendPost(String httpUrl, String content) {
        StringBuffer sb = new StringBuffer();
        HttpURLConnection conn = null;
        OutputStream out = null;
        try {
            // 创建url 资源
            URL url = new URL(httpUrl);
            // 创建http 连接
            conn = (HttpURLConnection) url.openConnection();
            // 设置允许输出
            conn.setDoOutput(true);
            // 设置允许输入
            conn.setDoInput(true);
            // 设置不使用缓存
            conn.setUseCaches(false);
            // 设置传递方式
            conn.setRequestMethod("POST");
            // 设置维持长连接
            conn.setRequestProperty("Connection", "Keep-Alive");
            // 设置文件类型:
            conn.setRequestProperty("Content-Type", "application/json");
            // 设置文件字符集:
            conn.setRequestProperty("Charset", "UTF-8");
            // 转换为字节数组
            byte[] data = content.getBytes("UTF-8");
            // 设置文件长度
            conn.setRequestProperty("Content-Length", String.valueOf(data.length));
            // 开始连接请求
            conn.connect();
            // 创建写入流，写入请求的字符串
            out = new DataOutputStream(conn.getOutputStream());
            out.write(data);
            // 请求返回的状态
            if (HttpURLConnection.HTTP_OK == conn.getResponseCode()) {
                // 请求返回的数据
                InputStream is = conn.getInputStream();
                String readLine = new String();
                BufferedReader responseReader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                while ((readLine = responseReader.readLine()) != null) {
                    sb.append(readLine);
                }
                responseReader.close();
                System.out.println("前置机返回第三方解压之后数据：" + sb);
                return sb.toString();
            } else {
                System.out.println("请求失败!!!");
            }
        } catch (
                IOException e) {
            e.printStackTrace();
        } finally {
            if (out != null) {
                try {
                    out.flush();
                    out.close();
                } catch (IOException e) {
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        return null;
    }


}
