package net.cdkj.gjj.adapter.config;

import org.jasypt.encryption.StringEncryptor;
import org.jasypt.encryption.pbe.PooledPBEStringEncryptor;
import org.jasypt.encryption.pbe.StandardPBEByteEncryptor;
import org.jasypt.encryption.pbe.config.SimpleStringPBEConfig;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * Jasypt 配置
 */
@Configuration
public class JasyptConfig {

    @Bean("jasyptStringEncryptor")
    public StringEncryptor stringEncryptor() {
        PooledPBEStringEncryptor encryptor = new PooledPBEStringEncryptor();
        SimpleStringPBEConfig config = new SimpleStringPBEConfig();
        // 加密盐值
        config.setPassword("gjjcdgs856177110");
        // 加密算法
        config.setAlgorithm(StandardPBEByteEncryptor.DEFAULT_ALGORITHM);
        // key迭代次数
        config.setKeyObtentionIterations("1000");
        // 池大小
        config.setPoolSize("1");
        config.setProviderName("SunJCE");
        // 随机盐生成器
        config.setSaltGeneratorClassName("org.jasypt.salt.RandomSaltGenerator");
        config.setIvGeneratorClassName("org.jasypt.iv.RandomIvGenerator");
        // 加密后输出字符串编码方式
        config.setStringOutputType("base64");
        encryptor.setConfig(config);
        return encryptor;
    }

}

