package io.renren.common.utils;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;


public class EntityUtil {


    /**
     * 判断字段是否为空，并赋值0.0
     * @param entity
     * @return
     * @throws InvocationTargetException
     * @throws IllegalArgumentException
     * @throws IllegalAccessException
     */
    public static boolean checkFieldValueNullAndInit0(Object entity) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException{
        boolean result = true;
        Class<?> cls = entity.getClass();
        Method[] methods = cls.getDeclaredMethods();
        Field[] fields = cls.getDeclaredFields();
        for (Field field : fields) {
            String fieldGenericString=field.toGenericString();
            System.out.println(fieldGenericString);
            if(fieldGenericString.contains("Double")){
                String theFieldSetMethodName=parSetAndGetName(field.getName(), "set");
                System.out.println(theFieldSetMethodName);
                String theFieldGetMethodName=parSetAndGetName(field.getName(), "get");
                System.out.println(theFieldGetMethodName);
                if(!hasMethod(methods, theFieldGetMethodName)){
                    continue;
                }
                try {
                    Method getMethod = cls.getMethod(theFieldGetMethodName, new Class[]{});
                    Object fieldValue=getMethod.invoke(entity, new Object[]{});
                    System.out.println("fieldValue:"+fieldValue);
                    if(checkFieldValueIsNull(fieldValue)){
                        Method setMethod = cls.getMethod(theFieldSetMethodName, new Class[]{Double.class});
                        setMethod.invoke(entity, 0.0);
                    }
                } catch (NoSuchMethodException e) {
                    e.printStackTrace();
                } catch (SecurityException e) {
                    e.printStackTrace();
                }

            }
        }
        return result;
    }

    private static boolean checkFieldValueIsNull(Object fieldValue) {
        // TODO Auto-generated method stub
        if(fieldValue==null || "".equals(fieldValue)){
            return true;
        }else{
            return false;
        }
    }


    /**
     * 判断是否存在某属性的 get或set方法
     *
     * @param methods
     * @param methodName
     * @return boolean
     */
    public static boolean hasMethod(Method[] methods, String methodName) {
        for (Method met : methods) {
            if (methodName.equals(met.getName())) {
                return true;
            }
        }
        return false;
    }

    /**
     * 拼接某属性的 get方法
     *
     * @param fieldName
     * @return String
     */
    public static String parGetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_')
            startIndex = 1;
        return "get"
                + fieldName.substring(startIndex, startIndex + 1).toUpperCase()
                + fieldName.substring(startIndex + 1);
    }

    /**
     * 拼接某属性的 set方法
     *
     * @param fieldName
     * @return String
     */
    public static String parSetName(String fieldName) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_')
            startIndex = 1;
        return "set"
                + fieldName.substring(startIndex, startIndex + 1).toUpperCase()
                + fieldName.substring(startIndex + 1);
    }

    /**
     * 拼接某属性的 set或者get方法
     *
     * @param fieldName
     * @return String
     */
    public static String parSetAndGetName(String fieldName,String setOrGet) {
        if (null == fieldName || "".equals(fieldName)) {
            return null;
        }
        int startIndex = 0;
        if (fieldName.charAt(0) == '_')
            startIndex = 1;
        return setOrGet
                + fieldName.substring(startIndex, startIndex + 1).toUpperCase()
                + fieldName.substring(startIndex + 1);
    }

}

