package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.DyxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.DyxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 单元信息表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:49:15
 */
@RestController
@RequestMapping("app/dyxx")
@Api(tags = "单元信息表模块(单元维护)")
public class DyxxController {

	@Autowired
	private DyxxService dyxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = DyxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, DyxxEntity dyxxEntity) {

		return R.ok().put("data", dyxxService.queryByPage(pageNum, pageSize, dyxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = DyxxEntity.class)
	public R insert(@RequestBody DyxxEntity dyxxEntity) {
		String a = dyxxService.queryfwdybm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String fwdybm = b + c;
		dyxxEntity.setFwdybm(fwdybm);
		dyxxService.insert(dyxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/inserts")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = DyxxEntity.class)
	public R inserts(@RequestBody List<DyxxEntity> list) {
		for(DyxxEntity dyxxEntity:list) {
			String a = dyxxService.queryfwdybm();
			String b = a.substring(0, 3);
			String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
			String fwdybm = b + c;
			dyxxEntity.setFwdybm(fwdybm);
			dyxxService.insert(dyxxEntity);
		}
		return R.ok();
	}


	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = DyxxEntity.class)
	public R update(@RequestBody DyxxEntity dyxxEntity) {
		dyxxService.updateById(dyxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = DyxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		dyxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = DyxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", dyxxService.selectById(id));
	}

	@Login
	@PostMapping("/selectdjld")
	@ApiOperation(value = "下拉框多级联动查询", notes = "在此补充接口详细注释...", response = XlkEntity.class)
	public R selectdjld(@RequestBody Map<String, String> map) {

		return R.ok().put("selectdjld", dyxxService.selectDjld(map));
	}

}
