package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.GwhxxEntity;
import io.renren.modules.app.service.GwhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 管委会信息表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 08:45:42
 */
@RestController
@RequestMapping("app/gwhxx")
@Api(tags = "管委会信息表模块(业主委员会设置)")
public class GwhxxController {

	@Autowired
	private GwhxxService gwhxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = GwhxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, GwhxxEntity gwhxxEntity) {

		return R.ok().put("data", gwhxxService.queryByPage(pageNum, pageSize, gwhxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = GwhxxEntity.class)
	public R insert(@RequestBody GwhxxEntity gwhxxEntity) {
		String a=gwhxxService.querygwhbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String gwhbm = b + c;
		gwhxxEntity.setGwhbm(gwhbm);
		gwhxxService.insert(gwhxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = GwhxxEntity.class)
	public R update(@RequestBody GwhxxEntity gwhxxEntity) {
		gwhxxService.updateById(gwhxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = GwhxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		gwhxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = GwhxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", gwhxxService.selectById(id));
	}

}
