package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HZzsyfpEntity;
import io.renren.modules.app.service.HZzsyfpService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 增值收益分配表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-14 16:09:48
 */
@RestController
@RequestMapping("app/hzzsyfp")
@Api(tags = "增值收益分配表模块")
public class HZzsyfpController {

    @Autowired
    private HZzsyfpService hZzsyfpService;

    @GetMapping("queryByPage")
    @ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = HZzsyfpEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HZzsyfpEntity hZzsyfpEntity) {

        return R.ok().put("data", hZzsyfpService.queryByPage(pageNum, pageSize, hZzsyfpEntity));
    }

    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HZzsyfpEntity.class)
    public R insert(@RequestBody HZzsyfpEntity hZzsyfpEntity) {
        hZzsyfpService.insert(hZzsyfpEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HZzsyfpEntity.class)
    public R update(@RequestBody HZzsyfpEntity hZzsyfpEntity) {
        hZzsyfpService.updateById(hZzsyfpEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HZzsyfpEntity.class)
    public R delete(@RequestBody String[] ids) {
        hZzsyfpService.deleteBatch(ids);
        return R.ok();
    }


    @Login
    @PostMapping("/updateZZSYFP")
    @ApiOperation(value = "修改", notes = "资产收益分配公式修改", response = HZzsyfpEntity.class)
    public R updateZZSYFP(@RequestBody HZzsyfpEntity hZzsyfpEntity) {
        hZzsyfpService.updateZZSYFP(hZzsyfpEntity);
        return R.ok();
    }

}
