package io.renren.modules.app.controller;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HomePage_SsywblEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.HomePageService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 首页大数据查询展示
 *
 * @author lj
 * @email 1271428398@qq.com
 * @date 2019-04-19 00:00:00
 */
@RestController
@RequestMapping("app/homepage")
@Api(tags = "首页大数据展示")
public class HomePageController {

	@Autowired
	private HomePageService pageService;

	@Login
	@GetMapping("/selectSsywbl")
	@ApiOperation(value = "实时业务办理", notes = "", response = HomePage_SsywblEntity.class)
	public R selectSsywbl() {
		return R.ok().put("list", pageService.selectSsywbl());
	}

	@Login
	@GetMapping("/ydqk")
	@ApiOperation(value = "月度情况", notes = "", response = HomePage_SsywblEntity.class)
	public R ydqk() {
		return R.ok().put("data", pageService.ydqk());
	}

	@Login
	@GetMapping("/ndqk")
	@ApiOperation(value = "年度情况", notes = "", response = HomePage_SsywblEntity.class)
	public R ndqk() {
		return R.ok().put("data", pageService.ndqk());
	}

	// @Login
	@PostMapping("/yjnxm")
	@ApiOperation(value = "总体情况已缴纳项目", notes = "", response = YwpzEntity.class)
	public R yjnxm() {
		return R.ok().put("data", pageService.selectyjxmzs());
	}

	// @Login
	@PostMapping("/jecx")
	@ApiOperation(value = "总体情况已缴纳金额,已支出金额,余额", notes = "", response = YwpzEntity.class)
	public R jecx() {
		return R.ok().put("data", pageService.jecx());
	}

	// @Login
	@PostMapping("/sjqk")
	@ApiOperation(value = "实缴情况", notes = "", response = YwpzEntity.class)
	public R sjqk() {
		return R.ok().put("data", pageService.sjqk());
	}
	
	// @Login
		@PostMapping("/jczqqs")
		@ApiOperation(value = "近6个月缴交和支取的趋势", notes = "", response = YwpzEntity.class)
		public R jczqqs() {
			return R.ok().put("data", pageService.jczqqs());
		}
}
