package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.JkSelectEntity;
import io.renren.modules.app.service.JkSelectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 缴款查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/jkselect")
@Api(tags = "缴款查询")
public class JkSelectController {
	
	@Autowired
	private JkSelectService jkSelectService;
	
	@Login
	@GetMapping("selectjkByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = JkSelectEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,JkSelectEntity jkSelectEntity) {
		return R.ok().put("data", jkSelectService.selectjkByPage(pageNum, pageSize, jkSelectEntity));
	}
	
}
