package io.renren.modules.app.controller;

import com.alibaba.fastjson.JSON;
import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.*;
import io.renren.modules.app.service.*;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 楼盘清册导入
 *
 * @author Administrator
 */
@RestController
@RequestMapping("app/lpqcdr")
@Api(tags = "楼盘清册导入")
public class LpqcController {


    @Autowired
    private LpqcService lpqcService;

    @Autowired
    private ZhxxService zhxxService;

    @Autowired
    private DyxxService dyxxService;

    @Autowired
    private FwxxService fwxxService;

    @Autowired
    private GrwxzjService grwxzjService;

    @Autowired
    private GrwxzjfhService grwxzjfhService;

    @Login
    @PostMapping("insertLpqc")
    @Transactional
    @ApiOperation(value = "清册导入", notes = "楼盘清册导入", response = LpqcEntity.class)
    public R queryByPage(@RequestBody Map<String, Object> map) {
        List<ZhxxEntity> zhxxList = (List<ZhxxEntity>) map.get("zhxxList");
        List<DyxxEntity> dyxxList = (List<DyxxEntity>) map.get("dyxxList");
        List<FwxxEntity> fwxxList = JSON.parseArray(JSON.toJSONString(map.get("fwxxList")), FwxxEntity.class);
        String dwbm = map.get("dwbm").toString();
        String xqbm = map.get("xqbm").toString();
        String xmbm = map.get("xmbm").toString();
        String wygsbm = "00010037";
        int nx = 100;
        String fwlx = "0115";
        for (int i = 0; i < zhxxList.size(); i++) {
            // 主键定义
            String a = lpqcService.selectDhbm2();
            String b = a.substring(0, 3);
            String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
            String dhbm = b + c;
            ZhxxEntity zhxxEntity = JSON.parseObject(JSON.toJSONString(zhxxList.get(i)), ZhxxEntity.class);
            int num = lpqcService.selectDhmc(xmbm, zhxxEntity.getDhmc());
            if (num > 0) {
                return R.ok().put("data", "栋号名称已存在！");
            }
            zhxxEntity.setSfdt("0");
            zhxxEntity.setSfgf("0");
            zhxxEntity.setHwlx("0315");
            zhxxEntity.setHs(zhxxEntity.getHs());
            zhxxEntity.setGzdbm("0001");
            zhxxEntity.setWygsbm("00010037");
            zhxxEntity.setXmbm(xmbm);
            zhxxEntity.setDwbm(dwbm);
            zhxxEntity.setHwjg("0208");
            zhxxEntity.setDhbm(dhbm);
            // 楼栋导入
            zhxxService.insert(zhxxEntity);
        }
        for (int i = 0; i < dyxxList.size(); i++) {
            DyxxEntity dyxxEntity = JSON.parseObject(JSON.toJSONString(dyxxList.get(i)), DyxxEntity.class);
            String dhbm = lpqcService.selectDhbm(xmbm, dyxxEntity.getDhmc());
            String a = dyxxService.queryfwdybm();
            String b = a.substring(0, 3);
            String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
            String fwdybm = b + c;
            dyxxEntity.setFwdybm(fwdybm);
            dyxxEntity.setDhbm(dhbm);
            // 单元导入
            lpqcService.insertDyxx(dyxxEntity);
        }
        // 批量获取楼栋信息
        List<String> dhmcList = fwxxList.stream().map(vo -> vo.getDhmc()).collect(Collectors.toList());
        List<ZhxxEntity> zhxxEntities = zhxxService.selectDhbmList(xmbm, dhmcList);
        Map<String, String> dhbmMap = zhxxEntities.stream().collect(Collectors.toMap(vo -> vo.getDhmc(), vo -> vo.getDhbm()));
        List<DyxxEntity> dyxxEntities = dyxxService.selectDybmList(new ArrayList<>(dhbmMap.values()));
        Map<String, String> fwdybmMap = dyxxEntities.stream().collect(Collectors.toMap(vo -> vo.getDhbm().concat(vo.getDymc()), vo -> vo.getFwdybm()));
        String fwbm = lpqcService.querydhbm();
        for (int i = 0; i < fwxxList.size(); i++) {
            FwxxEntity fwxxEntity = fwxxList.get(i);
            // 房屋编码
            fwbm = Integer.toString(Integer.parseInt(fwbm) + 1);
            // 栋号编码
            String dhbm = dhbmMap.get(fwxxEntity.getDhmc());
            // 单元编码
            String mh = fwdybmMap.get(dhbm.concat(fwxxEntity.getDymc()));
            fwxxEntity.setDhbm(dhbm);
            fwxxEntity.setMh(mh);
            fwxxEntity.setFwbm(fwbm);
            fwxxEntity.setJsbz("0");
            fwxxEntity.setSfyj("0");
            fwxxEntity.setHx("0401");
            fwxxEntity.setFwxz("0115");
        }
        // 房屋导入
        if (!CollectionUtils.isEmpty(fwxxList)) {
            lpqcService.insertFwxxList(fwxxList);
        }
        // 当出现同一楼栋不同单元楼层不一样的时候，在此处处理一下，因为导入的时候是按照同一楼栋每个单元楼层数一样处理的
        for (int i = 0; i < zhxxList.size(); i++) {
            ZhxxEntity zhxxEntity = JSON.parseObject(JSON.toJSONString(zhxxList.get(i)), ZhxxEntity.class);
            // 查dhbm再set导zhxxentity里面
            zhxxEntity.setXmbm(xmbm);
            ZhxxEntity z = lpqcService.selectdhbmbymc(zhxxEntity);
            List<Integer> list = lpqcService.selectdhbmbyxmdh(zhxxEntity);
            Integer max = list.get(0);
            Integer min = list.get(0);
            for (int j = 0; j < list.size(); j++) {
                if (min > list.get(j)) {
                    min = list.get(j);
                }
                if (max < list.get(j)) {
                    max = list.get(j);
                }
            }
            zhxxEntity.setLcs(max);
            zhxxEntity.setDhbm(z.getDhbm());
            lpqcService.updatezhxxlcs(zhxxEntity);
        }
        return R.ok();
    }

    // @Login
    @PostMapping("/selectdhbmfwbm")
    @ApiOperation(value = "通过楼盘清册勾选对应的房屋批量个人预交房屋的接口", notes = "", response = FwxxEntity.class)
    public R selectdhbmfwbm(@RequestBody List<ZhxxEntity> list) {
        List<FwxxEntity> fs = new ArrayList<FwxxEntity>();
        List<FwxxEntity> fs2 = new ArrayList<FwxxEntity>();
        List<YwpzEntity> listy = new ArrayList<YwpzEntity>();
        List<DhbmyjEntity> dhyjs = new ArrayList<DhbmyjEntity>();
        for (ZhxxEntity z : list) {
            FwxxEntity f = new FwxxEntity();
            FwxxEntity f2 = new FwxxEntity();
            String fwbm = lpqcService.selectdhbmfwbm(z);
            if ("".equals(fwbm) || fwbm == null) {
                f.setMphm(z.getMphm());
                fs.add(f);
            } else {
                f2.setFwbm(fwbm);
                f2.setDjrq(z.getDjrq());
            }
            fs2.add(f2);
        }
        if (!fs.isEmpty()) {
            return R.error("存在勾选的房屋在系统中不存在").put("data", fs);// fs只要不为空，就存在没有找到对应的房屋
        } else {
            for (FwxxEntity f3 : fs2) {
                YwpzEntity y = new YwpzEntity();
                FwxxEntity f4 = lpqcService.selectfwxx(f3.getFwbm());
                Double je = f4.getMj() * f4.getGrjjl();
                ZhxxEntity z = grwxzjService.selectdhdw(f3.getFwbm());
                y.setDjrq(f3.getDjrq());
                y.setKjqj(f3.getDjrq().substring(0, 7));
                y.setCbwdbm("0001");
                y.setZph("0");
                y.setJe(je);
                y.setCzybm("7");
                y.setCzyxm("系统");
                y.setDwbm(z.getDwbm());
                y.setDhbm(z.getDhbm());
                y.setFwbm(f3.getFwbm());
                y.setBankCode("00010001");
                y.setJsfs("31");
                y.setSfyj(f4.getSfyj());
                listy.add(y);
            }
            for (YwpzEntity y2 : listy) {
                if ("0".equals(y2.getSfyj())) {
                    String djbh = grwxzjService.insertGr2(y2);
                    try {
                        // 避免批量插入高并发，主键中的时间相同，导致主键冲突，此处设置每次停顿1秒
                        Thread.currentThread().sleep(1000);
                    } catch (InterruptedException e) {

                        e.printStackTrace();
                    }
                    DhbmyjEntity d = new DhbmyjEntity();
                    d.setDjbh(djbh);
                    d.setShrbm("7");
                    d.setShrxm("系统");
                    dhyjs.add(d);
                } else {
                    // 该房屋已经缴过
                }

            }
            grwxzjfhService.updateFh(dhyjs);
        }
        return R.ok();
    }


}
