package io.renren.modules.app.controller;


import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FhmxzEntity;
import io.renren.modules.app.entity.HPzEntity2;
import io.renren.modules.app.entity.RjzEntity;
import io.renren.modules.app.service.FhmxzService;
import io.renren.modules.app.service.RjzService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 日记账查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/rjz")
@Api(tags = "日记账查询")
public class RjzController {
	@Autowired
	private RjzService rjzService;
	
	@Login
	@GetMapping("rjzSelectByPage")
	@ApiOperation(value = "列表", notes = "日记账查询", response = RjzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,RjzEntity rjzEntity) throws Exception {
		return R.ok().put("data", rjzService.rjzSelectByPage(pageNum, pageSize, rjzEntity));
	}
	
	
	@Login
	@GetMapping("pzjlSelct")
	@ApiOperation(value = "凭证记录查询", notes = "凭证记录查询", response = HPzEntity2.class)
	public R pzjlSelct(Integer pageNum, Integer pageSize,HPzEntity2 rjzEntity2) throws Exception {
		return R.ok().put("data", rjzService.pzjlSelect(rjzEntity2));
	}
}
