package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.SysdocEntity;
import io.renren.modules.app.service.SysdocService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 
 *
 * @author wt
 * @email 1271428398@qq.com
 * @date 2019-07-02 11:08:02
 */
@RestController
@RequestMapping("app/sysdoc")
@Api(tags = "档案管理模块")
public class SysdocController {

	@Autowired
	private SysdocService sysdocService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = SysdocEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, SysdocEntity sysdocEntity) {
		return R.ok().put("data", sysdocService.queryByPage(pageNum, pageSize, sysdocEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = SysdocEntity.class)
	public R insert(@RequestBody SysdocEntity sysdocEntity) {
		// 根据文件名称获取文件类型
		String fileName = sysdocEntity.getName();
		String fileTyle = fileName.substring(fileName.lastIndexOf("."), fileName.length());
		sysdocEntity.setType(fileTyle);
		sysdocService.insert(sysdocEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = SysdocEntity.class)
	public R update(@RequestBody SysdocEntity sysdocEntity) {
		// 根据文件名称获取文件类型
		String fileName = sysdocEntity.getName();
		String fileTyle = fileName.substring(fileName.lastIndexOf("."), fileName.length());
		sysdocEntity.setType(fileTyle);
		sysdocService.updateById(sysdocEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = SysdocEntity.class)
	public R delete(@RequestBody String[] ids) {
		System.out.println("============");
		sysdocService.deleteBatch(ids);
		return R.ok();
	}
}
