package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.WxzjxjService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 个人维修资金续(补)缴
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/wxzjxj")
@Api(tags = "个人维修资金续(补)缴模块(个人维修资金续(补)缴)")
public class WxzjxjController {

	@Autowired
	private WxzjxjService wxzjxjService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {
		

		return R.ok().put("select", wxzjxjService.selectxlk(map));
	}

	@Login
	@PostMapping("/selectfwxx")
	@ApiOperation(value = "列表", notes = "", response = FwxxEntity.class)
	public R selectfwxx(@RequestBody YwpzEntity ywpzEntity) {

		return R.ok().put("select", wxzjxjService.selectfwxx(ywpzEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "新增维修资金预交(操作Ywpz表)", response = YwpzEntity.class)
	public R insert(@RequestBody YwpzEntity ywpzEntity) {
		wxzjxjService.insertBc(ywpzEntity);
		return R.ok();
	}

	/**
	 * 个人续交批量导入
	 * @param list
	 * @return
	 */
	@Login
	@PostMapping("/inserts")
	@ApiOperation(value = "保存", notes = "新增维修资金预交(操作Ywpz表)", response = YwpzEntity.class)
	public R insert(@RequestBody List<YwpzEntity> list) {
		for(YwpzEntity ywpzEntity:list){
			wxzjxjService.insertBc(ywpzEntity);
		}
		return R.ok();
	}


	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(个人维修资金续补交查询)", response = YwpzEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {

		return R.ok().put("data", wxzjxjService.queryByPage(pageNum, pageSize, ywpzEntity));
	}
	
	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "取消续补交", notes = "取消个人续缴")
	public R deletexj(@RequestBody YwpzEntity ywpzEntity) {
		wxzjxjService.deletexj(ywpzEntity);
		return R.ok();
	}

}
