package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.SqwxzqDao;
import io.renren.modules.app.dao.WxjlbDao;
import io.renren.modules.app.dao.ZhxxtempDao;
import io.renren.modules.app.entity.FjEntity;
import io.renren.modules.app.entity.SqwxzqEntity;
import io.renren.modules.app.entity.WxjlbEntity;
import io.renren.modules.app.entity.WxxmxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.service.SqwxzqService;
import io.renren.modules.app.service.WxjlbService;
import javassist.expr.NewArray;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;


@Service("sqwxzqService")
public class SqwxzqServiceImpl extends ServiceImpl<SqwxzqDao, SqwxzqEntity> implements SqwxzqService {

	 @Autowired
	    private WxjlbDao WxjlbDao;
	 @Autowired
	    private ZhxxtempDao ZhxxtempDao;
    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param sqwxzqEntity
     * @return
     */
    @Override
    public PageInfo<SqwxzqEntity> queryByPage(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<SqwxzqEntity> sqwxzqEntitys = baseMapper.queryByPage(sqwxzqEntity);
        for(int i=0;i<sqwxzqEntitys.size();i++){
        	List<WxjlbEntity> js=baseMapper.selectwxxmxxbysqdh(sqwxzqEntitys.get(i).getSqdbh());
        	sqwxzqEntitys.get(i).setWxlb(js);
        	FjEntity js2=baseMapper.selectwjdxbyfjid(sqwxzqEntitys.get(i).getFjid());
        	if(js2!=null||!"".equals(js2)){
        	sqwxzqEntitys.get(i).setWjdx(js2);	
        	}
        	//由于可能是按小区分摊存在多个项目，所以项目名称单独取
        	List<String> l=baseMapper.queryByxm(sqwxzqEntitys.get(i).getSqdbh());
        	String xmmc="";
        	for(String str:l){
        		if(str.equals(l.get(0))){
        			xmmc=xmmc+str;
        		}else{
        			xmmc=xmmc+","+str;	
        		}
        	}
        	sqwxzqEntitys.get(i).setXmmc(xmmc);
        }
        
        PageInfo<SqwxzqEntity> pageInfo = new PageInfo<SqwxzqEntity>(sqwxzqEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


	@Override
	public String queryByCount(String date) {
		
		return baseMapper.queryByCount(date);
	}

	@Override
	public List<XlkEntity> selectDjld(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			//查询所有未审核和驳回的单据信息
			list = baseMapper.selectdjbh();
		}else if("xqbm".equals(map.get("XQBM"))){
			list=baseMapper.selectxmbyxq(map.get("xqbmz"));
		}else if("xmbm".equals(map.get("XMBM"))){
			list=baseMapper.selectlzbyxm(map.get("xmbmz"));
		}
		return list;
	}



	@Override
	public SqwxzqEntity selectDjxx(Map<String, String> map) {
		
		return baseMapper.selectsqdjxx(map.get("sqdbh"));
	}

	@Override
	public List<WxxmxxEntity> selectWxxmxx(Map<String,String> map) {
		List<WxxmxxEntity> list=new ArrayList<WxxmxxEntity>(); 
		if(map.isEmpty()){
			list= baseMapper.selectwxxmxx();
		}else if("wxxmmc".equals(map.get("WXXMMC"))){
			list=baseMapper.selectwxxmxxbymc(map.get("wxxmmcz"));
		}
		return list;
	}

	@Override
	public SqwxzqEntity query(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		SqwxzqEntity s = baseMapper.query(sqwxzqEntity);
		Map m = new HashMap();
		m.put("sqdbh", s.getSqdbh());
		s.setWxlb(WxjlbDao.query(m));
		return s;
	}

	@Override
	public List<SqwxzqEntity> querym(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		return baseMapper.querym(sqwxzqEntity);
	}

	@Override
	public List<SqwxzqEntity> querys(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		return baseMapper.querys(sqwxzqEntity);
	}

	@Override
	public SqwxzqEntity querft(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		SqwxzqEntity s = baseMapper.query(sqwxzqEntity);
		if("0".equals(s.getSffp())) {
			s.setFtmx(ZhxxtempDao.queryqb(s));
		}else {
			s.setFtmx(ZhxxtempDao.querymx(s));
		}
		return s;
	}

	@Override
	public void queryftsc(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		ZhxxtempDao.queryftsc(sqwxzqEntity);
	}

	@Override
	public void queryftbc(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		ZhxxtempDao.queryftbc(sqwxzqEntity);
	}

	@Override
	public SqwxzqEntity querykjqj(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		return baseMapper.querykjqj(sqwxzqEntity);
	}

	@Override
	public SqwxzqEntity querydjbh(SqwxzqEntity sqwxzqEntity) {
		// TODO Auto-generated method stub
		SqwxzqEntity s = baseMapper.querykjqj(sqwxzqEntity);
		int i = baseMapper.querydjbh(sqwxzqEntity);
		String djbh = null;
		if(i>0&&i<10) {
			djbh = "0000"+ i;
		}else if(i>=10&&i<100) {
			djbh = "000"+ i;
		}else if(i>=100&&i<1000) {
			djbh = "00"+ i;
		}else if(i>=1000&&i<10000) {
			djbh = "0"+ i;
		}else {
			djbh = ""+ i;
		}
		s.setDjbh(djbh);
		return s;
	}

	@Override
	public void insertsqwxz(SqwxzqEntity sqwxzqEntity) {
		
		baseMapper.insertsqwxz(sqwxzqEntity);
	}

	@Override
	public void insertwxjlb(WxjlbEntity wxjlbEntity) {
		
		baseMapper.insertwxjlb(wxjlbEntity);
	}

	@Override
	public SqwxzqEntity selectlrdjxq(Map<String, String> map) {
		SqwxzqEntity s=baseMapper.selectsqdjxx(map.get("sqdbh"));
		List<WxjlbEntity> w=baseMapper.selectwxxmxxbysqdh(s.getSqdbh());
		s.setWxlb(w);
		return s;
	}

	@Override
	public List<WxjlbEntity> selectlrwxxmxq(Map<String, String> map) {
		
		return baseMapper.selectwxxmxxbysqdh(map.get("sqdbh"));
	}

	@Override
	public void updatelr(SqwxzqEntity sqwxzqEntity) {
		//1.根据申请单编号修改sqwxzq表中该条数据。
		baseMapper.updatesqdj(sqwxzqEntity);
		//2.遍历传过来的wxlb，根据wxjlb中该id修改每一个数据。
		for(int i=0;i<sqwxzqEntity.getWxlb().size();i++){
			//如果id不为空就是修改维修项目
			//1.根据该sqdbh去查wxjlb中得维修项，根据表里每条数据得sqdbh和fybm判断传过来wxjl集合里每条数据得sqdbh，
			//a.若表某条sqdbh=集合某条sqdbh，则是修改
			//b.若表某条sqdbh不等于集合某条申请单号，
			if(!"".equals(sqwxzqEntity.getWxlb().get(i).getId())){
				baseMapper.updatewxjlb(sqwxzqEntity.getWxlb().get(i));
			}else if("".equals(sqwxzqEntity.getWxlb().get(i).getId()) && !"".equals(sqwxzqEntity.getWxlb().get(i).getFybm())){
				//如果id为空则是新增一条维修项目
				String uuid = UUID.randomUUID().toString().replaceAll("-", "");
				sqwxzqEntity.getWxlb().get(i).setId(uuid);
				sqwxzqEntity.getWxlb().get(i).setSqdbh(sqwxzqEntity.getSqdbh());
//				sqwxzqEntity.getWxlb().get(i).setDhbm(sqwxzqEntity.getDhbm());
				baseMapper.insertwxjlb(sqwxzqEntity.getWxlb().get(i));
			}
		}
		List<WxjlbEntity> list=baseMapper.selectwxxmxxbysqdh(sqwxzqEntity.getSqdbh());
		List<String> list2=new ArrayList<String>();
		for(int j=0;j<sqwxzqEntity.getWxlb().size();j++){
			list2.add(sqwxzqEntity.getWxlb().get(j).getFybm());
		}
		for(int k=0;k<list.size();k++){
			boolean x=list2.contains(list.get(k).getFybm());
			if(x==true){
				
			}else if(x==false){
				baseMapper.deletewxjlbbyid(list.get(k).getId());
			}
		}
	}

	@Override
	public void deletelr(Map<String, String> map) {
		//1.根据申请单据删除sqwxzq中该条记录。
		baseMapper.deletesqdj(map.get("sqdbh"));
		//2.根据申请单据删除wxjlb中对应的记录。
		baseMapper.deletewxjlb(map.get("sqdbh"));
	}

	@Override
	public String getWjqljById(String id) {
		
		return baseMapper.getWjqljById(id);
	}

	@Override
	public void insertFjb(FjEntity fjEntity) {
		
		baseMapper.insertFjb(fjEntity);
	}
}