package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.WxzjxjDao;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjxjService;
import io.renren.modules.app.utils.MoneyUtil;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

import org.springframework.stereotype.Service;

@Service("wxzjxjService")
public class WxzjxjServiceImpl extends ServiceImpl<WxzjxjDao, YwpzEntity> implements WxzjxjService {

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			//查询所有小区
			list = baseMapper.selectxq();
		}else if("xqbm".equals(map.get("XQBM"))){
			//根据小区编码查询对应项目
			list=baseMapper.selectxm(map.get("xqbmz"));
		}else if("xmbm".equals(map.get("XMBM"))){
			//根据项目编码查询对应楼幢
			list=baseMapper.selectlz(map.get("xmbmz"));
		}else if("dhbm".equals(map.get("DHBM"))){
			//查询所有房屋
			list=baseMapper.selectfwbylz(map.get("dhbmz"));
		}else if("jsyh".equals(map.get("JSYH"))){
			//查询所有结算银行
			list=baseMapper.selectjsyh();
		}else if("jsfs".equals(map.get("JSFS"))){
			//查询所有结算方式
			list=baseMapper.selectjsfs();
		}
		return list;
	}

	@Override
	public FwxxEntity selectfwxx(YwpzEntity ywpzEntity) {
		
		return baseMapper.selectfw(ywpzEntity);
	}

	@Override
	public void insertBc(YwpzEntity ywpzEntity) {
		ywpzEntity.setDjlx("05");
		String temp_str="";   
	    Date dt = new Date();   
	    //最后的aa表示“上午”或“下午”    HH表示24小时制    如果换成hh表示12小时制   
	    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");   
	    temp_str=sdf.format(dt); 
	    
	    String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "05" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "05" + temp_str1 + result;
		}
		ywpzEntity.setShrq(temp_str);//创建日期
		ywpzEntity.setDjbh(newdjbh);
		XlkEntity x=baseMapper.selectxmbydh(ywpzEntity.getDhbm());
		ywpzEntity.setDwbm(x.getDwbm());
		ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
		baseMapper.insertbc(ywpzEntity);
		baseMapper.insertgrmx(ywpzEntity);
		FwxxEntity f=baseMapper.selectfw(ywpzEntity);
		f.setGrje(f.getGrje()+ywpzEntity.getJe());
		f.setDqye(f.getDqye()+ywpzEntity.getJe());
		baseMapper.updatefwgrje(f);
		ZhxxEntity z=baseMapper.selectzhxx(ywpzEntity.getDhbm());
		z.setGryjje(z.getGryjje()+ywpzEntity.getJe());
		z.setDqye(z.getDqye()+ywpzEntity.getJe());
		baseMapper.updatezhxx(z);
	}
	
	@Override
	public PageInfo<YwpzEntity> queryByPage(Integer pageNum, Integer pageSize,
			YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);
		for(YwpzEntity y:ywpzEntitys){
			String a = y.getJe().toString();
			y.setJedx(MoneyUtil.toChinese(a));
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public void deletexj(YwpzEntity ywpzEntity) {
		//1.根据djbh单据编号删除ywpz表和ywpzmx表中续缴的记录。
		baseMapper.deleteywpz(ywpzEntity.getDjbh());
		baseMapper.deleteywpzmx(ywpzEntity.getDjbh());
		//2.根据fwbm减掉fwxx表中该房屋续缴的个人预交金额。
		FwxxEntity f=baseMapper.selectfw(ywpzEntity);
		f.setGrje(f.getGrje()-ywpzEntity.getJe());
		f.setDqye(f.getDqye()-ywpzEntity.getJe());
		baseMapper.updatefwgrje(f);
		ZhxxEntity z=baseMapper.selectzhxx(ywpzEntity.getDhbm());
		z.setGryjje(z.getGryjje()-ywpzEntity.getJe());
		z.setDqye(z.getDqye()-ywpzEntity.getJe());
		baseMapper.updatezhxx(z);
	}

}
