package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.HGryjxEntity;
import io.renren.modules.app.entity.HPzEntity;
import io.renren.modules.app.entity.JieXiEntity;
import io.renren.modules.app.entity.LlbEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XtcsEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjyjdrService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;

/**
 * 期末处理
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/wxzjyjdr")
@Api(tags = "期末处理")
public class WxzjyjdrController {

	@Autowired
	private WxzjyjdrService wxzjyjdrService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody String id) {

		return R.ok().put("select", wxzjyjdrService.selectxlk(id));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "保存", notes = "", response = YwpzEntity.class)
	public R insert(@RequestBody YwpzEntity ywpzEntity) {
		wxzjyjdrService.insertBc(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/updateCWYJ")
	@ApiOperation(value = "财务月末结转", notes = "", response = R.class)
	public R updateCWYJ(@RequestBody YwpzEntity ywpzEntity) {
		ywpzEntity.setZtbm("0003");
		// 5.判断该会计期间归集是否已经月结
		String sfjz = wxzjyjdrService.selectsfyj(ywpzEntity);
		// 6.判断当前会计期间财务是否已经月结
		String cwsfjz = wxzjyjdrService.selectcwsfyj(ywpzEntity);
		// 7.判断上月会计期间财务是否月结。
		String scwsfjz = wxzjyjdrService.selectscwsfyj(ywpzEntity);
		// 8.财务月结之前判断当前会计期间是否还存在未记账的凭证
		List<HPzEntity> listp = wxzjyjdrService.selectpzjz(ywpzEntity);
		if ("0".equals(sfjz)) {
			return R.error("当前会计期间归集没有月结，财务不能月结");
		} else if ("1".equals(cwsfjz)) {
			return R.error("当前会计期间财务已月结,不能重复月结");
		} else if ("0".equals(scwsfjz)) {
			return R.error("上一个会计期间财务没有月结，当前财务会计期间不能月结");
		} else if (!listp.isEmpty()) {
			return R.error("当前会计期间存在凭证没有记账，不能月结");
		} else {
			// 此处财务月结
			// 1.将财务核算期间表中sfjz是否月结状态改为1
			wxzjyjdrService.updatecwhsqj(ywpzEntity);
			// 2.h_kmye科目余额表中刷入当月的发生额，及刷入下个月的期初余额数据。
			hskmye(ywpzEntity);
			hskmye2(ywpzEntity);
			// 3.将h_zt中当前会计期间自动修改为下月
			String kjqj = ywpzEntity.getKjqj();
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, 1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			ywpzEntity.setKjqj(datestr);
			wxzjyjdrService.updatehzt(ywpzEntity);
			wxzjyjdrService.insertcwhsqj(datestr);
		}
		return R.ok("月结成功，请重新登录");
	}

	// @Login
	@PostMapping("/updateCWFYJ")
	@ApiOperation(value = "财务反月末结转", notes = "", response = R.class)
	public R updateCWFYJ(@RequestBody YwpzEntity ywpzEntity) {
		ywpzEntity.setZtbm("0003");
		// 7.判断上月会计期间财务是否月结。
		String scwsfjz = wxzjyjdrService.selectscwsfyj(ywpzEntity);
		if ("0".equals(scwsfjz)) {
			return R.error("上一个会计期间财务没有月结，当前会计期间不能反月结");
		} else {
			// 财务反月结
			// 2.h_kmye科目余额表中刷入当月的发生额，及刷入下个月的期初余额数据。
			// 清除本个月的期初余额
			wxzjyjdrService.deleteqcye(ywpzEntity);
			// 3.将h_zt中当前会计期间自动修改为下月
			String kjqj = ywpzEntity.getKjqj();
			wxzjyjdrService.deletecwhsqj(kjqj);
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, -1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			ywpzEntity.setKjqj(datestr);
			wxzjyjdrService.updatehzt(ywpzEntity);
			// 此处反月结
			// 1.将财务核算期间表中sfjz是否月结状态改为0
			wxzjyjdrService.updatecwfhsqj(ywpzEntity);
			// 清掉上月的发生额。
			wxzjyjdrService.updatefse(ywpzEntity);
		}
		return R.ok("反月结成功，请重新登录");
	}

	// @Login
	@PostMapping("/updatekmye")
	@ApiOperation(value = "脚本,刷每个会计期间jfje，dfje,ljjfje,ljdfje。", notes = "2", response = YwpzEntity.class)
	public R hskmye(@RequestBody YwpzEntity ywpzEntity) {
		wxzjyjdrService.h_kmye(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/updatekmye2")
	@ApiOperation(value = "脚本,生成下一个月余额得期初余额数据。", notes = "", response = YwpzEntity.class)
	public R hskmye2(@RequestBody YwpzEntity ywpzEntity) {
		wxzjyjdrService.h_kmye2(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/updatekmye3")
	@ApiOperation(value = "", notes = "3", response = YwpzEntity.class)
	public R hskmye3(@RequestBody YwpzEntity ywpzEntity) {
		wxzjyjdrService.h_kmye3(ywpzEntity);
		return R.ok();
	}

	// @Login
	@PostMapping("/updatekmye4")
	@ApiOperation(value = "若h_kmye表会计期间没有凭证发生额，则一直补到当前", notes = "4")
	public R hskmye4() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		java.util.Date dBegin = null;
		try {
			dBegin = sdf.parse("2010-02");
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		java.util.Date dEnd = null;
		try {
			dEnd = sdf.parse("2019-01");
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<String> datas = wxzjyjdrService.findDates(dBegin, dEnd);
		for (String kjqj : datas) {
			YwpzEntity ywpzEntity = new YwpzEntity();
			ywpzEntity.setKjqj(kjqj);
			wxzjyjdrService.h_kmye3(ywpzEntity);
		}

		return R.ok();
	}

	// @Login
	@PostMapping("/kmqiquan")
	@ApiOperation(value = "若h_kmye表中没有h_km表中所有科目，则，刷此脚本，将h_km中所有的科目刷到h_kmye表中的脚本", notes = "1", response = YwpzEntity.class)
	public R kmqiquan() {
		wxzjyjdrService.kmqiquan();
		return R.ok();
	}

	// @Login
	@PostMapping("/updateGJYJ")
	@ApiOperation(value = "归集月末结转", notes = "", response = R.class)
	public R updateGJYJ(@RequestBody YwpzEntity ywpzEntity) {
		// 1.判断归集点是否存在
		int count1 = wxzjyjdrService.selectgzd(ywpzEntity.getGzdbm());
		// 2.判断该归集点是否配置了系统参数(此归集点所对应的系统参数是否存在)
		int count2 = wxzjyjdrService.selectxtcs(ywpzEntity.getGzdbm());
		// 4.(h_hsqj核算期间表)判断当前会计期间在核算期间表中是否存在
		int count4 = wxzjyjdrService.selecthsqj(ywpzEntity);
		// 5.(h_hsqj核算期间表)若当钱会计期间在核算期间表中存在需要判断该会计期间是否已经月结
		String sfjz = wxzjyjdrService.selectsfyj(ywpzEntity);
		// 6.判断当前会计期间是否存在未审核的单位缴交记录
		int count5 = wxzjyjdrService.selectdwjk(ywpzEntity);
		// 7.判断当前会计期间是否存在未审核的个人缴交记录
		int count6 = wxzjyjdrService.selectgrjk(ywpzEntity);
		// 8.维修资金平衡检查
		// 8.1.未分摊维修资金平衡检查
		List<YwpzEntity> listwftphjc = wxzjyjdrService.selectwftphjc(ywpzEntity);
		// 8.2.已分摊维修资金平衡检查
		List<YwpzEntity> listyftphjc = wxzjyjdrService.selectyftphjc(ywpzEntity);
		// 8.3.个人维修资金平衡检查
		List<YwpzEntity> listgrwxzjphjc = wxzjyjdrService.selectgrwxzjphjc(ywpzEntity);
		int count8 = wxzjyjdrService.selectzqmzw(ywpzEntity);
		if (count1 == 0) {
			return R.error("归集点不存在");
		} else if (count2 == 0) {
			return R.error("系统参数配置出错");
		} else if (count4 == 0) {
			return R.error("当前会计期间在核算期间表中不存在");
		} else if ("1".equals(sfjz)) {
			return R.error("此会计期间已月结");
		} else if (count5 > 0) {
			return R.error("当前会计期间存在未审核的单位缴交记录");
		} else if (count6 > 0) {
			return R.error("当前会计期间存在未审核的个人缴交记录");
		} else if (count8 > 0) {
			return R.error("当前会计期间存在支取未决算的业务");
		} 
//		else if (!listwftphjc.isEmpty()) {
//			return R.error("未分摊维修资金不平衡");
//		} else if (!listyftphjc.isEmpty()) {
//			return R.error("已分摊维修资金不平衡");
//		} else if (!listgrwxzjphjc.isEmpty()) {
//			return R.error("个人维修资金不平衡");
//		}
		else {
			// 此处月结
//			//先进行辅助核算余额处理
//			wxzjyjdrService.selectfzhsmx(ywpzEntity.getKjqj());
			//-----------------------------------------------------------
			// 1.将核算期间表中sfjz是否月结状态改为1
			wxzjyjdrService.updatehsqj(ywpzEntity);
			// 3.将系统参数中当前会计期间自动修改为下月
			String kjqj = ywpzEntity.getKjqj();
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, 1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			ywpzEntity.setKjqj(datestr);
			wxzjyjdrService.updatextcs(ywpzEntity);
			wxzjyjdrService.inserthhsqj(datestr);
		}
		return R.ok("月结成功，请重新登录");
	}

	// @Login
	@PostMapping("/updateGJFYJ")
	@ApiOperation(value = "归集反月末结转", notes = "", response = R.class)
	public R updateGJFYJ(@RequestBody YwpzEntity ywpzEntity) {
		// 1.判断归集点是否存在
		int count1 = wxzjyjdrService.selectgzd(ywpzEntity.getGzdbm());
		// 2.判断该归集点是否配置了系统参数(此归集点所对应的系统参数是否存在)
		int count2 = wxzjyjdrService.selectxtcs(ywpzEntity.getGzdbm());
		if (count1 == 0) {
			return R.error("归集点不存在");
		} else if (count2 == 0) {
			return R.error("系统参数配置出错");
		} else {
			// 此处反月结
//			//此处先进行辅助核算余额处理
//			wxzjyjdrService.selectfzhsmxfyj(ywpzEntity.getKjqj());
			//-----------------------------------------------------------------
			String kjqj = ywpzEntity.getKjqj();
			// 在核算期间表中删除当前会计期间
			wxzjyjdrService.deletehsqj(kjqj);
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			java.util.Date date = null;
			try {
				date = formatter.parse(kjqj);
			} catch (ParseException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			} // Date格式
			Calendar calBegin = Calendar.getInstance();
			// 使用给定的 Date 设置此 Calendar 的时间
			calBegin.setTime(date);
			calBegin.add(Calendar.MONTH, -1);
			String datestr = formatter.format(calBegin.getTime());// String格式
			ywpzEntity.setKjqj(datestr);
			// 3.将系统参数中当前会计期间自动修改为上月
			wxzjyjdrService.updatextcs(ywpzEntity);
			// 1.将核算期间表中sfjz是否月结状态改为0
			wxzjyjdrService.updatefyjhsqj(ywpzEntity);
		}
		return R.ok("反月结成功，请重新登录");
	}

	// @Login
	@PostMapping("/GJWXZJPHJC")
	@ApiOperation(value = "归集维修资金平衡检查", notes = "", response = R.class)
	public R GJWXZJPHJC(@RequestBody YwpzEntity ywpzEntity) {
		ywpzEntity.setGzdbm("0001");
		// 8.维修资金平衡检查
		if ("1".equals(ywpzEntity.getGjphjc())) {
			// 8.1.未分摊维修资金平衡检查
			List<YwpzEntity> listwftphjc = wxzjyjdrService.selectwftphjc(ywpzEntity);
			if (!listwftphjc.isEmpty()) {
				return R.error("未分摊维修资金不平衡");
			} else {
				return R.ok("未分摊维修资金检查平衡");
			}
		} else if ("2".equals(ywpzEntity.getGjphjc())) {
			// 8.2.已分摊维修资金平衡检查
			List<YwpzEntity> listyftphjc = wxzjyjdrService.selectyftphjc(ywpzEntity);
			if (!listyftphjc.isEmpty()) {
				return R.error("已分摊维修资金不平衡");
			} else {
				return R.ok("已分摊维修资金检查平衡");
			}
		} else if ("3".equals(ywpzEntity.getGjphjc())) {
			// 8.3.个人维修资金平衡检查
			List<YwpzEntity> listgrwxzjphjc = wxzjyjdrService.selectgrwxzjphjc(ywpzEntity);
			if (!listgrwxzjphjc.isEmpty()) {
				return R.error("个人维修资金不平衡");
			} else {
				return R.ok("个人维修资金检查平衡");
			}
		}
		return R.ok();
	}

	// @Login
	@PostMapping("/selectCWSSPH")
	@ApiOperation(value = "财务试算平衡", notes = "", response = HPzEntity.class)
	public R selectCWSSPH(@RequestBody HPzEntity hPzEntity) {

		return R.ok().put("select", wxzjyjdrService.selectCWSSPH(hPzEntity));
	}

	// @Login
	@PostMapping("/GJPLJX")
	@ApiOperation(value = "归集批量计息", notes = "结息按钮", response = R.class)
	public R GJPLJX(@RequestBody YwpzEntity ywpzEntity) {
		// 1.查询所有还未结息的楼幢
		// List<ZhxxEntity> zhlist = wxzjyjdrService.selectzhxx();
		List<ZhxxEntity> zhlist = ywpzEntity.getZhlist();
		// 2.查询xtcs表里配置的定期利率，活期利率。
		XtcsEntity xtcsEntity = wxzjyjdrService.selectxtcs();// dqll,hqll
		// 3.查询会计年度表，判断当前系统时间是否在年度起始日期和年度终止日期之间
		int count = wxzjyjdrService.selectndsj();
		if (count != 1) {
			return R.error("会计年度设置出错");
		}
		// 4.结息前，归集维修资金必须平衡
		// 4.1.未分摊维修资金平衡检查
		List<YwpzEntity> listwftphjc = wxzjyjdrService.selectwftphjc(ywpzEntity);
		if (!listwftphjc.isEmpty()) {
			return R.error("未分摊维修资金不平衡");
		} else {

		}
		// 4.2.已分摊维修资金平衡检查
		List<YwpzEntity> listyftphjc = wxzjyjdrService.selectyftphjc(ywpzEntity);
		if (!listyftphjc.isEmpty()) {
			return R.error("已分摊维修资金不平衡");
		} else {
		}
		// 4.3.个人维修资金平衡检查
		List<YwpzEntity> listgrwxzjphjc = wxzjyjdrService.selectgrwxzjphjc(ywpzEntity);
		if (!listgrwxzjphjc.isEmpty()) {
			return R.error("个人维修资金不平衡");
		} else {

		}
		// 5.查询会计年度表中的年度起始日期和年度终止日期
		YwpzEntity y = wxzjyjdrService.selectkjnd();// beginrq,endrq
		// 6.判断当前归集会计期间是否等于年度终止日期
		if (!ywpzEntity.getKjqj().equals(y.getEndrq().substring(0, 7))) {
			return R.error("当前归集会计期间和年度终止日期不一致，不能操作！");
		}
		int nflag = 1;
		Double nDWLX = 0.0;
		Double nLX = 0.0;
		Double nDQLX = 0.0;
		Double nHQLX = 0.0;
		Double nDQJS = 0.0;
		Double nHQJS = 0.0;
		// 7.遍历所有未进行年度结息的楼幢，逐一进行楼幢结算
		for (ZhxxEntity z : zhlist) {// 传参包括：当前用户名称，当前用户编码，承办网点编码，归集点编码，幢号编码，结息日期(当前操作日期),系统参数表里的定期利率，活期利率
			// 8.定义两个集合，一个定期利率集合，一个活期利率集合
			// List<JieXiEntity> dqlllist = new ArrayList<JieXiEntity>();
			// List<JieXiEntity> hqlllist = new ArrayList<JieXiEntity>();
			// 9.查询每一栋楼幢里所有房屋状态为已售出的所有房屋。
			List<FwxxEntity> fwxxlist = wxzjyjdrService.selectfwxxbydh(z.getDhbm());
			// 10.获取当前归集会计期间的最后一天
			HPzEntity pz = wxzjyjdrService.selectgjlastday(ywpzEntity.getKjqj());// pzrq-当前归集会计期间的最后一天
			DateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM");
			String vrq = pz.getPzrq();
			Date dt = new Date();
			// String pzrq = sdf.format(dt);// 结息日期(当前系统操作日期)
			String pzrq = "2020-06-30";// 测试用
			try {
				if (sdf.parse(vrq).getTime() > sdf.parse(pzrq).getTime()) {// 判断当前归集会计期间最后一天的日期是否大于结息日期
					vrq = pzrq;// 如果大于，则将结息日期即当前系统操作日期赋值给vrq
				}
			} catch (ParseException e1) {
				e1.printStackTrace();
			}
			// 11.调用获取年度日期方法(传参：vrq;返回参数：所在年度，年度开始日期，年度终止日期)
			HashMap<String, String> map = wxzjyjdrService.selectndrq(vrq);
			// 12.判断返回的年度终止时间是否大于此次结息日期或者当前归集会计期间是否不等于返回的年度终止日期
			try {
				if (sdf.parse(map.get("endtime")).getTime() > sdf.parse(pzrq).getTime()
						|| formatter.parse(ywpzEntity.getKjqj()).getTime() != formatter
								.parse(map.get("endtime").substring(0, 7)).getTime()) {
					return R.error("本次结息日期必须是" + map.get("endtime") + "才能结息");
				}
			} catch (ParseException e) {
				e.printStackTrace();
			}
			// 13.查ywpz业务表，获取当前归集会计期间djlx=‘10’结息业务的最大单据编号+1
			String newdjbh = wxzjyjdrService.selectjxmaxbh(ywpzEntity.getKjqj());
			// 因为llb中配置的lltype(利率类型)为1，所以默认lltype传1(两条数据都是同一种ll类型：活期利率)
			List<LlbEntity> lllist = wxzjyjdrService.selectllxx(map);
			System.out.print("aaaaa");
			if (lllist.isEmpty()) {
				return R.error("利率设置不对,操作失败");
			}
			// 14.调用获取利率信息方法(传参：上面返回的年度开始日期，年度终止日期；返回的参数：参数为2的定期利率集合参数，参数为1的活期利率集合参数)
			List<JieXiEntity> listjiexill = wxzjyjdrService.slelectllxx(map, lllist);
			if (listjiexill.isEmpty()) {
				return R.error("停用日期加1必须是下一种利率的启用日期!");
			}
			// 15.在ywpz中记录此次批量计息的记录，djlx=10;
			// 查询该dhbm对应的dwbm
			ZhxxEntity zEntity = wxzjyjdrService.selectdwbydh(z.getDhbm());
			YwpzEntity yo = new YwpzEntity();
			yo.setKjqj(ywpzEntity.getKjqj());
			yo.setDwbm(zEntity.getDwbm());
			yo.setDjbh(newdjbh);
			yo.setCzybm(ywpzEntity.getCzybm());
			yo.setCzyxm(ywpzEntity.getCzyxm());
			wxzjyjdrService.insertywpzjx(yo);
			System.out.print("aaaaa");
			for (FwxxEntity f : fwxxlist) {
				// 调用计算借贷方的方法(参数:fwbm)
				wxzjyjdrService.caljdf(f.getFwbm());
				// 调用年底计息的方法
				// --先冲定期再冲活期，定期部分成活期(传参包括：fwbm,前面返回的年度起始日期，年度终止日期，获取的活期利率集合，房屋的ncye
				// 返回的参数:n_LX-利息,n_DQLX-定期利息,n_HQLX-活期利息,n_DQJS-定期积数,n_HQJS-活期积数)
				HashMap<String, Double> map2 = wxzjyjdrService.calcuratioyearfd(f, map, listjiexill);
				nDWLX = nDWLX + map2.get("nLX");
				// 插入ywpzmx表
				YwpzmxEntity mx = new YwpzmxEntity();
				mx.setDjbh(newdjbh);
				mx.setDhbm(z.getDhbm());
				mx.setFwbm(f.getFwbm());
				mx.setBjje(0.0);
				mx.setLxje(map2.get("nLX").intValue());
				mx.setJdf("0");
				wxzjyjdrService.insertywpzjiexi(mx);
				nflag = nflag + 1;
			}
			if (nflag == 1) {
				wxzjyjdrService.deleteywpzbyid(newdjbh);
			} else {
				YwpzEntity yy = new YwpzEntity();
				yy.setJe(nDWLX);
				yy.setDjbh(newdjbh);
				wxzjyjdrService.updateywpzbyid(yy);
				ZhxxEntity zh = wxzjyjdrService.selectzhxx(z.getDhbm());
				zh.setLjlx(zh.getLjlx() + nDWLX);
				zh.setNdjx("1");
				wxzjyjdrService.updateZhxx(zh);
			}
		}
		return R.ok();
	}

	// @Login
	@GetMapping("/queryByPagePLJX")
	@ApiOperation(value = "批量结息查询页面", notes = "", response = ZhxxEntity.class)
	public R queryByPagePLJX(Integer pageNum, Integer pageSize) {

		return R.ok().put("data", wxzjyjdrService.queryByPagePLJX(pageNum, pageSize));
	}

	// @Login
	@PostMapping("/GJYJLX")
	@ApiOperation(value = "归集预结利息", notes = "结息按钮", response = R.class)
	public R GJYJLX(@RequestBody YwpzEntity ywpzEntity) {
		// 1.查询所有已售出的房屋
		List<FwxxEntity> listfw = wxzjyjdrService.selectfwxx2();
		// 2.删除h_gryjx表中gzdbm=当前归集点编码的数据
		wxzjyjdrService.deletegryjx();
		// 3.查询xtcs表里配置的定期利率，活期利率。
		XtcsEntity xtcsEntity = wxzjyjdrService.selectxtcs();// dqll,hqll
		// 4.查询会计年度表，判断当前系统时间是否在年度起始日期和年度终止日期之间
		int count = wxzjyjdrService.selectndsj();
		if (count != 1) {
			return R.error("会计年度设置出错");
		}
		// 5.结息前，归集维修资金必须平衡
		// 5.1.未分摊维修资金平衡检查
		List<YwpzEntity> listwftphjc = wxzjyjdrService.selectwftphjc(ywpzEntity);
		if (!listwftphjc.isEmpty()) {
			return R.error("未分摊维修资金不平衡");
		} else {

		}
		// 5.2.已分摊维修资金平衡检查
		List<YwpzEntity> listyftphjc = wxzjyjdrService.selectyftphjc(ywpzEntity);
		if (!listyftphjc.isEmpty()) {
			return R.error("已分摊维修资金不平衡");
		} else {
		}
		// 5.3.个人维修资金平衡检查
		List<YwpzEntity> listgrwxzjphjc = wxzjyjdrService.selectgrwxzjphjc(ywpzEntity);
		if (!listgrwxzjphjc.isEmpty()) {
			return R.error("个人维修资金不平衡");
		} else {

		}
		// 6.获取当前系统时间
		String dCurtime = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		dCurtime = sdf.format(dt);
		// 7.调用获取年度日期方法(传参：vrq，gzdbm;返回参数：所在年度，年度开始日期，年度终止日期)
		HashMap<String, String> map = wxzjyjdrService.selectndrq(dCurtime);
		// 8.因为llb中配置的lltype(利率类型)为1，所以默认lltype传1(两条数据都是同一种ll类型：活期利率)
		List<LlbEntity> lllist = wxzjyjdrService.selectllxx(map);
		// 9.调用获取利率信息方法(传参：上面返回的年度开始日期，年度终止日期；返回的参数：参数为2的定期利率集合参数，参数为1的活期利率集合参数)
		List<JieXiEntity> listjiexill = wxzjyjdrService.slelectllxx(map, lllist);
		// 10.遍历返回的房屋信息集合
		for (FwxxEntity f : listfw) {
			// 11.调用计算借贷方的方法(参数:fwbm)
			wxzjyjdrService.caljdf(f.getFwbm());
			// 12.调用年底计息的方法
			// --先冲定期再冲活期，定期部分成活期(传参包括：fwbm,前面返回的年度起始日期，年度终止日期，获取的活期利率集合，房屋的ncye
			// 返回的参数:n_LX-利息,n_DQLX-定期利息,n_HQLX-活期利息,n_DQJS-定期积数,n_HQJS-活期积数)
			HashMap<String, Double> map2 = wxzjyjdrService.calcuratioyearfd(f, map, listjiexill);
			Double nLX = map2.get("nLX");
			Double nDQLX = map2.get("nDQLX");
			Double nHQLX = map2.get("nHQLX");
			Double nDQJS = map2.get("nDQJS");
			Double nHQJS = map2.get("nHQJS");
			HGryjxEntity hg = new HGryjxEntity();
			hg.setGzdbm("0001");
			hg.setFwbm(f.getFwbm());
			hg.setDhbm(f.getDhbm());
			hg.setXm(f.getXm());
			hg.setMphm(f.getMphm());
			hg.setDqjs(nDQJS);
			hg.setHqjs(nHQJS);
			hg.setLx(nLX);
			hg.setDqlx(nDQLX);
			hg.setHqlx(nHQLX);
			hg.setJxrq(dCurtime);
			hg.setNcye(f.getNcye());
			hg.setDqye(f.getDqye());
			// 13.在h_gryjx表中记录此次预结息
			wxzjyjdrService.insertgryjx(hg);
			nHQJS = 0.0;
			nDQJS = 0.0;
			nLX = 0.0;
			nDQLX = 0.0;
			nHQLX = 0.0;
		}
		return R.ok();
	}

	// @Login
	@GetMapping("/queryByPageYJLX")
	@ApiOperation(value = "预结利息查询页面", notes = "", response = HGryjxEntity.class)
	public R queryByPageYJLX(Integer pageNum, Integer pageSize, String xsfs) {

		return R.ok().put("data", wxzjyjdrService.queryByPageYJLX(pageNum, pageSize, xsfs));
	}
	
	// @Login
		@PostMapping("/fzhsyeshuashuju")
		@ApiOperation(value = "辅助核算余额表刷数据脚本", notes = "假设起始日期为2007-11，可以根据此脚本刷到规定的年月", response = R.class)
		public R fzhsyeshuashuju() {
			//注意，暂定的起始日期是2007-11，这以前fzhsye没有数据，数据从规定的起始日期开始录入
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
			java.util.Date dBegin = null;
			try {
				dBegin = sdf.parse("2021-01");
			} catch (ParseException e1) {
				e1.printStackTrace();
			}
			java.util.Date dEnd = null;
			try {
				dEnd = sdf.parse("2021-01");
			} catch (ParseException e) {
				e.printStackTrace();
			}
			List<String> datas = wxzjyjdrService.findDates(dBegin, dEnd);
			for (String kjqj : datas) {
				wxzjyjdrService.selectfzhsmx(kjqj);//此方法为归集月结时，刷当月的业务发生额，期初值，期末值到fzhsye表中
			}
			
			return R.ok();
		}
		
		// @Login
		@PostMapping("/fzhsyeshuashujuZQFT")
		@ApiOperation(value = "辅助核算余额表刷数据脚本", notes = "假设起始日期为2005-01，21,22刷支取分摊的初始值", response = R.class)
		public R fzhsyeshuashujuZQFT() {
			//注意，暂定的起始日期是2007-11，这以前fzhsye没有数据，数据从规定的起始日期开始录入
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
			java.util.Date dBegin = null;
			try {
				dBegin = sdf.parse("2005-01");
			} catch (ParseException e1) {
				e1.printStackTrace();
			}
			java.util.Date dEnd = null;
			try {
				dEnd = sdf.parse("2020-08");
			} catch (ParseException e) {
				e.printStackTrace();
			}
			List<String> datas = wxzjyjdrService.findDates(dBegin, dEnd);
			for (String kjqj : datas) {
				wxzjyjdrService.selectfZQFT(kjqj);//此方法为归集月结时，刷当月的业务发生额，期初值，期末值到fzhsye表中
			}
			
			return R.ok();
		}

}
