package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.Cxtj_FhmxzDao;
import io.renren.modules.app.entity.Cxtj_CxtjCfzhEntity;
import io.renren.modules.app.entity.Cxtj_CxtjCqrbgEntity;
import io.renren.modules.app.entity.Cxtj_CxtjCsbEntity;
import io.renren.modules.app.entity.Cxtj_CxtjFwbgEntity;
import io.renren.modules.app.entity.Cxtj_CxtjFwwxqkEntity;
import io.renren.modules.app.entity.Cxtj_CxtjGgsyfpEntity;
import io.renren.modules.app.entity.Cxtj_CxtjJkcxEntity;
import io.renren.modules.app.entity.Cxtj_CxtjTyEntity;
import io.renren.modules.app.entity.Cxtj_CxtjZqcxEntity;
import io.renren.modules.app.entity.Cxtj_CxtjZzcxEntity;
import io.renren.modules.app.entity.Cxtj_FhmxzEntity;
import io.renren.modules.app.entity.Cxtj_GrjcHstjEntity;
import io.renren.modules.app.entity.Cxtj_GrjcJcybEntity;
import io.renren.modules.app.entity.Cxtj_GrjcqkEntity;
import io.renren.modules.app.service.Cxtj_FhmxzService;
import io.renren.modules.app.utils.Pager;

import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Service("cxtj_FhmxzService")
public class Cxtj_FhmxzServiceImpl extends ServiceImpl<Cxtj_FhmxzDao, Cxtj_FhmxzEntity> implements Cxtj_FhmxzService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param xmEntity
	 * @return
	 */
	@Override
	public PageInfo<Cxtj_FhmxzEntity> queryByPage(Integer pageNum, Integer pageSize,
			Cxtj_FhmxzEntity cxtj_FhmxzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_FhmxzEntity> xmEntitys = baseMapper.queryByPage(cxtj_FhmxzEntity);
		PageInfo<Cxtj_FhmxzEntity> pageInfo = new PageInfo<Cxtj_FhmxzEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_FhmxzEntity> queryKfxm(Cxtj_FhmxzEntity cxtj_FhmxzEntity) {
		List<Cxtj_FhmxzEntity> xmEntitys = baseMapper.queryKfxm(cxtj_FhmxzEntity);
		PageInfo<Cxtj_FhmxzEntity> pageInfo = new PageInfo<Cxtj_FhmxzEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_FhmxzEntity> queryLymc(Cxtj_FhmxzEntity cxtj_FhmxzEntity) {
		List<Cxtj_FhmxzEntity> xmEntitys = baseMapper.queryLymc(cxtj_FhmxzEntity);
		PageInfo<Cxtj_FhmxzEntity> pageInfo = new PageInfo<Cxtj_FhmxzEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_FhmxzEntity> queryFwxx(Cxtj_FhmxzEntity cxtj_FhmxzEntity) {
		List<Cxtj_FhmxzEntity> xmEntitys = baseMapper.queryFwxx(cxtj_FhmxzEntity);
		PageInfo<Cxtj_FhmxzEntity> pageInfo = new PageInfo<Cxtj_FhmxzEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_GrjcqkEntity> queryGrjcqkPage(Integer pageNum, Integer pageSize,
			Cxtj_GrjcqkEntity cxtj_GrjcqkEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_GrjcqkEntity> xmEntitys = baseMapper.queryGrjcqkPage(cxtj_GrjcqkEntity);
		PageInfo<Cxtj_GrjcqkEntity> pageInfo = new PageInfo<Cxtj_GrjcqkEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_GrjcHstjEntity> queryGrjcHstjPage(Integer pageNum, Integer pageSize,
			Cxtj_GrjcHstjEntity cxtj_GrjcHstjEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_GrjcHstjEntity> xmEntitys = new ArrayList<Cxtj_GrjcHstjEntity>();
		// 根据类型来判断
		if ("1".equals(cxtj_GrjcHstjEntity.getTjlx())) {
			xmEntitys = baseMapper.queryGrjcHstjPageOne2(cxtj_GrjcHstjEntity);
			for(Cxtj_GrjcHstjEntity c:xmEntitys){
				c.setKssj(cxtj_GrjcHstjEntity.getKssj());
				c.setJssj(cxtj_GrjcHstjEntity.getJssj());
				Cxtj_GrjcHstjEntity c1=baseMapper.queryGrjcHstjPageOneDWYJ(c);
				Cxtj_GrjcHstjEntity c2=baseMapper.queryGrjcHstjPageOneDWYJQC(c);
				c.setDwyj(c1.getDwyj());
				Double srhj=Double.parseDouble(c.getSrhj())+Double.parseDouble(c1.getDwyj());
				int card = new Double(srhj).intValue();
				String a = Integer.toString(card);
				c.setSrhj(a);
				if(c.getQcye()==null){
					c.setQcye("0");
				}
				Double qcye=Double.parseDouble(c.getQcye())+Double.parseDouble(c2.getDwyj());
				int card2 = new Double(qcye).intValue();
				String a2 = Integer.toString(card2);
				c.setQcye(a2);
				//统计每个项目下已缴户数：
				Cxtj_GrjcHstjEntity c3=baseMapper.queryCxtjhs(c);
				c.setHs(c3.getHs());
			}
//			xmEntitys = baseMapper.queryGrjcHstjPageOne(cxtj_GrjcHstjEntity);
		} else if ("2".equals(cxtj_GrjcHstjEntity.getTjlx())) {
			xmEntitys = baseMapper.queryGrjcHstjPageTwo2(cxtj_GrjcHstjEntity);
			for(Cxtj_GrjcHstjEntity c:xmEntitys){
				c.setKssj(cxtj_GrjcHstjEntity.getKssj());
				c.setJssj(cxtj_GrjcHstjEntity.getJssj());
				Cxtj_GrjcHstjEntity c1=baseMapper.queryGrjcHstjPageOneDWYJ2(c);
				Cxtj_GrjcHstjEntity c2=baseMapper.queryGrjcHstjPageOneDWYJQC2(c);
				c.setDwyj(c1.getDwyj());
				Double srhj=Double.parseDouble(c.getSrhj())+Double.parseDouble(c1.getDwyj());
				int card = new Double(srhj).intValue();
				String a = Integer.toString(card);
				c.setSrhj(a);
				if(c.getQcye()==null){
					c.setQcye("0");
				}
				Double qcye=Double.parseDouble(c.getQcye())+Double.parseDouble(c2.getDwyj());
				int card2 = new Double(qcye).intValue();
				String a2 = Integer.toString(card2);
				c.setQcye(a2);
				//统计每个楼栋下已缴户数：
				Cxtj_GrjcHstjEntity c3=baseMapper.queryCxtjhs2(c);
				c.setHs(c3.getHs());
			}
//			xmEntitys = baseMapper.queryGrjcHstjPageTwo(cxtj_GrjcHstjEntity);
		} else if ("3".equals(cxtj_GrjcHstjEntity.getTjlx())) {
			xmEntitys = baseMapper.queryGrjcHstjPageSan(cxtj_GrjcHstjEntity);
		}
		PageInfo<Cxtj_GrjcHstjEntity> pageInfo = new PageInfo<Cxtj_GrjcHstjEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public Map<String, Object> queryGrjcJcybPage(Integer pageNum, Integer pageSize,Cxtj_GrjcJcybEntity cxtj_GrjcJcybEntity) {
		List<Cxtj_GrjcJcybEntity> list = baseMapper.queryGrjcJcybPage(cxtj_GrjcJcybEntity);
		Map<String, Object> map = new HashMap<String, Object>();
		// 本月数合计
		Double byshj = 0.0;
		// 本月累计数合计
		Double byljshj = 0.0;
		List<Cxtj_GrjcJcybEntity> list1 = new ArrayList<Cxtj_GrjcJcybEntity>();
		for (int i = 0; i < list.size(); i++) {
			if (i + 1 == list.size()) {
				break;
			} else {
				if (list.get(i).getXqbm().equals(list.get(i + 1).getXqbm())) {
					list1.add(list.get(i));
					list1.add(list.get(i + 1));

					Cxtj_GrjcJcybEntity entity = new Cxtj_GrjcJcybEntity();
					// 本月数合计
					byshj = Double.parseDouble(list.get(i).getByje().toString())
							+ Double.parseDouble(list.get(i + 1).getByje().toString());
					// 本月累计数合计
					byljshj = Double.parseDouble(list.get(i).getLjje().toString())
							+ Double.parseDouble(list.get(i + 1).getLjje().toString());
					entity.setLy("合计");
					entity.setXqbm(list.get(i).getXqbm());
					entity.setXqmc(list.get(i).getXqmc());
					entity.setByje(byshj.toString());
					entity.setLjje(byljshj.toString());
					list1.add(entity);

				}

			}
		}
		int total = list1.size();
		Pager pager = new Pager(pageNum, pageSize, list1);
		List<Cxtj_GrjcJcybEntity> list3 = pager.getPagerList();
		map.put("total", total);
		map.put("list", list3);
		
		
		return map;
	}

	@Override
	public PageInfo<Cxtj_CxtjZzcxEntity> queryCxtjZzcxPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjZzcxEntity cxtj_CxtjZzcxEntity) {
		// PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjZzcxEntity> xmEntitys = baseMapper.queryCxtjZzcxPage(cxtj_CxtjZzcxEntity);
		List<Cxtj_CxtjZzcxEntity> returnlist = new ArrayList<Cxtj_CxtjZzcxEntity>();
		double a = 0;
		for (int i = 0; i < xmEntitys.size(); i++) {
			// 初期余额
			double qc = 0.0;
			if (i != 0) {
				// 上个月的期末余额为该月的初期余额
				qc = xmEntitys.get(i - 1).getQm();
			}
			xmEntitys.get(i).setQc(qc);
			// 期末余额 = 初期余额 + 本月缴交 - 本月支取
			double qm = new BigDecimal(qc + xmEntitys.get(i).getJjje() - xmEntitys.get(i).getZqje())
					.setScale(2, RoundingMode.UP).doubleValue();
			xmEntitys.get(i).setQm(qm);
		}
		// 根据时间筛选
		if (cxtj_CxtjZzcxEntity.getKssj() != null && cxtj_CxtjZzcxEntity.getJssj() != null) {
			for (Cxtj_CxtjZzcxEntity pd : xmEntitys) {
				SimpleDateFormat format = new SimpleDateFormat("yyyy-MM");
				try {
					long kssjqd = format.parse(cxtj_CxtjZzcxEntity.getKssj()).getTime();
					long jssjqd = format.parse(cxtj_CxtjZzcxEntity.getJssj()).getTime();
					long jssj = format.parse(pd.getYf()).getTime();
					if (jssj >= kssjqd && jssj <= jssjqd) {
						returnlist.add(pd);
					}
				} catch (ParseException e) {
					e.printStackTrace();
				}
			}

		} else {
			returnlist = xmEntitys;
		}
		PageInfo<Cxtj_CxtjZzcxEntity> pageInfo = new PageInfo<Cxtj_CxtjZzcxEntity>(returnlist);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjZqcxEntity> queryCxtjZqcxPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjZqcxEntity cxtj_CxtjZqcxEntity) {
		Double je = 0.0;
		List<Cxtj_CxtjZqcxEntity> xmEntitys2 = baseMapper.queryCxtjZqcxPage(cxtj_CxtjZqcxEntity);
		Cxtj_CxtjZqcxEntity entity = new Cxtj_CxtjZqcxEntity();
		for (int i = 0; i < xmEntitys2.size(); i++) {
			double je2 = Double.parseDouble(xmEntitys2.get(i).getJe());
			je = je + je2;
		}
		
		
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjZqcxEntity> xmEntitys = baseMapper.queryCxtjZqcxPage(cxtj_CxtjZqcxEntity);
		entity.setIshj("1");
		entity.setJe(je.toString());
		xmEntitys.add(entity);
		PageInfo<Cxtj_CxtjZqcxEntity> pageInfo = new PageInfo<Cxtj_CxtjZqcxEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjJkcxEntity> queryCxtjJkcxPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjJkcxEntity cxtj_CxtjJkcxEntity) {
		double je = 0.0;
		List<Cxtj_CxtjJkcxEntity> xmEntitys2 = baseMapper.queryCxtjJkcxPage(cxtj_CxtjJkcxEntity);
		Cxtj_CxtjJkcxEntity entity = new Cxtj_CxtjJkcxEntity();
		for (int i = 0; i < xmEntitys2.size(); i++) {
			double je2 = Double.parseDouble(xmEntitys2.get(i).getJe());
			je = je + je2;
		}

		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjJkcxEntity> xmEntitys = baseMapper.queryCxtjJkcxPage(cxtj_CxtjJkcxEntity);
		entity.setZje(je);
		entity.setIshj("1");
		xmEntitys.add(entity);
		PageInfo<Cxtj_CxtjJkcxEntity> pageInfo = new PageInfo<Cxtj_CxtjJkcxEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjTyEntity> queryTyXqPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		List<Cxtj_CxtjTyEntity> xmEntitys = baseMapper.queryTyXqPage(cxtj_CxtjTyEntity);
		PageInfo<Cxtj_CxtjTyEntity> pageInfo = new PageInfo<Cxtj_CxtjTyEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjTyEntity> queryTyXmPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		List<Cxtj_CxtjTyEntity> xmEntitys = baseMapper.queryTyXmPage(cxtj_CxtjTyEntity);
		PageInfo<Cxtj_CxtjTyEntity> pageInfo = new PageInfo<Cxtj_CxtjTyEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjTyEntity> queryTyLyPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		List<Cxtj_CxtjTyEntity> xmEntitys = baseMapper.queryTyLyPage(cxtj_CxtjTyEntity);
		PageInfo<Cxtj_CxtjTyEntity> pageInfo = new PageInfo<Cxtj_CxtjTyEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjTyEntity> queryTySyxmPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		List<Cxtj_CxtjTyEntity> xmEntitys = baseMapper.queryTySyxmPage(cxtj_CxtjTyEntity);
		PageInfo<Cxtj_CxtjTyEntity> pageInfo = new PageInfo<Cxtj_CxtjTyEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjTyEntity> queryTyHyxxPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjTyEntity cxtj_CxtjTyEntity) {
		List<Cxtj_CxtjTyEntity> xmEntitys = baseMapper.queryTyHyxxPage(cxtj_CxtjTyEntity);
		PageInfo<Cxtj_CxtjTyEntity> pageInfo = new PageInfo<Cxtj_CxtjTyEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjFwwxqkEntity> queryCxtjFwwxqkPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjFwwxqkEntity cxtj_CxtjFwwxqkEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjFwwxqkEntity> xmEntitys = baseMapper.queryCxtjFwwxqkPage2(cxtj_CxtjFwwxqkEntity);
		PageInfo<Cxtj_CxtjFwwxqkEntity> pageInfo = new PageInfo<Cxtj_CxtjFwwxqkEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjGgsyfpEntity> queryCxtjGgsyfpPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjGgsyfpEntity cxtj_CxtjGgsyfpEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjGgsyfpEntity> xmEntitys = baseMapper.queryCxtjGgsyfpPage(cxtj_CxtjGgsyfpEntity);
		PageInfo<Cxtj_CxtjGgsyfpEntity> pageInfo = new PageInfo<Cxtj_CxtjGgsyfpEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjCqrbgEntity> queryCxtjCqrbgPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjCqrbgEntity cxtj_CxtjCqrbgEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjCqrbgEntity> xmEntitys = baseMapper.queryCxtjCqrbgPage(cxtj_CxtjCqrbgEntity);
		PageInfo<Cxtj_CxtjCqrbgEntity> pageInfo = new PageInfo<Cxtj_CxtjCqrbgEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjCsbEntity> queryCxtjCsbPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjCsbEntity cxtj_CxtjCsbEntity) {
		//楼栋面积
		Double zmj = 0.0;
		//已缴金额
		Double yjyjje = 0.0;
		//应缴金额
		Double yjje = 0.0;
		
		List<Cxtj_CxtjCsbEntity> xmEntitys2 = baseMapper.queryCxtjCsbPage(cxtj_CxtjCsbEntity);
		Cxtj_CxtjCsbEntity entity = new Cxtj_CxtjCsbEntity();
		for (int i = 0; i < xmEntitys2.size(); i++) {
			Double zmj2 = Double.parseDouble(xmEntitys2.get(i).getZmj());
			zmj = zmj + zmj2;
			
			Double yjyjje2 = Double.parseDouble(xmEntitys2.get(i).getYjyjje());
			yjyjje = yjyjje+yjyjje2;
			
			Double yjje2 = Double.parseDouble(xmEntitys2.get(i).getYjje());
			yjje = yjje+yjje2;
		}
		
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjCsbEntity> xmEntitys = baseMapper.queryCxtjCsbPage(cxtj_CxtjCsbEntity);
		entity.setIshj("1");
		entity.setZmj(zmj.toString());
		entity.setYjyjje(yjyjje.toString());
		entity.setYjje(yjje.toString());
		xmEntitys.add(entity);
		PageInfo<Cxtj_CxtjCsbEntity> pageInfo = new PageInfo<Cxtj_CxtjCsbEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjCfzhEntity> queryCxtjCfzhPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjCfzhEntity cxtj_CxtjCfzhEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjCfzhEntity> xmEntitys = baseMapper.queryCxtjFwwxqkPage(cxtj_CxtjCfzhEntity);
		PageInfo<Cxtj_CxtjCfzhEntity> pageInfo = new PageInfo<Cxtj_CxtjCfzhEntity>(xmEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<Cxtj_CxtjFwbgEntity> queryCxtjFwbgPage(Integer pageNum, Integer pageSize,
			Cxtj_CxtjFwbgEntity cxtj_CxtjFwbgEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<Cxtj_CxtjFwbgEntity> xmEntitys = baseMapper.queryCxtjFwbgPage(cxtj_CxtjFwbgEntity);
		PageInfo<Cxtj_CxtjFwbgEntity> pageInfo = new PageInfo<Cxtj_CxtjFwbgEntity>(xmEntitys);
		return pageInfo;
	}

}