package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.dao.GrwxzjfhDao;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XzdyFwxxSdEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.GrwxzjfhService;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;

@Service("grwxzjfhService")
public class GrwxzjfhServiceImpl extends ServiceImpl<GrwxzjfhDao, YwpzEntity> implements GrwxzjfhService {

	@Override
	public PageInfo<YwpzEntity> queryByPage(Integer pageNum, Integer pageSize,
			YwpzEntity ywpzEntity) {
		List<YwpzEntity> ywHPzEntities111 = baseMapper.queryByPage(ywpzEntity);
		Double sumje=0.0;
		for(YwpzEntity y:ywHPzEntities111){
			sumje=sumje+y.getJe();
		}
		sumje = (double) Math.round(sumje * 100) / 100;
		PageHelper.startPage(pageNum, pageSize);
//		ywpzEntity.setBeginrq(ywpzEntity.getBeginrq()+" 00:00:00");
//		ywpzEntity.setEndrq(ywpzEntity.getEndrq()+" 00:00:00");//查老系统数据用到的
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);
		if(!ywpzEntitys.isEmpty()){
			ywpzEntitys.get(0).setJezh(sumje);
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	// 查看按钮
	@Override
	public XzdyFwxxSdEntity selectgrwxFh(String fwbm) {

		return baseMapper.selectgrwxfh(fwbm);
	}

	// 单个或者批量复核
	@Override
	public void updateFh(List<DhbmyjEntity> dhyjs) {
		for (DhbmyjEntity d : dhyjs) {
			// 通过fwbm判断该条记录的审核状态
			String shzt = baseMapper.selectfwzt(d.getDjbh());
			if ("1".equals(shzt)) {
				// 已审核

			} else if ("0".equals(shzt)) {
				// 未审核
				String temp_str="";   
			    Date dt = new Date();   
			    //最后的aa表示“上午”或“下午”    HH表示24小时制    如果换成hh表示12小时制   
			    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");   
			    temp_str=sdf.format(dt); 
//			    d.setShrq(temp_str);
			    String djrq=baseMapper.selectdjrqbydjbh(d.getDjbh());
			    d.setShrq(djrq);
				baseMapper.updatefh(d);
				//1.根据单据编号查询ywpzmx表找到对应的fwbm，
				YwpzEntity y=baseMapper.selectywpzmx(d.getDjbh());
				//2.根据房屋信息将此次复核该房屋的缴款金额存于fwxx表中该fwbm所对应的grje和dqye字段中。
				FwxxEntity f=baseMapper.selectfwxx(y.getFwbm());
				f.setGrje(f.getGrje()+y.getBjje());
				f.setDqye(f.getDqye()+y.getBjje());
				baseMapper.updatefwje(f);
				//3.根据该房屋预交明细，在zhxx表中gryjje记录个人缴款金额。
				ZhxxEntity z=baseMapper.selectzhxx(y.getDhbm());
				z.setGryjje(z.getGryjje()+y.getBjje());
				z.setDqye(z.getDqye()+y.getBjje());
				baseMapper.updatezhxx(z);
			}
			
			//-----------------
			YwpzEntity y0=baseMapper.selectfzhsdj(d.getDjbh());
			//将该单据记录到辅助核算明细表中。
			baseMapper.insertfzhsmx(y0);
		}

	}
	
	// 单个或者批量取消复核
	@Override
	public void updateQxfh(List<DhbmyjEntity> dhyjs) {
		for (DhbmyjEntity d : dhyjs) {
			// 通过fwbm判断该条记录的审核状态
			String fhzt = baseMapper.selectfwzt(d.getDjbh());
			if ("0".equals(fhzt)) {
				// 未审核

			} else if ("1".equals(fhzt)) {
				// 已审核，取消审核
				baseMapper.updateqxfh(d.getDjbh());
				//1.根据单据编号查询ywpzmx表找到对应的fwbm，
				YwpzEntity y=baseMapper.selectywpzmx(d.getDjbh());
				//2.根据房屋信息将此次取消复核该房屋的缴款金额fwxx表中该fwbm所对应的grje和dqye字段中相应减少。
				FwxxEntity f=baseMapper.selectfwxx(y.getFwbm());
				f.setGrje(f.getGrje()-y.getBjje());
				f.setDqye(f.getDqye()-y.getBjje());
				baseMapper.updatefwjeqx(f);
				//3.根据该房屋预交明细，在zhxx表中gryjje回退个人缴款金额。
				ZhxxEntity z=baseMapper.selectzhxx(y.getDhbm());
				z.setGryjje(z.getGryjje()-y.getBjje());
				z.setDqye(z.getDqye()-y.getBjje());
				baseMapper.updatezhxx(z);
			}
			//当个人预交取消审核时，要将该单据从辅助核算明细表中删除
			YwpzEntity y0=baseMapper.selectfzhsdj(d.getDjbh());
			if(isObjectNotEmpty(y0)==true){
				baseMapper.deletefzhsdj(d.getDjbh());
			}
			
		}

	}
	
	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	// 小区下拉框查询
	@Override
	public List<XlkEntity> selectXqxlk() {

		return baseMapper.selectxqxlk();
	}

	// 下拉框联动(根据小区匹配下拉框相对应得项目)
	@Override
	public List<XlkEntity> selectdjld(Map<String, String> map) {
		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			list = baseMapper.selectxqxlk();
		} else if ("xqbm".equals(map.get("XQBM"))) {
			list = baseMapper.selectxlld(map.get("xqbmz"));
		}
		return list;
	}
	
	public List<String> findDates(java.util.Date dBegin, java.util.Date dEnd) {
		List<String> lDate = new ArrayList<String>();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
		lDate.add(sd.format(dBegin));
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(dBegin);
		Calendar calEnd = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calEnd.setTime(dEnd);
		// 测试此日期是否在指定日期之后
		while (dEnd.after(calBegin.getTime())) {
			// 根据日历的规则，为给定的日历字段添加或减去指定的时间量
			calBegin.add(Calendar.MONTH, 1);
			lDate.add(sd.format(calBegin.getTime()));
		}
		return lDate;
	}

}