package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.GzdxxDao;
import io.renren.modules.app.entity.GzdxxEntity;
import io.renren.modules.app.service.GzdxxService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("gzdxxService")
public class GzdxxServiceImpl extends ServiceImpl<GzdxxDao, GzdxxEntity> implements GzdxxService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param gzdxxEntity
     * @return
     */
    @Override
    public PageInfo<GzdxxEntity> queryByPage(Integer pageNum, Integer pageSize, GzdxxEntity gzdxxEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<GzdxxEntity> gzdxxEntitys = baseMapper.queryByPage(gzdxxEntity);
        PageInfo<GzdxxEntity> pageInfo = new PageInfo<GzdxxEntity>(gzdxxEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}