package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.RyDao;
import io.renren.modules.app.entity.RyEntity;
import io.renren.modules.app.service.RyService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("ryService")
public class RyServiceImpl extends ServiceImpl<RyDao, RyEntity> implements RyService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param ryEntity
     * @return
     */
    @Override
    public PageInfo<RyEntity> queryByPage(Integer pageNum, Integer pageSize, RyEntity ryEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<RyEntity> ryEntitys = baseMapper.queryByPage(ryEntity);
        PageInfo<RyEntity> pageInfo = new PageInfo<RyEntity>(ryEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}