package io.renren.modules.app.service.impl;

import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.WxzjfpDao;
import io.renren.modules.app.entity.DhbmyjEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.SfdwEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.WxzjfpService;
import org.springframework.stereotype.Service;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Service("wxzjfpService")
public class WxzjfpServiceImpl extends ServiceImpl<WxzjfpDao, ZhxxEntity> implements WxzjfpService {

	// 根据开发单位和开发项目的编码列出对应的幢号信息
	@Override
	public PageInfo<ZhxxEntity> queryByPagelb(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<ZhxxEntity> list = baseMapper.queryByPagelb(zhxxEntity);
		PageInfo<ZhxxEntity> pageInfo = new PageInfo<ZhxxEntity>(list);
		return pageInfo;
	}

	// 保存
	@Override
	public void updateByDhbm(YwpzEntity ywpzEntity) {
		//获取单据编号
		String temp_str="";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		
		String temp_str1="";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh=baseMapper.queryByCount(ywpzEntity.getDjrq());
		String newdjbh="";
		if("".equals(maxdjbh)||maxdjbh==null){
		       newdjbh="02"+temp_str1+"0001";
		}else if(!"".equals(maxdjbh)&&maxdjbh!=null){
		       String aa = Integer.parseInt(maxdjbh)+1+"";
		       DecimalFormat df=new DecimalFormat("0000");    
		       String result = df.format(Integer.parseInt(aa));
		       newdjbh="02"+temp_str1+result;
		}
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("02");
		Double sum = 0.0;
		for (int i = 0; i < ywpzEntity.getListdhandsj().size(); i++) {
			sum = sum + ywpzEntity.getListdhandsj().get(i).getYjyjje();
			YwpzEntity y2 = new YwpzEntity();
			y2.setJe(ywpzEntity.getListdhandsj().get(i).getYjyjje());
			y2.setDhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
			String uuid2 = UUID.randomUUID().toString().replaceAll("-", "");
			y2.setDjbh(newdjbh);
			y2.setYjmxbm(uuid2);
			y2.setJkfx("2");
			y2.setDjrq(ywpzEntity.getDjrq());
			baseMapper.insertyjmx(y2);
			baseMapper.updatefpje(y2);
			//---将单位分配到该楼幢的dwyjje存于dqye字段上
			ZhxxEntity z=baseMapper.selectdqye(ywpzEntity.getListdhandsj().get(i).getDhbm());
			z.setDqye(z.getDqye()+ywpzEntity.getListdhandsj().get(i).getYjyjje());
			baseMapper.updatezhxxdqye(z);

			//----------------------------------------------------------------------------
			// 单位分配的楼幢金额，还需按面积比例或者按戶平均分配到每一户房屋里去。
			// 1.根据楼幢查出该楼幢下所有房屋信息
			List<FwxxEntity> fs = baseMapper.selectfwxxbydhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
			Double sum2 = 0.0;
			for (int j = 0; j < fs.size(); j++) {
			// 计算该楼幢下所有房屋面积的总和
			Double mj = fs.get(j).getMj();
				sum2 = sum2 + mj;
			}
			if("0".equals(ywpzEntity.getFpfs())){//按面积比例分配
				for (int k = 0; k < fs.size(); k++) {
					YwpzmxEntity ym = new YwpzmxEntity();
					ym.setDjbh(newdjbh);
					ym.setDhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
					ym.setFwbm(fs.get(k).getFwbm());
					Double dwje = fs.get(k).getMj() / sum2 * ywpzEntity.getListdhandsj().get(i).getYjyjje();
					ym.setBjje(dwje);
					ym.setLxje(0);
					ym.setJe(dwje);
					ym.setJdf("0");
					// 按面积比例分配的楼幢金额记录在ywpzmx表中，记录每一个房屋单位分配的金额
					baseMapper.insertywpzmx(ym);
					// 将每个房屋分配的金额存于fwxx的dwje字段中。
					FwxxEntity fwxxEntity = new FwxxEntity();
					fwxxEntity.setFwbm(fs.get(k).getFwbm());
					fwxxEntity.setDwje(dwje);
					baseMapper.updatefwxxdwje(fwxxEntity);
					//----单位分配到户的dwje要记录在dqye中
					FwxxEntity ff=baseMapper.selectfwxxdqye(fs.get(k).getFwbm());
					ff.setDqye(ff.getDqye()+dwje);
					baseMapper.updatefwxxdqye(ff);
					//---
				}
			}else{
				for (int k = 0; k < fs.size(); k++) {
					YwpzmxEntity ym = new YwpzmxEntity();
					ym.setDjbh(newdjbh);
					ym.setDhbm(ywpzEntity.getListdhandsj().get(i).getDhbm());
					ym.setFwbm(fs.get(k).getFwbm());
					Double dwje = ywpzEntity.getListdhandsj().get(i).getYjyjje()/fs.size();
					ym.setBjje(dwje);
					ym.setLxje(0);
					ym.setJe(dwje);
					ym.setJdf("0");
					// 按面积比例分配的楼幢金额记录在ywpzmx表中，记录每一个房屋单位分配的金额
					baseMapper.insertywpzmx(ym);
					// 将每个房屋分配的金额存于fwxx的dwje字段中。
					FwxxEntity fwxxEntity = new FwxxEntity();
					fwxxEntity.setFwbm(fs.get(k).getFwbm());
					fwxxEntity.setDwje(dwje);
					baseMapper.updatefwxxdwje(fwxxEntity);
					//----单位分配到户的dwje要记录在dqye中
					FwxxEntity ff=baseMapper.selectfwxxdqye(fs.get(k).getFwbm());
					ff.setDqye(ff.getDqye()+dwje);
					baseMapper.updatefwxxdqye(ff);
					//---
				}
			}
			//--------------------------------------------------------
		}
		ywpzEntity.setJe(sum);
	    ywpzEntity.setShrq(temp_str);
		baseMapper.insertfp(ywpzEntity);
		//分配完，需将所属sfwd的zckje（未分配金额）-此次分配的金额。
		SfdwEntity sfdwEntity=baseMapper.selectdwxx(ywpzEntity.getDwbm());
		sfdwEntity.setZckje(sfdwEntity.getZckje()-sum);
		baseMapper.updatedwzckje(sfdwEntity);
	}

	// 维修资金分配查询
	@Override
	public PageInfo<YwpzEntity> queryByPage(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPage(ywpzEntity);
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public List<XlkEntity> selectxlk(Map<String, String> map) {

		List<XlkEntity> list = new ArrayList<XlkEntity>();
		if (map.isEmpty()) {
			// 查询所有单位
			list = baseMapper.selectdw();
		} else if ("xqbm2".equals(map.get("XQBM2"))) {
			// 查询所有小区
			list = baseMapper.selectxq();
		} else if ("xqbm".equals(map.get("XQBM"))) {
			// 通过小区查项目
			list = baseMapper.selectxmbyxq(map.get("dwbmz"));
		} else if ("dwbm".equals(map.get("DWBM"))) {
			// 通过单位查项目
			list = baseMapper.selectxmbydw(map.get("dwbmz"));
		} else if ("xmbm".equals(map.get("XMBM"))) {
			// 通过项目查楼幢
			list = baseMapper.selectlz(map.get("xmbmz"));
		}
		return list;
	}

	@Override
	public void deletefp(Map<String, String> map) {
		//删除的时候需回退sfdw中zckje分配的金额。
		YwpzEntity yw=baseMapper.selectywpz(map.get("djbh"));
		SfdwEntity sfdwEntity=baseMapper.selectdwxx(yw.getDwbm());
		sfdwEntity.setZckje(sfdwEntity.getZckje()+yw.getJe());
		baseMapper.updatedwzckje(sfdwEntity);
		// 1.根据单据删除ywpz中的此条分配单据
		baseMapper.deletefpywpz(map.get("djbh"));
		// 2.通过改单据编号查询单据相同的yjmx数据
		List<YwpzEntity> yjmxs = baseMapper.selectyjmxd(map.get("djbh"));
		// 3.遍历每个yjmx的幢号信息
		for (YwpzEntity y : yjmxs) {
			//取消分配需回退楼幢的已交金额dwze的值
			ZhxxEntity ya=new ZhxxEntity();
			ya.setDhbm(y.getDhbm());
			ya.setDwyjje(y.getJe());
			baseMapper.updatezhxxdwze(ya);
			//--------------------------
			baseMapper.updatezhxx(y.getDhbm());
			ZhxxEntity z=baseMapper.selectdqye(y.getDhbm());
			z.setDqye(z.getDqye()-y.getJe());
			baseMapper.updatezhxxdqye(z);
		}
		// 5.根据单据编号删除yjmx中该单据编号的所有分配的记录。
		baseMapper.deletedj(map.get("djbh"));
		// 6.根据dhbm查询所分配的所有房屋信息，并清空分配的金额。
		for (int i = 0; i < yjmxs.size(); i++) {
			List<FwxxEntity> fs = baseMapper.selectfwxxbydhbm(yjmxs.get(i).getDhbm());
			for (int j = 0; j < fs.size(); j++) {
				//---
				FwxxEntity f=baseMapper.selectfwxxdqye(fs.get(j).getFwbm());
				f.setDqye(f.getDqye()-f.getDwje());
				baseMapper.updatefwxxdqye(f);
				//-----
				fs.get(j).setDwje(0.0);
				baseMapper.updatefwxxdwje(fs.get(j));
				
			}
		}
		// 7.根据单据编号删除ywpzmx表中分配房屋dwje的记录。
		baseMapper.deleteywpzmx(map.get("djbh"));

	}

	@Override
	public YwpzEntity selectdj(Map<String, String> map) {

		return baseMapper.selectdj(map);
	}

	@Override
	public List<DhbmyjEntity> selectdjlz(Map<String, String> map) {

		return baseMapper.selectyjmx(map);
	}

	@Override
	public int selectsfyfw(String id) {
		
		return baseMapper.selectsfyfw(id);
	}

}