package io.renren.modules.app.controller;


import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.service.HKmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;


/**
 * 科目
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-06-11 11:09:45
 */
@RestController
@RequestMapping("app/hkm")
@Api(tags = "科目模块")
public class HKmController {

    @Autowired
    private HKmService hKmService;


    @Login
    @GetMapping("queryByPage")
    @ApiOperation(value = "一级列表", notes = "点击科目管理，搜索下级菜单", response = HKmEntity.class)
    public R queryByPage(Integer pageNum, Integer pageSize, HKmEntity hKmEntity) {

        return R.ok().put("data", hKmService.queryByPage(pageNum, pageSize, hKmEntity));
    }
    
    @Login
    @PostMapping("/selectejcd")
    @ApiOperation(value = "二级菜单数据", notes = "在此补充接口详细注释...", response = HKmEntity.class)
    public R selectejcd(@RequestBody HKmEntity hKmEntity) {
            
        return R.ok().put("data", hKmService.selectejcd(hKmEntity));
    }
    
    @Login
    @PostMapping("/selectsjcd")
    @ApiOperation(value = "三级级菜单数据", notes = "在此补充接口详细注释...", response = HKmEntity.class)
    public R selectsjcd(@RequestBody HKmEntity hKmEntity) {
            
        return R.ok().put("data", hKmService.selectsjcd(hKmEntity));
    }
    
  
    @Login
    @PostMapping("/insert")
    @ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = HKmEntity.class)
    public R insert(@RequestBody HKmEntity hKmEntity) {
    	String km=hKmEntity.getKm().substring(0,3);
    	if("102".equals(km)){
    		hKmEntity.setKmlbbm("1");
    	}else if("211".equals(km)){
    		hKmEntity.setKmlbbm("3");
    	}
    	hKmEntity.setDjkm("0");
    	hKmEntity.setJbh(2);
    	hKmEntity.setZtbm("0001");
    	hKmEntity.setGzdbm("0001");
        hKmService.insert(hKmEntity);
        //自动添加该科目底级开发商
        HKmEntity h1=new HKmEntity();
        h1.setKm(hKmEntity.getKm()+"001");
        h1.setKmmc("开发商");
        h1.setKmlbbm(hKmEntity.getKmlbbm());
        h1.setKmsx(hKmEntity.getKmsx());
        h1.setDjkm("1");
        h1.setJbh(hKmEntity.getJbh()+1);
        h1.setZtbm("0001");
        h1.setGzdbm("0001");
        hKmService.insert(h1);
        //自动添加该科目底级业主
        HKmEntity h2=new HKmEntity();
        h2.setKm(hKmEntity.getKm()+"002");
        h2.setKmmc("业主");
        h2.setKmlbbm(hKmEntity.getKmlbbm());
        h2.setKmsx(hKmEntity.getKmsx());
        h2.setDjkm("1");
        h2.setJbh(hKmEntity.getJbh()+1);
        h2.setZtbm("0001");
        h2.setGzdbm("0001");
        hKmService.insert(h2);
        return R.ok();
    }


    @Login
    @PostMapping("/update")
    @ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = HKmEntity.class)
    public R update(@RequestBody HKmEntity hKmEntity) {
            hKmService.updateById(hKmEntity);
        return R.ok();
    }


    @Login
    @PostMapping("/delete")
    @ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = HKmEntity.class)
    public R delete(@RequestBody String[] ids) {
            hKmService.deleteBatch(ids);
        return R.ok();
    }
    
    //@Login
    @PostMapping("/selectsijcd")
    @ApiOperation(value = "四级级菜单数据", notes = "在此补充接口详细注释...", response = HKmEntity.class)
    public R selectsijcd2(@RequestBody HKmEntity hKmEntity) {
            
        return R.ok().put("data", hKmService.selectsijcd2(hKmEntity));
    }

}
