package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.HKmEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XmEntity;
import io.renren.modules.app.entity.XqxxEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.WxzjyjdrService;
import io.renren.modules.app.service.XmService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.List;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 楼盘信息（开发项目）
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-26 09:38:36
 */
@RestController
@RequestMapping("app/xm")
@Api(tags = "楼盘信息（开发项目）模块(开发项目录入)")
public class XmController {

	@Autowired
	private XmService xmService;
	
	@Autowired
	private WxzjyjdrService wxzjyjdrService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = XmEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, XmEntity xmEntity) {

		return R.ok().put("data", xmService.queryByPage(pageNum, pageSize, xmEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = XmEntity.class)
	public R insert(@RequestBody XmEntity xmEntity) {
		String a=xmService.queryxmbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String xmbm = b + c;
		xmEntity.setXmbm(xmbm);
		
		//自动新增科目及其底级开发商和业主科目
		HKmEntity h1=new HKmEntity();
		XmEntity xmxx=xmService.maxkmbm();
		String d = Integer.toString(Integer.parseInt(xmxx.getKm()) + 1);
		xmEntity.setKfskm(d+"001");
		xmService.insertXm(xmEntity);
		h1.setKm(d);
		h1.setKmmc(xmEntity.getXmmc());
		h1.setKmlbbm("3");
		h1.setDjkm("0");
    	h1.setJbh(2);
    	h1.setZtbm("0001");
    	h1.setKmsx("1");
    	h1.setGzdbm("0001");
    	xmService.insertkm(h1);
    	HKmEntity h2=new HKmEntity();
    	 h2.setKm(h1.getKm()+"001");
         h2.setKmmc("开发商");
         h2.setKmlbbm(h1.getKmlbbm());
         h2.setKmsx(h1.getKmsx());
         h2.setDjkm("1");
         h2.setJbh(h1.getJbh()+1);
         h2.setZtbm("0001");
         h2.setGzdbm("0001");
         xmService.insertkm(h2);
    	HKmEntity h3=new HKmEntity();
    	h3.setKm(h1.getKm()+"002");
        h3.setKmmc("业主");
        h3.setKmlbbm(h1.getKmlbbm());
        h3.setKmsx(h1.getKmsx());
        h3.setDjkm("1");
        h3.setJbh(h1.getJbh()+1);
        h3.setZtbm("0001");
        h3.setGzdbm("0001");
        xmService.insertkm(h3);
        //--------------
        //每新增一个项目刷新到fzhsye表中
        YwpzEntity yy=new YwpzEntity();
        yy.setXmbm(xmbm);
		yy.setDjlx("01");
		yy.setQcye(0.0);
		yy.setJffse(0.0);
		yy.setDffse(0.0);
		yy.setQmye(0.0);
		//获取验fzhsye表中最大kjqj
		String maxkjqj=xmService.selectmaxkjqj();
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
		java.util.Date dBegin = null;
		try {
			dBegin = sdf.parse("2005-01");
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		java.util.Date dEnd = null;
		try {
			dEnd = sdf.parse(maxkjqj);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<String> datas = wxzjyjdrService.findDates(dBegin, dEnd);
		for (String kjqj : datas) {
			yy.setGjkjqj(kjqj);
			xmService.insertfzhsye(yy);
		}
		yy.setDjlx("03");
		for (String kjqj : datas) {
			yy.setGjkjqj(kjqj);
			xmService.insertfzhsye(yy);
		}
		//------------------------------------------------------
		String maxkjqj2=xmService.selectmaxkjqj2();
		try {
			dBegin = sdf.parse("2005-01");
		} catch (ParseException e1) {
			e1.printStackTrace();
		}
		try {
			dEnd = sdf.parse(maxkjqj2);
		} catch (ParseException e) {
			e.printStackTrace();
		}
		List<String> datas2 = wxzjyjdrService.findDates(dBegin, dEnd);
		yy.setDjlx("21");
		for (String kjqj : datas2) {
			yy.setGjkjqj(kjqj);
			yy.setZqlx("01");
			xmService.insertfzhsye(yy);
			yy.setZqlx("03");
			xmService.insertfzhsye(yy);
		}
//		yy.setDjlx("22");
//		for (String kjqj : datas2) {
//			yy.setGjkjqj(kjqj);
//			yy.setZqlx("01");
//			xmService.insertfzhsye(yy);
//			yy.setZqlx("03");
//			xmService.insertfzhsye(yy);
//		}
        //--------------
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = XmEntity.class)
	public R update(@RequestBody XmEntity xmEntity) {
		xmService.updateById(xmEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = XmEntity.class)
	public R delete(@RequestBody String[] ids) {
		xmService.deleteBatch(ids);
		for(String xmbm:ids){
			xmService.deletefzhsyexmbm(xmbm);
		}
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "", response = XmEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", xmService.selectById(id));
	}

	@Login
	@PostMapping("/selectxqmc")
	@ApiOperation(value = "查询所有小区", notes = "根据小区下拉框查询所有小区信息", response = XqxxEntity.class)
	public R selectxqmc() {

		return R.ok().put("select", xmService.selectxqmc());
	}

	// 下拉框数据获取
	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody String id) {

		return R.ok().put("select", xmService.selectxlk(id));
	}

}
