package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.YhxxEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.service.YhxxService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 银行信息
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/yhxx")
@Api(tags = "银行信息模块(银行信息设置)")
public class YhxxController {

	@Autowired
	private YhxxService yhxxService;

	@Login
	@GetMapping("queryByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = YhxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, YhxxEntity yhxxEntity) {

		return R.ok().put("data", yhxxService.queryByPage(pageNum, pageSize, yhxxEntity));
	}

	@Login
	@PostMapping("/insert")
	@ApiOperation(value = "新增", notes = "在此补充接口详细注释...", response = YhxxEntity.class)
	public R insert(@RequestBody YhxxEntity yhxxEntity) {
		String a=yhxxService.queryyhbm();
		String b = a.substring(0, 3);
		String c = Integer.toString(Integer.parseInt(a.substring(3)) + 1);
		String yhbm = b + c;
		yhxxEntity.setYhbm(yhbm);
		yhxxEntity.setGzdbm("0001");
		yhxxEntity.setZtbm("0001");
		yhxxService.insert(yhxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/update")
	@ApiOperation(value = "修改", notes = "在此补充接口详细注释...", response = YhxxEntity.class)
	public R update(@RequestBody YhxxEntity yhxxEntity) {
		yhxxEntity.setZtbm("0001");
		yhxxService.updateById(yhxxEntity);
		return R.ok();
	}

	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "(批量)删除", notes = "根据id删除，前端传参名：ids（数组）", response = YhxxEntity.class)
	public R delete(@RequestBody String[] ids) {
		yhxxService.deleteBatch(ids);
		return R.ok();
	}

	@Login
	@PostMapping("/select")
	@ApiOperation(value = "编辑查询", notes = "在此补充接口详细注释...", response = YhxxEntity.class)
	public R select(@RequestBody String id) {

		return R.ok().put("select", yhxxService.selectById(id));
	}

	@Login
	@PostMapping("/selectkm")
	@ApiOperation(value = "银行科目下拉框", notes = "在此补充接口详细注释...", response = YhxxEntity.class)
	public R selectyhkm() {

		return R.ok().put("list", yhxxService.selectkmxlk());
	}

}
