package io.renren.modules.app.service;

import com.baomidou.mybatisplus.service.IService;
import com.github.pagehelper.PageInfo;
import io.renren.common.utils.R;
import io.renren.modules.app.entity.SysDictEntity;

import java.util.List;
import java.util.Map;

/**
 * 数据字典表
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-04-01 11:31:35
 */
public interface SysDictService extends IService<SysDictEntity> {

    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param sysDictEntity
     * @return
     */
    PageInfo<SysDictEntity> queryByPage(Integer pageNum, Integer pageSize, SysDictEntity sysDictEntity);

    void insertSys_dict(SysDictEntity dictEntity);
    
    /**
    * 单个或批量删除
    * @param ids
    */
    void deleteBatch(String[] ids);
    
    /**
     * 字典类型下拉框
     * @return
     */
    List<SysDictEntity> zdxlk();
    
    /**
     * 查询字典码是否已有
     * @param sysDictEntity
     * @return
     */
    int selectCode(SysDictEntity sysDictEntity);


    /**
     * 字典名称下拉列表（查询用）
     */

    R queryList(SysDictEntity sysDictEntity);


    /**
     * 字典名称下拉列表（本页面查询用）
     */

    R queryListLocal(SysDictEntity sysDictEntity);
    
    
    /**
     * 字典表插入
     * @param sysDictEntity
     * @return
     */
    int insertZDInfo(SysDictEntity sysDictEntity);

}

