package io.renren.modules.app.service.impl;

import com.alibaba.druid.sql.ast.statement.SQLIfStatement.Else;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import io.renren.modules.app.dao.FwwxdshDao;
import io.renren.modules.app.entity.FjEntity;
import io.renren.modules.app.entity.FtqcEntity;
import io.renren.modules.app.entity.FwxxEntity;
import io.renren.modules.app.entity.SqwxzqEntity;
import io.renren.modules.app.entity.WxjlbEntity;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.XmEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.YwpzmxEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.FwwxdshService;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Service;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@Service("fwwxdshService")
public class FwwxdshServiceImpl extends ServiceImpl<FwwxdshDao, SqwxzqEntity> implements FwwxdshService {

	/**
	 * 分页模糊查询
	 * 
	 * @param pageNum
	 * @param pageSize
	 * @param sqwxzqEntity
	 * @return
	 */
	@Override
	public PageInfo<SqwxzqEntity> queryByPage(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<SqwxzqEntity> sqwxzqEntitys = baseMapper.queryByPage(sqwxzqEntity);
		for (int i = 0; i < sqwxzqEntitys.size(); i++) {
			List<WxjlbEntity> js = baseMapper.selectwxxmxxbysqdh(sqwxzqEntitys.get(i).getSqdbh());
			sqwxzqEntitys.get(i).setWxlb(js);
			FjEntity js2 = baseMapper.selectwjdxbyfjid(sqwxzqEntitys.get(i).getFjid());
			if (js2 != null || !"".equals(js2)) {
				sqwxzqEntitys.get(i).setWjdx(js2);
			}
			// 由于可能是按小区分摊存在多个项目，所以项目名称单独取
			List<String> l = baseMapper.queryByxm(sqwxzqEntitys.get(i).getSqdbh());
			String xmmc = "";
			for (String str : l) {
				if (str.equals(l.get(0))) {
					xmmc = xmmc + str;
				} else {
					xmmc = xmmc + "," + str;
				}
			}
			sqwxzqEntitys.get(i).setXmmc(xmmc);
		}
		PageInfo<SqwxzqEntity> pageInfo = new PageInfo<SqwxzqEntity>(sqwxzqEntitys);
		return pageInfo;
	}

	/**
	 * 单个或批量删除
	 * 
	 * @param ids
	 */
	@Override
	public void deleteBatch(String[] ids) {
		this.deleteBatchIds(Arrays.asList(ids));
	}

	@Override
	public void updatedjzt(SqwxzqEntity sqwxzqEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);
		sqwxzqEntity.setShrq(temp_str);
		baseMapper.updatetgsh(sqwxzqEntity);
	}

	@Override
	public void updateqxsh(SqwxzqEntity sqwxzqEntity) {

		baseMapper.updateqxsh(sqwxzqEntity);
	}

	@Override
	public void updatebh(SqwxzqEntity sqwxzqEntity) {

		baseMapper.updatebh(sqwxzqEntity);
	}

	@Override
	public PageInfo<SqwxzqEntity> queryByPageC(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<SqwxzqEntity> sqwxzqEntitys = baseMapper.queryByPageC(sqwxzqEntity);
		for (SqwxzqEntity s : sqwxzqEntitys) {
			// -------------------------------------------
			// 由于可能是按小区分摊存在多个项目，所以项目名称单独取
			List<XmEntity> l = baseMapper.queryByxm2(s.getSqdbh());
			String xmmc = "";
			String xmbms = "(";
			for (XmEntity str : l) {
				if (str.equals(l.get(0))) {
					xmmc = xmmc + str.getXmmc();
					xmbms = xmbms + str.getXmbm();
				} else if (l.size() > 1) {
					xmmc = xmmc + "," + str.getXmmc();
					xmbms = xmbms + "," + str.getXmbm();
				}
			}
			xmbms = xmbms + ")";
			s.setXmmc(xmmc);
			// -------------------------------------------
			// 计算每个维修单这个项目下所有房屋的sum(grje)+sum(dwje)(首次拨付前的账户金额和首次拨付后的账户金额)
			// 先计算首次拨付前的账户金额：
			SqwxzqEntity s1 = baseMapper.selectscbfqxmje(xmbms);
			//查此次分摊前如果已经分摊过，就要减掉之前分摊的钱，保证每次分摊前的项目金额是此次分摊前的项目金额
			Double je=baseMapper.selectscwca(s.getSqrq(), xmbms);
//			// 再计算首次拨付后的账户金额：
//			SqwxzqEntity s2 = baseMapper.selectscbfhxmje(xmbms);
			s.setScbfqxmje(s1.getScbfqxmje()-je);
			if("0".equals(s.getSffp())){
				s.setScbfhxmje(s1.getScbfqxmje()-je);
			}else if("1".equals(s.getSffp())){
				s.setScbfhxmje(s1.getScbfqxmje()-je-s.getSpje());
			}
			FjEntity js2 = baseMapper.selectwjdxbyfjid(s.getFjid());
			if (js2 != null || !"".equals(js2)) {
				s.setWjdx(js2);
			}
			List<YwpzEntity> y = baseMapper.selectdjxx(s.getSqdbh());
			if (!y.isEmpty()) {
				s.setBankCode(y.get(0).getBankCode());
				s.setJsfs(y.get(0).getJsfs());
				s.setZph(y.get(0).getZph());
				s.setDjrq(y.get(0).getDjrq());
			}

		}
		PageInfo<SqwxzqEntity> pageInfo = new PageInfo<SqwxzqEntity>(sqwxzqEntitys);
		return pageInfo;
	}

	@Override
	public PageInfo<FwxxEntity> queryByPageF(Integer pageNum, Integer pageSize, FwxxEntity fwxxEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<FwxxEntity> list = new ArrayList<FwxxEntity>();
		List<ZhxxEntity> zList = baseMapper.selectdhbmbysqdbh(fwxxEntity.getSqdbh());
		// --------
		List<String> listqc = new ArrayList<String>();
		for (ZhxxEntity zz : zList) {
			listqc.add(zz.getDhbm());
		}
		Set set = new HashSet();
		List<String> newList = new ArrayList<String>();
		for (String cd : listqc) {
			if (set.add(cd)) {
				newList.add(cd);
			}
		}
		// --------
		for (String dhbm : newList) {
			List<FwxxEntity> fwxxs = baseMapper.queryByPageF(dhbm);
			for (FwxxEntity f : fwxxs) {
				// 每一户房屋的账户金额（缴款金额）=个人预交复核金额+单位分配+公共收益分摊
				if (f.getGrje() == null) {
					f.setGrje(0.0);
				}
				if (f.getDwje() == null) {
					f.setDwje(0.0);
				}
				if (f.getGgsy() == null) {
					f.setGgsy(0.0);
				}
				if (f.getZqje() == null) {
					f.setZqje(0.0);
				}
				if (f.getXhje() == null) {
					f.setXhje(0.0);
				}
				Double a = f.getGrje() + f.getDwje(); // 账户金额（单位分配（dwje）+个人预交（grje）
				f.setZhje((double) Math.round(a * 100) / 100);
				// 每一户房屋的余额=账户金额-支取金额-销户金额-业主退款
				Double b = f.getDqye();// 表里面dqye是随着每一笔交存和支取业务动态改变的，所以每一户的账户余额也等于dqye
				f.setDqye((double) Math.round(b * 100) / 100);
				YwpzEntity y = new YwpzEntity();
				y.setDhbm(f.getDhbm());
				y.setXmbm(f.getXmbm());
				y.setSqdbh(fwxxEntity.getSqdbh());
				YwpzEntity y1 = baseMapper.selectwxjlbsqje(y);
				f.setSqzje(y1.getJe());
				// f.setSqzje(z.getZje());// 每栋楼的分摊金额
				list.add(f);
			}
		}

		PageInfo<FwxxEntity> pageInfo = new PageInfo<FwxxEntity>(list);
		return pageInfo;
	}

	@Override
	public void insertft(YwpzEntity y) {

		// -----------------------------------------//现存在一次分摊穿过来的ftmx存在多个项目；思路，在不动原先的逻辑下，整理出每个项目的分摊额，生成多个单据，再直接循环，避免代码逻辑修改
		// 1.拿到分摊的所有项目编码
		Set set = new HashSet();
		List<String> newList = new ArrayList<String>();
		for (FwxxEntity cd : y.getFtmx()) {
			if (set.add(cd.getXmbm())) {
				newList.add(cd.getXmbm());
			}
		}
		// 2.将每个项目像分摊的记录分组放到各自的项目里
		List<List<FwxxEntity>> p = new ArrayList<List<FwxxEntity>>();
		for (int i = 0; i < newList.size(); i++) {
			p.add(new ArrayList<FwxxEntity>());
			Double je = 0.0;
			for (int j = 0; j < y.getFtmx().size(); j++) {
				if (newList.get(i).equals(y.getFtmx().get(j).getXmbm())) {
					p.get(i).add(y.getFtmx().get(j));
					je = je + y.getFtmx().get(j).getSqje();
				}
			}
			FwxxEntity o = new FwxxEntity();
			o.setDqye(je);
			p.get(i).add(o);
		}
		for (List<FwxxEntity> x1 : p) {
			y.getFtmx().clear();
			for (int i = 0; i < x1.size(); i++) {
				if (i < x1.size() - 1) {// 最后一个事为了统计每个项目的分摊总额添加的一个元素
					y.getFtmx().add(x1.get(i));
				}
			}
			y.setSpje(x1.get(x1.size() - 1).getDqye());
			y.setXmbm(x1.get(0).getXmbm());
			String xm = x1.get(0).getXmmc();
			// ====================================这里面做原先分摊的代码，不用动
			// -----------------------------------------------------------------------------------------
			// 1.记录首次分摊的业务数据
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			temp_str = sdf.format(dt);
			String temp_str1 = "";
			Date dt1 = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
			temp_str1 = sdf1.format(dt1);
			String maxdjbh = baseMapper.queryByCounthb(temp_str);
			String newdjbh = "";
			if ("".equals(maxdjbh) || maxdjbh == null) {
				newdjbh = "21" + temp_str1 + "0001";
			} else if (!"".equals(maxdjbh) && maxdjbh != null) {
				String aa = Integer.parseInt(maxdjbh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newdjbh = "21" + temp_str1 + result;
			}
			y.setDjbh(newdjbh);
			baseMapper.updatesqhbzt(y);// 维修单据中关联首次分摊的单据编号
			// 记录首次分摊到ywpz表中
			y.setDjlx("21");
			y.setKjqj(y.getDjrq().substring(0, 7));
			y.setDwbm(baseMapper.selectdwbmbyxm(y.getXmbm()));
			y.setJe(y.getSpje());// 审核金额即为首次拨付金额
			y.setZph2(y.getZph());
			y.setXgbm(y.getXmbm());
			baseMapper.insertywpzhb(y);
			// 记录首次分摊的明细到ywpzmx表中
			// 记录每一户分摊的钱是扣的开发商的还是个人的
			Double sumdw = 0.0;
			Double sumgr = 0.0;
			for (FwxxEntity c : y.getFtmx()) {
				YwpzmxEntity m = new YwpzmxEntity();
				// 更新每一户分摊之后，grje，dwje，dqye，zqje的钱
				FwxxEntity f = baseMapper.selectfwxxbyfwbm(c.getFwbm());
				f.setZqje(f.getZqje() + c.getSqje());
				f.setDqye(f.getDqye() - c.getSqje());
				ZhxxEntity z = baseMapper.selectzhxxbydhbm(c.getDhbm());
				z.setZqje(z.getZqje() + c.getSqje());
				z.setDqye(z.getDqye() - c.getSqje());
				int val = f.getDwje().compareTo(c.getSqje());
				if (val >= 0) {// 表示单位分配的钱比此次需要分摊的钱多，则只扣单位分配的钱
					//------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(c.getSqje());//此次单位分摊金额
					m.setGrje(0.0);//此次个人分摊金额
					m.setHdwje(f.getDwje() - c.getSqje());//此次分摊后单位金额
					m.setHgrje(f.getGrje());//此次分摊后个人金额
					//---------------------------------------------------
					f.setDwje(f.getDwje() - c.getSqje());
					f.setZqkkfs("0");
					sumdw = sumdw + c.getSqje();
				} else if (val < 0 && f.getDwje() == 0) {// 表示单位分配的钱为0，只能直接扣grje
					//-----------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(0.0);//此次单位分摊金额
					m.setGrje(c.getSqje());//此次个人分摊金额
					m.setHdwje(f.getDwje());//此次分摊后单位金额
					m.setHgrje(f.getGrje()-c.getSqje());//此次分摊后个人金额
					//------------------------------------------------------
					f.setGrje(f.getGrje() - c.getSqje());
					z.setGryjje(z.getGryjje() - c.getSqje());
					f.setZqkkfs("1");
					sumgr = sumgr + c.getSqje();
				} else if (val < 0 && f.getDwje() >= 0) {// 表示单位分配的钱>0但是又不够此次首次分摊的钱，只能先把dwje钱扣完，再扣grje
					double sy = c.getSqje() - f.getDwje();
					sumdw = sumdw + f.getDwje();
					sumgr = sumgr + sy;
					//-------------------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(f.getDwje());//此次单位分摊金额
					m.setGrje(sy);//此次个人分摊金额
					m.setHdwje(0.0);//此次分摊后单位金额
					m.setHgrje(f.getGrje()-sy);//此次分摊后个人金额
					//-------------------------------------------------------------
					f.setDwje(0.0);
					f.setGrje(f.getGrje() - sy);
					z.setGryjje(z.getGryjje() - sy);
					f.setZqkkfs("2");
					f.setZqdwje(c.getSqje() - sy);
					
				}
				//---------------
				m.setDjbh(newdjbh);
				m.setDhbm(c.getDhbm());
				m.setFwbm(c.getFwbm());
				m.setBjje(c.getSqje());
				m.setJe(c.getSqje());
				m.setJdf("1");
				baseMapper.insertywpzmxx(m);
				//---------------
				baseMapper.updatefwxxzqje(f);// 更新每一户分摊之后，grje，dwje，dqye，zqje的钱
				baseMapper.updatezhxxzqje(z);// 更新每一栋的支取金额zqje，dqye,gryjje
			}
			// 3.像ftqc房屋维修分摊清册表录入分摊的房屋记录
			for (FwxxEntity c : y.getFtmx()) {
				c.setSqdbh(y.getSqdbh());
				baseMapper.insertftqc(c);
			}
			// 4.修改该维修单单据的分摊方式和状态
			SqwxzqEntity sqwxzqEntity = new SqwxzqEntity();
			sqwxzqEntity.setSqdbh(y.getSqdbh());
			sqwxzqEntity.setFprq(temp_str);
			sqwxzqEntity.setFpfs(y.getFpfs());
			sqwxzqEntity.setFprbm(y.getFprbm());
			sqwxzqEntity.setFprxm(y.getFprxm());
			baseMapper.updatesqftzt(sqwxzqEntity);
			// -----------------------------------------里面是搞辅助核算的
			// 将首次支取分摊产生的业务数据记录到辅助明细表中
			YwpzEntity y0 = baseMapper.selectfzdj(newdjbh);
			y0.setXm(xm);
			// 将该单据记录到辅助核算明细表中。
			if (sumdw > 0) {
				y0.setJe(sumdw);
				y0.setZqlx("01");
				baseMapper.insertfzhsmx2(y0);
			}
			if (sumgr > 0) {
				y0.setJe(sumgr);
				y0.setZqlx("03");
				baseMapper.insertfzhsmx2(y0);
			}
		}

	}

	@Override
	public List<FwxxEntity> selectftfw(SqwxzqEntity sqwxzqEntity) {
		List<FwxxEntity> list = baseMapper.selectftfw(sqwxzqEntity.getSqdbh());
		List<String> djbhs=baseMapper.selectdjbhbysqdbh(sqwxzqEntity.getSqdbh());
		String djbhss="(";
		for(String djbh:djbhs){
				if (djbh.equals(djbhs.get(0))) {
					djbhss = djbhss + djbhs.get(0);
				} else if (djbhs.size() > 1) {
					djbhss = djbhss + "," + djbh;
				}
		}
		djbhss = djbhss + ")";
		List<YwpzmxEntity> listft=baseMapper.selectftqcsc2(djbhss);
		for (FwxxEntity f : list) {
			//--------------------------------
			for(YwpzmxEntity m:listft){
				if(f.getFwbm().equals(m.getFwbm())){
					f.setDwje(m.getQdwje());
					f.setGrje(m.getQgrje());
					f.setDqye((double) Math.round((m.getQdwje()+m.getQgrje()) * 100) / 100);
				}
			}
			//--------------------------------
			// 每一户房屋的账户金额（缴款金额）=个人预交复核金额+单位分配+公共收益分摊
			Double a = f.getGrje() + f.getDwje();
			// f.setDqye((double) Math.round(a * 100) / 100);
			f.setZhje((double) Math.round(a * 100) / 100);// 账户金额
			// 每一户房屋的余额=dqye
//			Double b = f.getDqye();// 表里面dqye是随着每一笔交存和支取业务动态改变的，所以每一户的账户余额也等于dqye
//			f.setDqye((double) Math.round(b * 100) / 100);
			YwpzEntity y = new YwpzEntity();
			y.setDhbm(f.getDhbm());
			y.setSqdbh(f.getSqdbh());
			YwpzEntity y1 = baseMapper.selectwxjlbsqje(y);
			f.setSqzje(y1.getJe());
		}
		return list;
	}

	@Override
	public void deleteft(SqwxzqEntity sqwxzqEntity) {
		List<String> djbhs = baseMapper.selectdjbhbysqdbh(sqwxzqEntity.getSqdbh());
		for (String djbh : djbhs) {
			// ==================================================================
			// 分摊金额返回
			List<FtqcEntity> fts = baseMapper.selectftqcsc(djbh);
			Double sumdw = 0.0;
			Double sumgr = 0.0;
			for (FtqcEntity c : fts) {
				// 更新每一户分摊之后，grje，dwje，dqye，zqje的钱
				FwxxEntity f = baseMapper.selectfwxxbyfwbm(c.getFwbm());
				f.setZqje(f.getZqje() - c.getSqje());
				f.setDqye(f.getDqye() + c.getSqje());
				ZhxxEntity z = baseMapper.selectzhxxbydhbm(c.getDhbm());
				z.setZqje(z.getZqje() - c.getSqje());
				z.setDqye(z.getDqye() + c.getSqje());
				if ("0".equals(f.getZqkkfs())) {// 表示单位分配的钱比此次需要分摊的钱多，则只扣单位分配的钱
					f.setDwje(f.getDwje() + c.getSqje());
					sumdw = sumdw + c.getSqje();
				} else if ("1".equals(f.getZqkkfs())) {// 表示单位分配的钱为0，只能直接扣grje
					f.setGrje(f.getGrje() + c.getSqje());
					z.setGryjje(z.getGryjje() + c.getSqje());
					sumgr = sumgr + c.getSqje();
				} else if ("2".equals(f.getZqkkfs())) {// 表示单位分配的钱>0但是又不够此次首次分摊的钱，只能先把dwje钱扣完，再扣grje
					f.setDwje(f.getZqdwje());
					double sy = c.getSqje() - f.getZqdwje();
					sumdw = sumdw + f.getDwje();
					sumgr = sumgr + sy;
					f.setGrje(f.getGrje() + sy);
					z.setGryjje(z.getGryjje() + sy);
					f.setZqdwje(0.0);
				}
				f.setZqkkfs("");
				baseMapper.updatefwxxzqje(f);// 更新每一户分摊之后，grje，dwje，dqye，zqje的钱
				baseMapper.updatezhxxzqje(z);// 更新每一栋的支取金额zqje，dqye,gryjje
			}
			// ==================================================================
			// 当首次分摊删除时时，要将该单据从辅助核算明细表中删除
			YwpzEntity y0 = baseMapper.selectfzdj(djbh);
			if (isObjectNotEmpty(y0) == true) {
				baseMapper.deletefzhsdj(djbh);
			}
		}

		// -------------
		// 删除对应的业务单据
		baseMapper.deleteftywpzmx(sqwxzqEntity.getSqdbh());
		baseMapper.deleteftywpz(sqwxzqEntity.getSqdbh());
		// 清空维修单分摊的关联信息
		baseMapper.updateqxft(sqwxzqEntity);
		// 清空ftqc
		baseMapper.deleteftqcsc(sqwxzqEntity.getSqdbh());

	}

	@Override
	public void inserthb(YwpzEntity ywpzEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCounthb(ywpzEntity.getDjrq());
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "21" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "21" + temp_str1 + result;
		}

		// 1.改变sqwxzq中的划拨状态，并增加djbh
		ywpzEntity.setDjbh(newdjbh);
		baseMapper.updatesqhbzt(ywpzEntity);
		// 2.ywpz表中记录本次划拨
		ywpzEntity.setDjlx("21");
		ywpzEntity.setShrq(temp_str);// 划拨日期
		YwpzEntity b = baseMapper.selectzckje(ywpzEntity.getDhbm());
		ywpzEntity.setDwbm(b.getDwbm());
		ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
		baseMapper.insertywpzhb(ywpzEntity);
	}

	@Override
	public PageInfo<SqwxzqEntity> queryByPageHB(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {
		PageHelper.startPage(pageNum, pageSize);
		// 查询出所有已分摊得单据
		List<SqwxzqEntity> sqwxzqEntitys = baseMapper.queryByPageHB(sqwxzqEntity);
		// 判断是否划拨，有则返回相应得划拨记录，没有则返回空。
		for (int i = 0; i < sqwxzqEntitys.size(); i++) {
			if ("".equals(sqwxzqEntitys.get(i).getDjbh()) || sqwxzqEntitys.get(i).getDjbh() == null) {
				// 则未划拨
			} else {
				// 则已划拨
				YwpzEntity y = baseMapper.selectywpzhbxx(sqwxzqEntitys.get(i).getDjbh());
				// 返回对应的划拨信息
				sqwxzqEntitys.get(i).setYhmc(y.getYhmc());
				sqwxzqEntitys.get(i).setBillname(y.getBillname());
				sqwxzqEntitys.get(i).setDjrq(y.getDjrq());
				sqwxzqEntitys.get(i).setZph(y.getZph());
				sqwxzqEntitys.get(i).setCzyxm(y.getCzyxm());
				sqwxzqEntitys.get(i).setHbrq(y.getShrq());
				sqwxzqEntitys.get(i).setBz(y.getBz());
			}
		}
		PageInfo<SqwxzqEntity> pageInfo = new PageInfo<SqwxzqEntity>(sqwxzqEntitys);
		return pageInfo;
	}

	@Override
	public void deleteHB(SqwxzqEntity sqwxzqEntity) {
		// 1.通过该sqdbh找到对应的djbh，然后删除ywpz中的划拨记录
		// String djbh = baseMapper.selectdjbhbysqdbh(sqwxzqEntity.getSqdbh());
		// baseMapper.deleteywpz(djbh);
		// 2.通过该申请单编号修改sqwxzq表中该划拨状态为未划拨，清除该划拨djbh
		baseMapper.updateqxhb(sqwxzqEntity.getSqdbh());
	}

	@Override
	public PageInfo<SqwxzqEntity> queryByPageJS(Integer pageNum, Integer pageSize, SqwxzqEntity sqwxzqEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<SqwxzqEntity> sqwxzqEntitys = baseMapper.queryByPageJS(sqwxzqEntity);
		for (int i = 0; i < sqwxzqEntitys.size(); i++) {
			if ("0".equals(sqwxzqEntitys.get(i).getSfjs())) {
				// 则是没有决算，则下方房屋信息分摊列表通过sqdbh查询ftqc表
				List<FwxxEntity> f = baseMapper.selectfwbyftqc2(sqwxzqEntitys.get(i).getSqdbh());
				for (FwxxEntity fEntity : f) {
					// 每一户房屋的账户金额（缴款金额）=个人预交复核金额+单位分配
					Double a = fEntity.getGrje() + fEntity.getDwje();
					fEntity.setZhje((double) Math.round(a * 100) / 100);// 账户金额
					// // 每一户房屋的余额=dqye(因为这个字段是随着每一笔业务自动增加或减少的)
				}
				sqwxzqEntitys.get(i).setFtmx(f);
			} else if ("1".equals(sqwxzqEntitys.get(i).getSfjs())) {
				// 通过jsdbh查询ywpz中的决算信息
				SqwxzqEntity s = baseMapper.selectywpzjs(sqwxzqEntitys.get(i).getSqdbh());
				sqwxzqEntitys.get(i).setJsr(s.getCzyxm());
				sqwxzqEntitys.get(i).setJsrq(s.getShrq());
				sqwxzqEntitys.get(i).setJsje(s.getJe());
				sqwxzqEntitys.get(i).setJsyh(s.getYhmc());
				sqwxzqEntitys.get(i).setJsfshi(s.getBillname());
				sqwxzqEntitys.get(i).setJsh(s.getZph());
				sqwxzqEntitys.get(i).setJsbzhu(s.getBz());
				// 已决算，则下方房屋信息分摊列表通过jsdbh查询ywpzmx表
				List<FwxxEntity> f = baseMapper.selectfwbyftqc(sqwxzqEntitys.get(i).getSqdbh());
				List<String> djbhs = baseMapper.selectdjbhbysqdbh2(sqwxzqEntitys.get(i).getSqdbh());
				String djbhss = "(";
				for (String djbh : djbhs) {
					if (djbh.equals(djbhs.get(0))) {
						djbhss = djbhss + djbhs.get(0);
					} else if (djbhs.size() > 1) {
						djbhss = djbhss + "," + djbh;
					}
				}
				djbhss = djbhss + ")";
				List<YwpzmxEntity> listft = baseMapper.selectftqcsc2(djbhss);
				for (FwxxEntity fEntity : f) {
					//--------------------------------
					for (YwpzmxEntity m : listft) {
						if (fEntity.getFwbm().equals(m.getFwbm())) {
							fEntity.setDwje(m.getQdwje());
							fEntity.setGrje(m.getQgrje());
							fEntity.setDqye((double) Math.round((m.getQdwje() + m.getQgrje()) * 100) / 100);
						}
					}
					//--------------------------------
					// 每一户房屋的账户金额（缴款金额）=个人预交复核金额+单位分配+公共收益分摊
					Double a = fEntity.getGrje() + fEntity.getDwje();
					fEntity.setZhje((double) Math.round(a * 100) / 100);// 账户金额
					// // 每一户房屋的余额=dqye(因为这个字段是随着每一笔业务自动增加或减少的)
//					// -------------------------------------------------------------------------------
//					if ("0".equals(fEntity.getZqkkfs2())) {// 余额分摊只扣了单位的
//						fEntity.setDwje(fEntity.getDwje() + fEntity.getZqje2());
//					} else if ("1".equals(fEntity.getZqkkfs2())) {// 余额分摊只扣了个人的
//						fEntity.setGrje(fEntity.getGrje() + fEntity.getZqje2());
//					} else if ("2".equals(fEntity.getZqkkfs2())) {// 余额分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//						fEntity.setDwje(fEntity.getDwje() + fEntity.getZqdwje2());
//						fEntity.setGrje(fEntity.getGrje() + (fEntity.getZqje2() - fEntity.getZqdwje2()));
//					}
//					// -------------------------------------------------------------------------------
				}
				sqwxzqEntitys.get(i).setFtmx(f);
			}
			// -------------------------------------------
			// 由于可能是按小区分摊存在多个项目，所以项目名称单独取
			List<XmEntity> l = baseMapper.queryByxm2(sqwxzqEntitys.get(i).getSqdbh());
			String xmmc = "";
			String xmbms = "(";
			for (XmEntity str : l) {
				if (str.equals(l.get(0))) {
					xmmc = xmmc + str.getXmmc();
					xmbms = xmbms + str.getXmbm();
				} else if (l.size() > 1) {
					xmmc = xmmc + "," + str.getXmmc();
					xmbms = xmbms + "," + str.getXmbm();
				}
			}
			xmbms = xmbms + ")";
			sqwxzqEntitys.get(i).setXmmc(xmmc);
			// -------------------------------------------
			// 计算每个维修单这个项目下所有房屋的sum(grje)+sum(dwje)(首次拨付前的账户金额和首次拨付后的账户金额)
			// 先计算余额拨付前的账户金额：
			SqwxzqEntity s1 = baseMapper.selectscbfqxmje(xmbms);
			Double je = baseMapper.selectscwca(sqwxzqEntitys.get(i).getSqrq(), xmbms);
			// 再计算余额拨付后的账户金额：
//			SqwxzqEntity s2 = baseMapper.selectscbfhxmje2(xmbms);
			sqwxzqEntitys.get(i).setScbfqxmje(s1.getScbfqxmje() - je - sqwxzqEntitys.get(i).getSpje());
			if (sqwxzqEntitys.get(i).getYebfje() != null) {
				sqwxzqEntitys.get(i).setScbfhxmje(s1.getScbfqxmje() - je - sqwxzqEntitys.get(i).getSpje() - sqwxzqEntitys.get(i).getYebfje());
			} else {
				sqwxzqEntitys.get(i).setScbfhxmje(s1.getScbfqxmje() - je - sqwxzqEntitys.get(i).getSpje());
			}
			FjEntity js2 = baseMapper.selectwjdxbyfjid(sqwxzqEntitys.get(i).getFjid());
			if (js2 != null || !"".equals(js2)) {
				sqwxzqEntitys.get(i).setWjdx(js2);
			}
		}
		PageInfo<SqwxzqEntity> pageInfo = new PageInfo<SqwxzqEntity>(sqwxzqEntitys);
		return pageInfo;
	}

	@Override
	public void insertjs(YwpzEntity ywpzEntity) {
		// -----------------------------------------//现存在一次分摊穿过来的ftmx存在多个项目；思路，在不动原先的逻辑下，整理出每个项目的分摊额，生成多个单据，再直接循环，避免代码逻辑修改
		// 1.拿到分摊的所有项目编码
		Set set = new HashSet();
		List<String> newList = new ArrayList<String>();
		for (FwxxEntity cd : ywpzEntity.getFtmx()) {
			if (set.add(cd.getXmbm())) {
				newList.add(cd.getXmbm());
			}
		}
		// 2.将每个项目像分摊的记录分组放到各自的项目里
		List<List<FwxxEntity>> p = new ArrayList<List<FwxxEntity>>();
		for (int i = 0; i < newList.size(); i++) {
			p.add(new ArrayList<FwxxEntity>());
			Double je = 0.0;
			for (int j = 0; j < ywpzEntity.getFtmx().size(); j++) {
				if (newList.get(i).equals(ywpzEntity.getFtmx().get(j).getXmbm())) {
					p.get(i).add(ywpzEntity.getFtmx().get(j));
					je = je + ywpzEntity.getFtmx().get(j).getZsje();
				}
			}
			FwxxEntity o = new FwxxEntity();
			o.setDqye(je);
			p.get(i).add(o);
		}
		for (List<FwxxEntity> x1 : p) {
			ywpzEntity.getFtmx().clear();
			for (int i = 0; i < x1.size(); i++) {
				if (i < x1.size() - 1) {// 最后一个事为了统计每个项目的分摊总额添加的一个元素
					ywpzEntity.getFtmx().add(x1.get(i));
				}
			}
			ywpzEntity.setJe(x1.get(x1.size() - 1).getDqye());
			ywpzEntity.setXmbm(x1.get(0).getXmbm());
			String xm = x1.get(0).getXmmc();
			// ====================================这里面做原先分摊的代码，不用动
			// -----------------------------------------------------------------------------------------
			String temp_str = "";
			Date dt = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
			temp_str = sdf.format(dt);
			String temp_str1 = "";
			Date dt1 = new Date();
			// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
			SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
			temp_str1 = sdf1.format(dt1);
			String maxdjbh = baseMapper.queryByCountjs(ywpzEntity.getDjrq());
			String newdjbh = "";
			if ("".equals(maxdjbh) || maxdjbh == null) {
				newdjbh = "22" + temp_str1 + "0001";
			} else if (!"".equals(maxdjbh) && maxdjbh != null) {
				String aa = Integer.parseInt(maxdjbh) + 1 + "";
				DecimalFormat df = new DecimalFormat("0000");
				String result = df.format(Integer.parseInt(aa));
				newdjbh = "22" + temp_str1 + result;
			}
			// 1.通过该申请单编号修改sqwxzq中的决算状态并产生jsdbh
			ywpzEntity.setJsdbh(newdjbh);
			baseMapper.updatejszt(ywpzEntity);
			// 2.ywpz中记录该决算数据，djbh和jsdbh相同。
			ywpzEntity.setDjbh(newdjbh);
			ywpzEntity.setDjlx("22");
			ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
			ywpzEntity.setDwbm(baseMapper.selectdwbmbyxm(ywpzEntity.getXmbm()));
			ywpzEntity.setJe(ywpzEntity.getJe());
			ywpzEntity.setXgbm(ywpzEntity.getXmbm());
			baseMapper.insertywpzhb(ywpzEntity);
			Double sumdw = 0.0;
			Double sumgr = 0.0;
			// 3.记录余额分摊的明细到ywpzmx表中
			for (FwxxEntity c : ywpzEntity.getFtmx()) {
				YwpzmxEntity m = new YwpzmxEntity();
				
				// 更新每一户分摊之后，grje，dwje，dqye，zqje2的钱
				FwxxEntity f = baseMapper.selectfwxxbyfwbm(c.getFwbm());
				f.setZqje2(f.getZqje2() + c.getZsje());
				f.setDqye(f.getDqye() - c.getZsje());
				ZhxxEntity z = baseMapper.selectzhxxbydhbm(c.getDhbm());
				z.setZqje(z.getZqje() + c.getZsje());
				z.setDqye(z.getDqye() - c.getZsje());
				int val = f.getDwje().compareTo(c.getZsje());
				if (val >= 0) {// 表示单位分配的钱比此次需要分摊的钱多，则只扣单位分配的钱
					//------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(c.getZsje());//此次单位分摊金额
					m.setGrje(0.0);//此次个人分摊金额
					m.setHdwje(f.getDwje() - c.getZsje());//此次分摊后单位金额
					m.setHgrje(f.getGrje());//此次分摊后个人金额
					//---------------------------------------------------
					f.setDwje(f.getDwje() - c.getZsje());
					f.setZqkkfs2("0");
					sumdw = sumdw + c.getZsje();
					
				} else if (val < 0 && f.getDwje() == 0) {// 表示单位分配的钱为0，只能直接扣grje
					//-----------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(0.0);//此次单位分摊金额
					m.setGrje(c.getZsje());//此次个人分摊金额
					m.setHdwje(f.getDwje());//此次分摊后单位金额
					m.setHgrje(f.getGrje()-c.getZsje());//此次分摊后个人金额
					//------------------------------------------------------
					f.setGrje(f.getGrje() - c.getZsje());
					z.setGryjje(z.getGryjje() - c.getZsje());
					f.setZqkkfs2("1");
					sumgr = sumgr + c.getZsje();
					
				} else if (val < 0 && f.getDwje() >= 0) {// 表示单位分配的钱>0但是又不够此次余额分摊的钱，只能先把dwje钱扣完，再扣grje
					double sy = c.getZsje() - f.getDwje();
					sumdw = sumdw + f.getDwje();
					sumgr = sumgr + sy;
					//-------------------------------------------------------------
					m.setQdwje(f.getDwje());//此次分摊前单位金额
					m.setQgrje(f.getGrje());//此次分摊前个人金额
					m.setDwje(f.getDwje());//此次单位分摊金额
					m.setGrje(sy);//此次个人分摊金额
					m.setHdwje(0.0);//此次分摊后单位金额
					m.setHgrje(f.getGrje()-sy);//此次分摊后个人金额
					//-------------------------------------------------------------
					f.setDwje(0.0);
					f.setGrje(f.getGrje() - sy);
					z.setGryjje(z.getGryjje() - sy);
					f.setZqkkfs2("2");
					f.setZqdwje2(c.getZsje() - sy);
					
				}
				//-------------------
				m.setDjbh(newdjbh);
				m.setDhbm(c.getDhbm());
				m.setFwbm(c.getFwbm());
				m.setBjje(c.getZsje());
				m.setJe(c.getZsje());
				m.setJdf("1");
				baseMapper.insertywpzmxx(m);
				//-------------------
				baseMapper.updatefwxxzqje2(f);// 更新每一户分摊之后，grje，dwje，dqye，zqje的钱
				baseMapper.updatezhxxzqje(z);// 更新每一栋的支取金额zqje，dqye,gryjje
			}
			// 4.像ftqc房屋维修分摊清册表录入分摊的房屋记录
			for (FwxxEntity c : ywpzEntity.getFtmx()) {
				c.setSqdbh(ywpzEntity.getSqdbh());
				baseMapper.insertjsqc(c);
			}

			// -----------------------------------------里面是搞辅助核算的
			// 将首次支取分摊产生的业务数据记录到辅助明细表中
			YwpzEntity y0 = baseMapper.selectfzdj2(newdjbh);
			y0.setXm(xm);
			// 将该单据记录到辅助核算明细表中。
			if (sumdw > 0) {
				y0.setJe(sumdw);
				y0.setZqlx("01");
				baseMapper.insertfzhsmx2(y0);
			}
			if (sumgr > 0) {
				y0.setJe(sumgr);
				y0.setZqlx("03");
				baseMapper.insertfzhsmx2(y0);
			}
		}

	}

	@Override
	public void deleteJS(SqwxzqEntity sqwxzqEntity) {
		List<String> djbhs = baseMapper.selectdjbhbysqdbh2(sqwxzqEntity.getSqdbh());
		for (String djbh : djbhs) {
			// -------------------------------------------------------------
			// -------------------------------------------------
			Double sumdw = 0.0;
			Double sumgr = 0.0;
			// 分摊金额返回
			List<FtqcEntity> fts = baseMapper.selectftqcye(djbh);
			for (FtqcEntity c : fts) {
				// 更新每一户分摊之后，grje，dwje，dqye，zqje2的钱
				FwxxEntity f = baseMapper.selectfwxxbyfwbm(c.getFwbm());
				f.setZqje2(f.getZqje2() - c.getZsje());
				f.setDqye(f.getDqye() + c.getZsje());
				ZhxxEntity z = baseMapper.selectzhxxbydhbm(c.getDhbm());
				z.setZqje(z.getZqje() - c.getZsje());
				z.setDqye(z.getDqye() + c.getZsje());
				if ("0".equals(f.getZqkkfs2())) {// 表示单位分配的钱比此次需要分摊的钱多，则只扣单位分配的钱
					f.setDwje(f.getDwje() + c.getZsje());
					sumdw = sumdw + c.getZsje();
				} else if ("1".equals(f.getZqkkfs2())) {// 表示单位分配的钱为0，只能直接扣grje
					f.setGrje(f.getGrje() + c.getZsje());
					z.setGryjje(z.getGryjje() + c.getZsje());
					sumgr = sumgr + c.getZsje();
				} else if ("2".equals(f.getZqkkfs2())) {// 表示单位分配的钱>0但是又不够此次余额分摊的钱，只能先把dwje钱扣完，再扣grje
					f.setDwje(f.getZqdwje2());
					double sy = c.getZsje() - f.getZqdwje2();
					sumdw = sumdw + f.getDwje();
					sumgr = sumgr + sy;
					f.setGrje(f.getGrje() + sy);
					z.setGryjje(z.getGryjje() + sy);
					f.setZqdwje2(0.0);
				}
				f.setZqkkfs2("");
				baseMapper.updatefwxxzqje2(f);// 更新每一户分摊之后，grje，dwje，dqye，zqje2的钱
				baseMapper.updatezhxxzqje(z);// 更新每一栋的支取金额zqje，dqye,gryjje
			}
			// 当余额分摊删除时时，要将该单据从辅助核算明细表中删除
			YwpzEntity y0 = baseMapper.selectfzdj2(djbh);
			if (isObjectNotEmpty(y0) == true) {
				baseMapper.deletefzhsdj(djbh);
			}
		}
		// 删除对应的业务单据
		baseMapper.deletejsywpzmx(sqwxzqEntity.getSqdbh());
		baseMapper.deletejsywpz(sqwxzqEntity.getSqdbh());
		// 清空维修单分摊的关联信息
		baseMapper.updateqxjszt(sqwxzqEntity.getSqdbh());
		// 清空ftqc数据
		baseMapper.deleteftqcye(sqwxzqEntity.getSqdbh());
		// -------------------------------------------------
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageYZTK(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPageYZTK(ywpzEntity);
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	@Override
	public FwxxEntity selectfwxq(FwxxEntity fwxxEntity) {
		FwxxEntity f = baseMapper.selectfwxxby(fwxxEntity.getFwbm());
		// Double yue = f.getGrje() + f.getDwje() + f.getGgsy() - f.getZqje() -
		// f.getXhje();
		if (!"".equals(f.getDqye()) && f.getDqye() != null) {
			f.setYe((double) Math.round(f.getDqye() * 100) / 100);
		}
		try {
			FwxxEntity f2 = baseMapper.selectwygsbydhbm(f.getDhbm());
			if (!"".equals(f2.getWygsmc()) && f2.getWygsmc() != null) {
				f.setWygsmc(f2.getWygsmc());
			}
		} catch (Exception e) {

		}
		return f;
	}

	@Override
	public void insertyztk(YwpzEntity ywpzEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCounttk(temp_str);
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "13" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "13" + temp_str1 + result;
		}
		// 1.ywpz表中记录该数据
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("13");
		ywpzEntity.setKjqj(ywpzEntity.getDjrq().substring(0, 7));
		ywpzEntity.setShrq(temp_str);
		XlkEntity x = baseMapper.selectxmbydh(ywpzEntity.getDhbm());
		ywpzEntity.setDwbm(x.getDwbm());
		baseMapper.insertywpzyztk(ywpzEntity);
		// 2.ywpzmx表中记录退款房屋和退款金额记录
		baseMapper.insertywpzmxyztk(ywpzEntity);
		// 3.根据业主退款，再fwxx表中grje字段中减掉退款金额
		FwxxEntity f = baseMapper.selectfwxx(ywpzEntity.getFwbm());
		f.setGrje(f.getGrje() - ywpzEntity.getJe());
		f.setDqye(f.getDqye() - ywpzEntity.getJe());
		baseMapper.updatefwyztk(f);
		// 4.同时从对应楼幢的gryjje减掉该业主退款金额
		ZhxxEntity z = baseMapper.selectzhxxbydhbm(ywpzEntity.getDhbm());
		z.setGryjje(z.getGryjje() - ywpzEntity.getJe());
		z.setDqye(z.getDqye() - ywpzEntity.getJe());
		baseMapper.updatezhxxgryjje(z);

		// 业主退款的时候将该退款单据记录到辅助核算明细表中
		YwpzEntity yo = baseMapper.selectfzhsmxdj(newdjbh);
		yo.setXm("业主退款_" + yo.getXm());
		baseMapper.insertfzhsmx(yo);
	}

	@Override
	public void insertyzxh(YwpzEntity ywpzEntity) {
		String temp_str = "";
		Date dt = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		temp_str = sdf.format(dt);

		String temp_str1 = "";
		Date dt1 = new Date();
		// 最后的aa表示“上午”或“下午” HH表示24小时制 如果换成hh表示12小时制
		SimpleDateFormat sdf1 = new SimpleDateFormat("yyyyMMddHHmmss");
		temp_str1 = sdf1.format(dt1);
		String maxdjbh = baseMapper.queryByCountxh(temp_str);
		String newdjbh = "";
		if ("".equals(maxdjbh) || maxdjbh == null) {
			newdjbh = "23" + temp_str1 + "0001";
		} else if (!"".equals(maxdjbh) && maxdjbh != null) {
			String aa = Integer.parseInt(maxdjbh) + 1 + "";
			DecimalFormat df = new DecimalFormat("0000");
			String result = df.format(Integer.parseInt(aa));
			newdjbh = "23" + temp_str1 + result;
		}
		// 1.ywpz中新增一条记录，记录销户信息
		ywpzEntity.setDjbh(newdjbh);
		ywpzEntity.setDjlx("23");
		ywpzEntity.setShrq(temp_str);
		XlkEntity x = baseMapper.selectxmbydh(ywpzEntity.getDhbm());
		ywpzEntity.setDwbm(x.getDwbm());
		baseMapper.insertywpzyzxh(ywpzEntity);
		// 2.ywpzmx中也记录对应的销户房屋信息
		baseMapper.insertywpzmxyzxh(ywpzEntity);
		// 3.在zhxx表中记录该楼幢的销户金额xhje字段，xhjx销户结息
		baseMapper.updatezhxxxhje(ywpzEntity);
		// --dqye
		ZhxxEntity zh = baseMapper.selectzhxxdqye(ywpzEntity.getDhbm());
		zh.setDqye(zh.getDqye() - ywpzEntity.getGrje());// 余额-销户金额
		baseMapper.updatezhxxdqye(zh);
		// ---
		// 4.在fwxx表中记录xhje销户结息金额，xhjx销户结息，sfsc=3房屋状态为已销户
		ywpzEntity.setSfsc("3");
		baseMapper.updatefwxxxhje(ywpzEntity);
		// ---
		FwxxEntity ffF = baseMapper.selectfwxxdqye(ywpzEntity.getFwbm());
		ffF.setDqye(ffF.getDqye() - ywpzEntity.getGrje());// 余额-销户金额
		baseMapper.updatefwxxdqye(ffF);
		// ---
	}

	@Override
	public PageInfo<YwpzEntity> queryByPageYZXH(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<YwpzEntity> ywpzEntitys = baseMapper.queryByPageYZXH(ywpzEntity);
		for (YwpzEntity y : ywpzEntitys) {
			y.setSumje(y.getJe() + y.getXhjx());
		}
		PageInfo<YwpzEntity> pageInfo = new PageInfo<YwpzEntity>(ywpzEntitys);
		return pageInfo;
	}

	public List<String> findDates(java.util.Date dBegin, java.util.Date dEnd) {
		List<String> lDate = new ArrayList<String>();
		SimpleDateFormat sd = new SimpleDateFormat("yyyy-MM");
		lDate.add(sd.format(dBegin));
		Calendar calBegin = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calBegin.setTime(dBegin);
		Calendar calEnd = Calendar.getInstance();
		// 使用给定的 Date 设置此 Calendar 的时间
		calEnd.setTime(dEnd);
		// 测试此日期是否在指定日期之后
		while (dEnd.after(calBegin.getTime())) {
			// 根据日历的规则，为给定的日历字段添加或减去指定的时间量
			calBegin.add(Calendar.MONTH, 1);
			lDate.add(sd.format(calBegin.getTime()));
		}
		return lDate;
	}

	public static Boolean isObjectNotEmpty(Object obj) {
		String str = ObjectUtils.toString(obj, "");
		return StringUtils.isNotBlank(str);
	}

	@Override
	public void deleteyztk(YwpzEntity ywpzEntity) {
		// 1.业主退款的时候将该退款单据记录到辅助核算明细表中删除
		baseMapper.deletefzhsdj(ywpzEntity.getDjbh());
		baseMapper.deleteywpz(ywpzEntity.getDjbh());
		baseMapper.deleteywpzmx(ywpzEntity.getDjbh());
		// 2.根据业主退款，再fwxx表中grje字段中减掉退款金额
		FwxxEntity f = baseMapper.selectfwxx(ywpzEntity.getFwbm());
		f.setGrje(f.getGrje() + ywpzEntity.getJe());
		f.setDqye(f.getDqye() + ywpzEntity.getJe());
		baseMapper.updatefwyztk(f);
		// 3.同时从对应楼幢的gryjje减掉该业主退款金额
		ZhxxEntity z = baseMapper.selectzhxxbydhbm(ywpzEntity.getDhbm());
		z.setGryjje(z.getGryjje() + ywpzEntity.getJe());
		z.setDqye(z.getDqye() + ywpzEntity.getJe());
		baseMapper.updatezhxxgryjje(z);
	}

	@Override
	public void zqdjbhjsdbh() {
		// 1.拿到sqwxzq表中所有数据，只拿sqdbh，xmbm，djbh,jsdbh
		//
		// select sqdbh,xmbm,djbh,jsdbh from sqwxzq where czyxm !='huarun'
		//
		// 2.通过每一条数据的djbh找到ywpz中的那条数据，然后把他的sqdbh和xmbm移到ywpz的sqdbh和xmbm上
		// update ywpz set sqdbh=sqdbh,xgbm=xmbm where djbh=djbh
		//
		// 3.通过每一条数据的jsdbh找到ywpz中的那条数据，然后把他的sqdbh和xmbm移到ywpz的sqdbh和xmbm上
		// update ywpz set sqdbh=sqdbh,xgbm=xmbm where djbh=jsdbh
		List<YwpzEntity> list = baseMapper.selectmimi();
		for (YwpzEntity y : list) {
			baseMapper.updatemimi(y);
		}
		for (YwpzEntity y : list) {
			baseMapper.updatemimi2(y);
		}
	}

	@Override
	public PageInfo<FwxxEntity> queryByPageZQMX(Integer pageNum, Integer pageSize, YwpzEntity ywpzEntity) {
		PageHelper.startPage(pageNum, pageSize);
		List<FwxxEntity> list = baseMapper.queryByPageZQMXCX(ywpzEntity);
		Double sumje = 0.0;
		Double sumgrje = 0.0;
		Double sumdwje = 0.0;
		Double sumgrje2 = 0.0;
		Double sumdwje2 = 0.0;
		if(ywpzEntity.getDjlx()==null||"".equals(ywpzEntity.getDjlx())||"21".equals(ywpzEntity.getDjlx())){
			for (FwxxEntity f : list) {
				f.setGrje2(f.getQgrje());
				f.setDwje2(f.getQdwje());
				f.setGrje3(f.getHgrje());
				f.setDwje3(f.getHdwje());
//				// ------------------------------------------------------
//				if (f.getZqje2() > 0) {// 进行了两次分摊
//					if ("0".equals(f.getZqkkfs2())) {// 余额分摊只扣了单位的
//						if ("0".equals(f.getZqkkfs())) {// 首次分摊只扣了单位的
//							f.setDwje2(f.getDwje() + f.getZqje2() + f.getZqje());
//							f.setGrje2(f.getGrje());
//							f.setDwje3(f.getDwje() + f.getZqje2());
//							f.setGrje3(f.getGrje());
//						} else if ("1".equals(f.getZqkkfs())) {// 首次分摊只扣了个人的
//							f.setDwje2(f.getDwje() + f.getZqje2());
//							f.setGrje2(f.getGrje() + f.getZqje());
//							f.setDwje3(f.getDwje() + f.getZqje2());
//							f.setGrje3(f.getGrje());
//						} else if ("2".equals(f.getZqkkfs())) {// 首次分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//							f.setDwje2(f.getDwje() + f.getZqje2() + f.getZqdwje());
//							f.setGrje2(f.getGrje() + (f.getZqje() - f.getZqdwje()));
//							f.setDwje3(f.getDwje() + f.getZqje2());
//							f.setGrje3(f.getGrje());
//						}
//					} else if ("1".equals(f.getZqkkfs2())) {// 余额分摊只扣了个人的
//						if ("0".equals(f.getZqkkfs())) {// 首次分摊只扣了单位的
//							f.setGrje2(f.getGrje() + f.getZqje2());
//							f.setDwje2(f.getDwje() + f.getZqje());
//							f.setGrje3(f.getGrje()+f.getZqje2());
//							f.setDwje3(f.getDwje());
//						} else if ("1".equals(f.getZqkkfs())) {// 首次分摊只扣了个人的
//							f.setGrje2(f.getGrje() + f.getZqje2() + f.getZqje());
//							f.setDwje2(f.getDwje());
//							f.setGrje3(f.getGrje() + f.getZqje2());
//							f.setDwje3(f.getDwje());
//						} else if ("2".equals(f.getZqkkfs())) {// 首次分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//							f.setGrje2(f.getGrje() + f.getZqje2() + (f.getZqje() - f.getZqdwje()));
//							f.setDwje2(f.getDwje() + f.getZqdwje());
//							f.setGrje3(f.getGrje() + f.getZqje2());
//							f.setDwje3(f.getDwje());
//						}
//					} else if ("2".equals(f.getZqkkfs2())) {// 余额分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//						if ("0".equals(f.getZqkkfs())) {// 首次分摊只扣了单位的
//							f.setDwje2(f.getDwje() + f.getZqdwje2() + f.getZqje());
//							f.setGrje2(f.getGrje() + (f.getZqje2() - f.getZqdwje2()));
//							f.setDwje3(f.getDwje() + f.getZqdwje2());
//							f.setGrje3(f.getGrje() + (f.getZqje2() - f.getZqdwje2()));
//						} else if ("1".equals(f.getZqkkfs())) {// 首次分摊只扣了个人的
//							f.setDwje2(f.getDwje() + f.getZqdwje2());
//							f.setGrje2(f.getGrje() + (f.getZqje2() - f.getZqdwje2()) + f.getZqje());
//							f.setDwje3(f.getDwje() + f.getZqdwje2());
//							f.setGrje3(f.getGrje() + (f.getZqje2() - f.getZqdwje2()));
//						} else if ("2".equals(f.getZqkkfs())) {// 首次分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//							f.setDwje2(f.getDwje() + f.getZqdwje2() + f.getZqdwje());
//							f.setGrje2(f.getGrje() + (f.getZqje2() - f.getZqdwje2()) + (f.getZqje() - f.getZqdwje()));
//							f.setDwje3(f.getDwje() + f.getZqdwje2());
//							f.setGrje3(f.getGrje() + (f.getZqje2() - f.getZqdwje2()));
//						}
//					}
//				} else if (f.getZqje2() == 0) {// 只做了首次分摊
//					if ("0".equals(f.getZqkkfs())) {// 首次分摊只扣了单位的
//						f.setDwje2(f.getDwje()+f.getZqje());
//						f.setGrje2(f.getGrje());
//						f.setDwje3(f.getDwje());
//						f.setGrje3(f.getGrje());
//					} else if ("1".equals(f.getZqkkfs())) {// 首次分摊只扣了个人的
//						f.setGrje2(f.getGrje() + f.getZqje());
//						f.setDwje2(f.getDwje());
//						f.setGrje3(f.getGrje());
//						f.setDwje3(f.getDwje());
//					} else if ("2".equals(f.getZqkkfs())) {// 首次分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//						f.setDwje2(f.getDwje() + f.getZqdwje());
//						f.setGrje2(f.getGrje() + (f.getZqje() - f.getZqdwje()));
//						f.setDwje3(f.getDwje() );
//						f.setGrje3(f.getGrje() );
//					}
//				}
//				// ------------------------------------------------------
				if (f.getJe() != null) {
					sumje+=f.getJe();
				}
				if (f.getGrje3() != null) {
					sumgrje+=f.getGrje3();
				}
				if (f.getDwje3() != null) {
					sumdwje+=f.getDwje3();
				}
				if (f.getGrje2() != null) {
					sumgrje2+=f.getGrje2();
				}
				if (f.getDwje2() != null) {
					sumdwje2+=f.getDwje2();
				}
			}
		}else if("22".equals(ywpzEntity.getDjlx())){
			for (FwxxEntity f : list) {
				f.setGrje2(f.getQgrje());
				f.setDwje2(f.getQdwje());
				f.setGrje3(f.getHgrje());
				f.setDwje3(f.getHdwje());
//				// -------------------------------------------------------------------------------
//				if ("0".equals(f.getZqkkfs2())) {// 余额分摊只扣了单位的
//					f.setDwje2(f.getDwje() + f.getZqje2());
//					f.setGrje2(f.getGrje());
//					f.setDwje3(f.getDwje());
//					f.setGrje3(f.getGrje());
//				} else if ("1".equals(f.getZqkkfs2())) {// 余额分摊只扣了个人的
//					f.setGrje2(f.getGrje() + f.getZqje2());
//					f.setDwje2(f.getDwje());
//					f.setGrje3(f.getGrje());
//					f.setDwje3(f.getDwje());
//				} else if ("2".equals(f.getZqkkfs2())) {// 余额分摊先扣单位再扣个人，单位扣的钱在zqdwje2
//					f.setDwje2(f.getDwje() + f.getZqdwje2());
//					f.setGrje2(f.getGrje() + (f.getZqje2() - f.getZqdwje2()));
//					f.setDwje3(f.getDwje());
//					f.setGrje3(f.getGrje());
//				}
//				// -------------------------------------------------------------------------------
				if (f.getJe() != null) {
					sumje+=f.getJe();
				}
				if (f.getGrje3() != null) {
					sumgrje+=f.getGrje3();
				}
				if (f.getDwje3() != null) {
					sumdwje+=f.getDwje3();
				}
				if (f.getGrje2() != null) {
					sumgrje2+=f.getGrje2();
				}
				if (f.getDwje2() != null) {
					sumdwje2+=f.getDwje2();
				}
			}
			
		}
		FwxxEntity fEntity=new FwxxEntity();
		fEntity.setSumje(sumje);
		fEntity.setSumdwje(sumdwje);
		fEntity.setSumgrje(sumgrje);
		fEntity.setSumdwje2(sumdwje2);
		fEntity.setSumgrje2(sumgrje2);
		list.add(fEntity);
		PageInfo<FwxxEntity> pageInfo = new PageInfo<FwxxEntity>(list);
		return pageInfo;
	}

	@Override
	public void ftddddd() {
		List<FwxxEntity> fs=baseMapper.selectfw();
		for(FwxxEntity f:fs){
			List<YwpzmxEntity> ms=baseMapper.selectfwmxxxx(f.getFwbm());
			if("0".equals(f.getZqkkfs())){
				for(YwpzmxEntity m:ms){
					m.setDwje(f.getZqje());
					baseMapper.updateywpzmxft(m);
				}
			}else if("1".equals(f.getZqkkfs())){
				for(YwpzmxEntity m:ms){
					m.setGrje(f.getZqje());
					baseMapper.updateywpzmxft2(m);
				}
			}else if("2".equals(f.getZqkkfs())){
				for(YwpzmxEntity m:ms){
					m.setDwje(f.getZqdwje());
					m.setGrje(f.getZqje()-f.getZqdwje());
					baseMapper.updateywpzmxft3(m);
				}
			}
		}
	}

	@Override
	public void ftddddd2() {
		List<FwxxEntity> fs=baseMapper.selectfw2();
		for(FwxxEntity f:fs){
			List<YwpzmxEntity> ms=baseMapper.selectfwmxxxx2(f.getFwbm());
			if("0".equals(f.getZqkkfs2())){
				for(YwpzmxEntity m:ms){
					m.setDwje(f.getZqje2());
					baseMapper.updateywpzmxft(m);
				}
			}else if("1".equals(f.getZqkkfs2())){
				for(YwpzmxEntity m:ms){
					m.setGrje(f.getZqje2());
					baseMapper.updateywpzmxft2(m);
				}
			}else if("2".equals(f.getZqkkfs2())){
				for(YwpzmxEntity m:ms){
					m.setDwje(f.getZqdwje2());
					m.setGrje(f.getZqje2()-f.getZqdwje2());
					baseMapper.updateywpzmxft3(m);
				}
			}
		}
		
	}

}