package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.modules.app.dao.HKmlbDao;
import io.renren.modules.app.entity.HKmlbEntity;
import io.renren.modules.app.service.HKmlbService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("hKmlbService")
public class HKmlbServiceImpl extends ServiceImpl<HKmlbDao, HKmlbEntity> implements HKmlbService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param hKmlbEntity
     * @return
     */
    @Override
    public PageInfo<HKmlbEntity> queryByPage(Integer pageNum, Integer pageSize, HKmlbEntity hKmlbEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<HKmlbEntity> hKmlbEntitys = baseMapper.queryByPage(hKmlbEntity);
        PageInfo<HKmlbEntity> pageInfo = new PageInfo<HKmlbEntity>(hKmlbEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }


}