package io.renren.modules.app.service.impl;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

import org.springframework.stereotype.Service;
import com.baomidou.mybatisplus.service.impl.ServiceImpl;

import io.renren.modules.app.dao.SanlszzDao;
import io.renren.modules.app.entity.SanlszzEntity;
import io.renren.modules.app.service.SanlszzService;

@Service("sanlszzService")
public class SanlszzServiceImpl extends ServiceImpl<SanlszzDao, SanlszzEntity> implements SanlszzService {
	
	//三栏式总账表查询
	@Override
	public List<SanlszzEntity> sanlszzSelect(SanlszzEntity sanlszzEntity)
			throws Exception {
		List<SanlszzEntity> list =  baseMapper.sanlszzSelect(sanlszzEntity);
		double ye = 0.0;
		if (list.size() > 0) {
			if (list.get(0).getKmsx().equals("0")) {
				list.get(0).setKmsxmc("借方");
			} else {
				list.get(0).setKmsxmc("贷方");
			}
		}
		for (int i = 0; i < list.size(); i++) {
			if (i == 0) {
				ye = Double.parseDouble(list.get(i).getQcye());
				continue;
			}
			double tmpJFJE = list.get(i).getJfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getJfje());
			double tmpDFJE = list.get(i).getDfje().equals("0") ? 0.0 : Double.parseDouble(list.get(i).getDfje());
			if (list.get(i).getKmsx().equals("0")) {
				ye = ye + tmpJFJE - tmpDFJE;

				// 保留两位小数四舍五入
				BigDecimal b = new BigDecimal(ye);
				double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

				DecimalFormat df = new DecimalFormat("0.00");// 格式化
				String qcye = df.format(f1);

				list.get(i).setKmsxmc("借方");
				list.get(i).setQcye(qcye);
			}else{
				ye = ye - tmpJFJE + tmpDFJE;

				// 保留两位小数四舍五入
				BigDecimal b = new BigDecimal(ye);
				double f1 = b.setScale(2, BigDecimal.ROUND_HALF_UP).doubleValue();

				DecimalFormat df = new DecimalFormat("0.00");// 格式化
				String qcye = df.format(f1);

				list.get(i).setKmsxmc("贷方");
				list.get(i).setQcye(qcye);
			}
		}
		

		return list;
	}

}
