package io.renren.modules.app.service.impl;


import com.baomidou.mybatisplus.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;

import io.renren.common.utils.R;
import io.renren.modules.app.dao.SysDictDao;
import io.renren.modules.app.entity.SysDictEntity;
import io.renren.modules.app.service.SysDictService;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;


@Service("sysDictService")
public class SysDictServiceImpl extends ServiceImpl<SysDictDao, SysDictEntity> implements SysDictService {


    /**
     * 分页模糊查询
     * @param pageNum
     * @param pageSize
     * @param sysDictEntity
     * @return
     */
    @Override
    public PageInfo<SysDictEntity> queryByPage(Integer pageNum, Integer pageSize, SysDictEntity sysDictEntity) {
        PageHelper.startPage(pageNum, pageSize);
        List<SysDictEntity> sysDictEntitys = baseMapper.queryByPage(sysDictEntity);
        PageInfo<SysDictEntity> pageInfo = new PageInfo<SysDictEntity>(sysDictEntitys);
        return pageInfo;
    }

    /**
    * 单个或批量删除
    * @param ids
    */
    @Override
    public void deleteBatch(String[] ids) {
        this.deleteBatchIds(Arrays.asList(ids));
    }



    /**
     * 字典名称下拉列表（查询用）
     */
    @Override
    public R queryList(SysDictEntity sysDictEntity) {
        if(sysDictEntity.getType()==null || ("").equals(sysDictEntity.getType())){
            return R.error("列表类型不能为空！");
        }
        return R.ok().put("data",baseMapper.queryList(sysDictEntity));
    }


    /**
     * 字典名称下拉列表（本页面查询用）
     */
    @Override
    public R queryListLocal(SysDictEntity sysDictEntity) {
        return R.ok().put("data",baseMapper.queryListLocal(sysDictEntity));
    }

    /**
     * 新增字典
     */
	@Override
	public void insertSys_dict(SysDictEntity dictEntity) {
		
		
	}

	/**
	 * 字典下拉框
	 */
	@Override
	public List<SysDictEntity> zdxlk() {
		
		return baseMapper.zdxlk();
	}

	/**
	 * 查询字典码是否已有
	 */
	@Override
	public int selectCode(SysDictEntity sysDictEntity) {
		int num = baseMapper.selectCode(sysDictEntity);
		return num;
	}

	/**
	 * 新增字典信息
	 */
	@Override
	public int insertZDInfo(SysDictEntity sysDictEntity) {
		SysDictEntity sysDictEntity2 = sysDictEntity;
		//当前最大id
		String id = baseMapper.selectMaxID(sysDictEntity.getType());
		//获取类型后的字符
		int endIndex = 0;
		String type = sysDictEntity.getType();
	
		endIndex = id.length();
		
		String num2 = id.substring(2, endIndex);
		int num3 = Integer.parseInt(num2)+1;
		String id2 = type + num3;
		sysDictEntity2.setId(id2);
		int num = baseMapper.insertZDInfo(sysDictEntity2);
		return num;
	}


}