package io.renren.modules.app.controller;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.XlkEntity;
import io.renren.modules.app.entity.YwpzDyEntity;
import io.renren.modules.app.entity.YwpzEntity;
import io.renren.modules.app.entity.ZhxxEntity;
import io.renren.modules.app.service.DwjktzsService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

/**
 * 单位缴款通知书
 *
 * @author ly
 * @email 1271428398@qq.com
 * @date 2019-03-22 09:53:01
 */
@RestController
@RequestMapping("app/dwjktzs")
@Api(tags = "单位缴款通知书模块(单位缴款通知书)")
public class DwjktzsController {

	@Autowired
	private DwjktzsService dwjktzsService;

	@Login
	@PostMapping("/selectxlk")
	@ApiOperation(value = "下拉框查询", notes = "", response = XlkEntity.class)
	public R selectxlk(@RequestBody Map<String, String> map) {

		return R.ok().put("list", dwjktzsService.selectxlk(map));
	}
	
	@Login
	@GetMapping("/queryByPage")
	@ApiOperation(value = "幢号信息列表查询", notes = "", response = ZhxxEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize, ZhxxEntity zhxxEntity) {

		return R.ok().put("data", dwjktzsService.queryByPage(pageNum, pageSize,zhxxEntity));
	}
	
	
	
	@Login
    @PostMapping("/insert")
    @ApiOperation(value = "保存", notes = "", response = YwpzEntity.class)
    public R insert(@RequestBody YwpzDyEntity ywpzdyEntity) {
		dwjktzsService.insertBc(ywpzdyEntity);
        return R.ok();
    }
	
	@Login
	@GetMapping("/queryByPageC")
	@ApiOperation(value = "查询按钮", notes = "", response = YwpzDyEntity.class)
	public R queryByPageC(Integer pageNum, Integer pageSize, YwpzDyEntity ywpzDyEntity) {

		return R.ok().put("data", dwjktzsService.queryByPageC(pageNum, pageSize,ywpzDyEntity));
	}
	
	@Login
	@PostMapping("/delete")
	@ApiOperation(value = "删除按钮", notes = "")
	public R delete(@RequestBody XlkEntity xlkEntity) {
		dwjktzsService.deletedy(xlkEntity);
		return R.ok();
	}

}
