package io.renren.modules.app.controller;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import io.renren.common.utils.R;
import io.renren.modules.app.annotation.Login;
import io.renren.modules.app.entity.FhmxzEntity;
import io.renren.modules.app.entity.XqxxSelectEntity;
import io.renren.modules.app.service.XqxxSelectService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

/**
 * 小区信息查询
 * @author Administrator
 *
 */
@RestController
@RequestMapping("app/xqxxselect")
@Api(tags = "小区信息查询")
public class XqxxSelectController {
	@Autowired
	private XqxxSelectService xqxxSelectService;
	
	@Login
	@GetMapping("selectXqxxByPage")
	@ApiOperation(value = "列表", notes = "带分页、模糊查询，查询关键字：(请补充...)", response = XqxxSelectEntity.class)
	public R queryByPage(Integer pageNum, Integer pageSize,XqxxSelectEntity xqxxSelectEntity) {
		return R.ok().put("data", xqxxSelectService.selectXqxxByPage(pageNum, pageSize, xqxxSelectEntity));
	}
}
